/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Image m_image = null;
    int m_imageWidth = 0;
    int m_imageHeight = 0;
    boolean m_stretch = false;
    boolean m_init = false;

    public ImagePanel() {
    }

    public ImagePanel(Image image, boolean stretch) {
        this.m_image = image;
        this.m_stretch = stretch;
        this.postLoadImage();
    }

    public ImagePanel(Class<?> resLoader, String fileName, boolean stretch) {
        this.init(resLoader, fileName, stretch);
        this.putClientProperty("cssClass", "imagePanel");
    }

    public boolean isInit() {
        return this.m_image != null && this.m_init;
    }

    public void init(Class<?> resLoader, String fileName, boolean stretch) {
        this.m_stretch = stretch;
        this.loadImage(resLoader, fileName);
    }

    private boolean loadImage(Class<?> resLoader, String fileName) {
        if (fileName == null || fileName.length() < 1) {
            return false;
        }
        if (resLoader == null) {
            try {
                ClassLoader resourceLoader = MessageResources.getClassLoader(".");
                this.m_image = Toolkit.getDefaultToolkit().getImage(resourceLoader.getResource(fileName));
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtilities.logException(e);
            }
            catch (MalformedURLException e) {
                LoggerUtilities.logException(e);
            }
        } else {
            this.m_image = Toolkit.getDefaultToolkit().getImage(resLoader.getResource(fileName));
        }
        return this.postLoadImage();
    }

    public boolean postLoadImage() {
        if (this.m_image == null) {
            return false;
        }
        if (this.m_init) {
            return true;
        }
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.m_image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            LoggerUtilities.logException(ie);
            Thread.currentThread().interrupt();
            return false;
        }
        this.m_imageWidth = this.m_image.getWidth(this);
        this.m_imageHeight = this.m_image.getHeight(this);
        this.m_init = true;
        return true;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.m_init) {
            this.postLoadImage();
        }
        if (this.m_init) {
            Dimension d = this.getSize();
            if (this.m_stretch) {
                g.drawImage(this.m_image, 0, 0, d.width, d.height, this);
            } else {
                int y;
                int x = (d.width - this.m_imageWidth) / 2;
                if (x < 0) {
                    x = 0;
                }
                if ((y = (d.height - this.m_imageHeight) / 2) < 0) {
                    y = 0;
                }
                g.drawImage(this.m_image, x, y, this);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.m_init) {
            this.postLoadImage();
        }
        return new Dimension(this.m_imageWidth, this.m_imageHeight);
    }
}

