/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.util.Base64Util;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpCertUtil {
    public static final Pattern X509_CERT_COOKIE_VALUE_PATTERN = Pattern.compile(Pattern.quote("cookie.") + Pattern.quote("LoginCertificate") + "=\"([^\"]+)\"?");

    private HttpCertUtil() {
    }

    public static List<X509Certificate> getCertificatesFromHttpConnection(HttpServletRequest request) {
        return Optional.ofNullable(request).filter(r -> HttpCertUtil.isLocalIP()).map(r -> (X509Certificate[])r.getAttribute("javax.servlet.request.X509Certificate")).filter(c -> ((X509Certificate[])c).length > 0).map(Arrays::asList).orElseGet(() -> HttpCertUtil.getCertificatesFromHeaderCookie(request));
    }

    public static List<X509Certificate> getCertificatesFromHeaderCookie(HttpServletRequest request) {
        return Optional.ofNullable(request).filter(r -> HttpCertUtil.isLocalIP()).map(r -> r.getHeader("cookie")).map(X509_CERT_COOKIE_VALUE_PATTERN::matcher).filter(Matcher::find).map(m -> m.group(1)).map(Base64Util::decode).flatMap(HttpCertUtil::toX509Certificates).map(List::of).orElseGet(List::of);
    }

    private static boolean isLocalIP() {
        try {
            InetAddress localJvmAddress = InetAddress.getLocalHost();
            String consoleJvmIp = localJvmAddress.getHostAddress();
            return Utility.isLocalIPAddress(consoleJvmIp);
        }
        catch (UnknownHostException e) {
            LoggerUtilities.logException(e);
            return false;
        }
    }

    public static Optional<X509Certificate> toX509Certificates(byte[] data) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate pivClientCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
            return Optional.of(pivClientCert);
        }
        catch (CertificateException e) {
            LoggerUtilities.logException(e);
            return Optional.empty();
        }
    }
}

