/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.util.HTMLUtilities;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class HtmlEnabledJLabel
extends JLabel {
    private static final long serialVersionUID = 1L;

    public HtmlEnabledJLabel() {
    }

    public HtmlEnabledJLabel(boolean link) {
        this.setLink(link);
    }

    public HtmlEnabledJLabel(String text) {
        super(text);
    }

    public HtmlEnabledJLabel(String text, boolean link) {
        super(text);
        this.setLink(link);
    }

    public HtmlEnabledJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public void setLink(boolean link) {
        if (link) {
            this.attachDefaultMouseAdapter();
            this.putClientProperty("mouseEventListener", "onClick");
            this.putClientProperty("cssClass", "hyperLinkCLS");
        }
    }

    private void attachDefaultMouseAdapter() {
        this.unhighlightLink();
        this.setCursor(Cursor.getPredefinedCursor(12));
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                HtmlEnabledJLabel.this.highlightLink();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                HtmlEnabledJLabel.this.unhighlightLink();
            }
        };
        this.addMouseListener(adapter);
    }

    public void highlightLink() {
        HTMLUtilities.highlightHyperLink(this);
    }

    public void unhighlightLink() {
        HTMLUtilities.enableHyperLink(this);
    }
}

