/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.DescriptionTextArea;
import com.sygate.scm.util.URLUtility;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle resourceBundle = MessageResources.getResourceBundle("com.sygate.scm.common.ui.ui");

    public HTMLEditorPane(final Component parent) {
        this.setContentType("text/html");
        this.setFocusable(false);
        this.setOpaque(false);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String strURL = e.getURL().toString();
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                        ClientAgent.getCurrentInstance().openInNewTab(strURL);
                        return;
                    }
                    int urlRet = URLUtility.browseURI(strURL);
                    String msg = null;
                    switch (urlRet) {
                        case 1: {
                            msg = resourceBundle.getString("BrowseURI.error.ErrorURL");
                            System.out.println(msg);
                            HTMLEditorPane.showErrorDialog(parent, msg);
                            break;
                        }
                        case 3: {
                            msg = resourceBundle.getString("BrowseURI.error.NeedDefaultBrowser");
                            System.out.println(msg);
                            HTMLEditorPane.showErrorDialog(parent, msg);
                            break;
                        }
                        case 2: {
                            msg = resourceBundle.getString("BrowseURI.error.OSCannotSupport");
                            System.out.println(msg);
                            HTMLEditorPane.showErrorDialog(parent, msg);
                            break;
                        }
                    }
                }
            }
        });
    }

    private static void showErrorDialog(Component parent, String message) {
        String title = resourceBundle.getString("ErrorDialog.title");
        HTMLEditorPane.showMessageDialog(parent, message, title);
    }

    private static void showMessageDialog(Component parent, String message, String title) {
        int msgLength = 0;
        int columnSize = 40;
        if (message != null) {
            msgLength = message.length();
        }
        if (msgLength > 120) {
            columnSize = 60;
        }
        JOptionPane.showMessageDialog(parent, new DescriptionTextArea(message, columnSize), title, 0);
    }
}

