/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class FileChooserListUI
extends BasicListUI {
    private static final int CELL_HEIGHT = new JTextField().getPreferredSize().height;
    private static final int ADDITIONAL_CELL_WIDTH = new JTextField().getPreferredSize().width;

    public static ComponentUI createUI(JComponent component) {
        return new FileChooserListUI();
    }

    @Override
    protected void updateLayoutState() {
        if (Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"))) {
            ListModel dataModel = this.list.getModel();
            int dataModelSize = dataModel.getSize();
            ListCellRenderer renderer = this.list.getCellRenderer();
            if (renderer != null) {
                for (int index = 0; index < dataModelSize; ++index) {
                    Object value = dataModel.getElementAt(index);
                    Component c = renderer.getListCellRendererComponent(this.list, value, index, false, false);
                    Dimension cellSize = c.getPreferredSize();
                    this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                }
            }
            if (CELL_HEIGHT > 0) {
                this.list.setFixedCellHeight(CELL_HEIGHT);
            }
            if (this.cellWidth > 0) {
                this.list.setFixedCellWidth(this.cellWidth + ADDITIONAL_CELL_WIDTH);
            }
        }
        super.updateLayoutState();
    }
}

