/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.Icon;

public class DescriptionHTMLLabel
extends HtmlEnabledJLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 6461859776903682654L;
    public static final String SEPM_URL_FONTCOLOR_BEGIN = "<font color=#0076a3>";
    public static final String SEPM_URL_FONTCOLOR_END = "</font>";
    private int column;
    private String prefixText = "";
    private String originalUrlText = "";
    private String suffixText = "";
    private String url = "";
    private String textBeforeUrlInTheFirstLine = "";
    private int urlFristLineNum = 0;
    private boolean needIncreaseLineNum = true;
    private int urlLineCount = 0;
    private String wrappedUrlStr = "";
    private String urlInTheLastLine = "";

    public DescriptionHTMLLabel(String prefix, String urlText, String suffix, String url, int column) {
        this.column = column;
        this.url = null == url ? "" : url;
        this.prefixText = null == prefix ? "" : prefix;
        this.originalUrlText = null == urlText ? "" : urlText.trim();
        this.wrappedUrlStr = this.originalUrlText;
        this.suffixText = null == suffix ? "" : suffix;
        this.initText();
        this.initAction();
    }

    public DescriptionHTMLLabel(String des, int com) {
        this(des, null, null, null, com);
    }

    public DescriptionHTMLLabel(String des) {
        this(des, null, null, null);
    }

    public DescriptionHTMLLabel(String prefix, String urlText, String suffix, String url) {
        this(prefix, urlText, suffix, url, 64);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled() && this.isOnLink(e)) {
            try {
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    ClientAgent.getCurrentInstance().openInNewTab(this.url);
                    return;
                }
                int urlRet = URLUtility.browseURI(this.url);
                switch (urlRet) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (System.getProperty("os.name").indexOf("Window") == 0) {
                            String[] cmd = new String[]{"cmd", "/c", "start", this.url.trim()};
                            Runtime.getRuntime().exec(cmd);
                            break;
                        }
                        Runtime.getRuntime().exec("netscape " + this.url);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                LoggerUtilities.logException(ioe);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mev) {
        this.resetCursor(mev);
    }

    @Override
    public void mouseExited(MouseEvent mev) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent mev) {
        this.resetCursor(mev);
    }

    @Override
    public void mouseDragged(MouseEvent mev) {
    }

    private void initAction() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void resetCursor(MouseEvent mev) {
        boolean onLink = this.isOnLink(mev);
        boolean isDefaultCursor = this.getCursor().equals(Cursor.getDefaultCursor());
        if (this.isEnabled() && onLink && isDefaultCursor) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (!onLink && !isDefaultCursor) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void initText() {
        String msg;
        String prefixstr = "";
        String suffixStr = "";
        String replaceStr = "";
        Object text = "";
        if (!StringUtilities.isEmpty(this.prefixText)) {
            text = (String)text + this.prefixText;
        }
        if (!StringUtilities.isEmpty(this.originalUrlText)) {
            text = !StringUtilities.isEmpty((String)text) ? (String)text + " " + this.originalUrlText : (String)text + this.originalUrlText;
            StringBuilder buf = new StringBuilder();
            char replaceChar = this.getReplaceChar().charValue();
            for (int i = 0; i < this.originalUrlText.length(); ++i) {
                buf.append(replaceChar);
            }
            replaceStr = buf.toString();
        }
        if (!StringUtilities.isEmpty(this.suffixText)) {
            text = !StringUtilities.isEmpty((String)text) ? (String)text + " " + this.suffixText : (String)text + this.suffixText;
        }
        if (!StringUtilities.isEmpty(this.originalUrlText)) {
            prefixstr = this.prefixText.replaceAll(this.originalUrlText, replaceStr);
            suffixStr = this.suffixText.replaceAll(this.originalUrlText, replaceStr);
            text = prefixstr + " " + this.originalUrlText + " " + suffixStr;
            msg = this.getLabelText((String)text).replaceAll(this.wrappedUrlStr, SEPM_URL_FONTCOLOR_BEGIN + this.wrappedUrlStr + SEPM_URL_FONTCOLOR_END).replaceAll(replaceStr, this.originalUrlText);
        } else {
            msg = this.getLabelText((String)text);
        }
        super.setText("<html><body>" + msg + "</body></html>");
    }

    private boolean isOnLink(MouseEvent mev) {
        boolean isMouseBetweenTheFisrtAndLastLine;
        Icon icon = this.getIcon();
        int iconWidth = 0;
        int iconHight = 0;
        int horizontalTextPosition = this.getHorizontalTextPosition();
        int verticalTextPosition = this.getVerticalTextPosition();
        if (null != icon && (horizontalTextPosition == 4 || horizontalTextPosition == 11)) {
            iconWidth = icon.getIconWidth();
        }
        if (null != icon && horizontalTextPosition == 0 && verticalTextPosition == 3) {
            iconHight = icon.getIconHeight();
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int mevY = mev.getY() - iconHight;
        int mevX = mev.getX() - iconWidth;
        boolean isMouseOnTheFirstUrlLine = mevY >= fm.getHeight() * (this.urlFristLineNum - 1) && mevY <= fm.getHeight() * this.urlFristLineNum;
        boolean isMouseOnTheLastUrlLine = mevY >= fm.getHeight() * (this.urlFristLineNum - 1 + this.urlLineCount - 1) && mevY <= fm.getHeight() * (this.urlFristLineNum + this.urlLineCount - 1);
        boolean bl = isMouseBetweenTheFisrtAndLastLine = mevY >= fm.getHeight() * this.urlFristLineNum && mevY <= fm.getHeight() * (this.urlFristLineNum + this.urlLineCount - 2);
        if (isMouseOnTheFirstUrlLine) {
            String urlTextInTheLine;
            int urlIndexInTheLine = this.wrappedUrlStr.indexOf("<br>");
            String string = urlTextInTheLine = urlIndexInTheLine > 0 ? this.wrappedUrlStr.substring(0, urlIndexInTheLine) : this.wrappedUrlStr;
            if (StringUtilities.isEmpty(urlTextInTheLine)) {
                return false;
            }
            int urlWidth = fm.stringWidth(urlTextInTheLine);
            if ((mevX -= fm.stringWidth(this.textBeforeUrlInTheFirstLine)) >= 0 && mevX <= urlWidth) {
                return true;
            }
        } else if (isMouseOnTheLastUrlLine) {
            if (StringUtilities.isEmpty(this.urlInTheLastLine)) {
                return false;
            }
            int urlWidth = fm.stringWidth(this.urlInTheLastLine);
            if (mevX >= 0 && mevX <= urlWidth) {
                return true;
            }
        } else if (isMouseBetweenTheFisrtAndLastLine) {
            return true;
        }
        return false;
    }

    public String getLabelText(String text) {
        Object temp = "";
        int index = text.indexOf("\n");
        if (index == 0) {
            temp = (String)temp + "<br>";
            if (this.needIncreaseLineNum) {
                ++this.urlFristLineNum;
            }
            String subStr = text.substring(1);
            temp = (String)temp + this.getLabelText(subStr);
        } else if (index > 0) {
            String subStr = text.substring(0, index);
            temp = (String)temp + this.wrapLineText(subStr);
            String remainStr = text.substring(subStr.length());
            temp = (String)temp + this.getLabelText(remainStr);
        } else {
            temp = (String)temp + this.wrapLineText(text);
        }
        return temp;
    }

    public String wrapLineText(String text) {
        int urlBegin;
        Object temp = "";
        String inString = text;
        Object urlString = "";
        if (!StringUtilities.isEmpty(this.originalUrlText) && !StringUtilities.isEmpty(this.url) && text.indexOf(this.originalUrlText) >= 0) {
            urlString = "<a href='";
            urlString = (String)urlString + this.url;
            urlString = (String)urlString + "'>";
            urlString = (String)urlString + this.originalUrlText;
            urlString = (String)urlString + "</a>";
        } else if (!StringUtilities.isEmpty(this.originalUrlText) && StringUtilities.isEmpty(this.url)) {
            urlString = this.originalUrlText;
        }
        while (inString.length() > this.column) {
            urlBegin = inString.indexOf(this.originalUrlText);
            int index = inString.indexOf(" ", this.column);
            if (index < 0) break;
            if (this.needIncreaseLineNum) {
                ++this.urlFristLineNum;
            }
            if (urlBegin >= this.column) {
                temp = (String)temp + inString.substring(0, index) + "<br>";
            } else if (urlBegin > 0) {
                temp = (String)temp + inString.substring(0, urlBegin);
                temp = (String)temp + (String)urlString;
                this.textBeforeUrlInTheFirstLine = inString.substring(0, inString.indexOf(this.originalUrlText));
                this.needIncreaseLineNum = false;
                String wrapStr = text.substring(text.indexOf(this.textBeforeUrlInTheFirstLine + this.originalUrlText), text.indexOf(this.textBeforeUrlInTheFirstLine + this.originalUrlText) + this.textBeforeUrlInTheFirstLine.length() + this.originalUrlText.length());
                if (wrapStr.indexOf(" ", this.column) >= 0 && urlBegin + this.originalUrlText.length() > wrapStr.indexOf(" ", this.column)) {
                    String wrappedStr = this.getWrappedURLStr(wrapStr);
                    this.urlLineCount = wrappedStr.split("<br>").length;
                    this.wrappedUrlStr = wrappedStr.substring(this.textBeforeUrlInTheFirstLine.length());
                    if (this.wrappedUrlStr.lastIndexOf("<br>") >= 0) {
                        this.urlInTheLastLine = this.wrappedUrlStr.substring(this.wrappedUrlStr.lastIndexOf("<br>") + "<br>".length());
                    }
                }
                if (urlBegin + this.originalUrlText.length() < index) {
                    temp = (String)temp + inString.substring(urlBegin + this.originalUrlText.length(), index);
                }
                temp = (String)temp + "<br>";
            } else {
                temp = (String)temp + inString.substring(0, index) + "<br>";
            }
            inString = inString.substring(++index);
        }
        if (!StringUtilities.isEmpty(inString)) {
            if (inString.indexOf(this.originalUrlText) >= 0) {
                urlBegin = inString.indexOf(this.originalUrlText);
                temp = (String)temp + inString.substring(0, urlBegin);
                temp = (String)temp + (String)urlString;
                if (urlBegin + this.originalUrlText.length() < inString.length()) {
                    temp = (String)temp + inString.substring(urlBegin + this.originalUrlText.length());
                }
                if (this.needIncreaseLineNum) {
                    ++this.urlFristLineNum;
                }
                this.textBeforeUrlInTheFirstLine = inString.substring(0, inString.indexOf(this.originalUrlText));
                this.needIncreaseLineNum = false;
            } else {
                temp = (String)temp + inString;
            }
        }
        return ((String)temp).toString();
    }

    public String getWrappedURLStr(String url) {
        StringBuffer temp = new StringBuffer();
        String inString = url;
        int index = inString.indexOf(" ", this.column);
        while (index > 0) {
            temp.append(inString.substring(0, index) + "<br>");
            inString = inString.substring(++index);
            index = inString.indexOf(" ", this.column);
        }
        return temp + inString;
    }

    public Character getReplaceChar() {
        String replacedStr = this.prefixText + this.suffixText + this.originalUrlText;
        Character replaceStr = null;
        if (StringUtilities.isEmpty(replacedStr)) {
            return null;
        }
        if (replacedStr.indexOf("#") < 0) {
            replaceStr = Character.valueOf('#');
        } else if (replacedStr.indexOf("%") < 0) {
            replaceStr = Character.valueOf('%');
        } else if (replacedStr.indexOf("*") < 0) {
            replaceStr = Character.valueOf('*');
        } else if (replacedStr.indexOf("&") < 0) {
            replaceStr = Character.valueOf('&');
        } else if (replacedStr.indexOf("@") < 0) {
            replaceStr = Character.valueOf('@');
        }
        return replaceStr;
    }
}

