/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.ReadOnlyTextArea;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DatabaseFilestreamOptionPanel
extends JPanel {
    private static final long serialVersionUID = -5432647536549020628L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.util.util");
    private ReadOnlyTextArea heading = new ReadOnlyTextArea(this, MSG_RES.getString("database.filestream.heading"));
    private JCheckBox filestreamChk = null;
    private boolean filestreamEnabledDb;
    private boolean isDefineNewDB;
    private boolean isSQLServerExpress;

    public DatabaseFilestreamOptionPanel() {
        this.init();
    }

    private void init() {
        if (this.filestreamChk == null) {
            this.filestreamChk = new JCheckBox(MSG_RES.getString("database.filestream.heckbox.label"));
            this.filestreamChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseFilestreamOptionPanel.this.filestreamEnabledStatusChange();
                }
            });
            this.updateFilestreamEnableStatus(true, true, false, false, false, false, true);
        }
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        this.heading.setFont(UIFontUtilities.TITLE_FONT);
        this.add((Component)this.heading, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.filestreamChk, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JLabel moreLinkPane = this.getLinkPane(MSG_RES.getString("database.filestream.learnMore.text"), URLUtility.getVersionLanguageErrorUpdatedUrl("com.sygate.scm.util.util", "database.filestream.learnMore.URL", null));
        this.add((Component)moreLinkPane, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 5, 10), 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void filestreamEnabledStatusChange() {
        if (!this.isDefineNewDB && this.filestreamChk.isSelected() != this.filestreamEnabledDb) {
            JEditorPane paneMsg = new JEditorPane();
            paneMsg.setContentType("text/html");
            paneMsg.setFocusable(false);
            paneMsg.setOpaque(false);
            paneMsg.setEditable(false);
            paneMsg.setText(MSG_RES.getString("database.filestream.change.warning.message"));
            String strMsgTitle = MSG_RES.getString("database.filestream.change.warning.title");
            JOptionPane.showMessageDialog(this.getParent(), paneMsg, strMsgTitle, 2);
        }
    }

    public JCheckBox getFilestreamEnabledCheckBox() {
        return this.filestreamChk;
    }

    public boolean isFilestreamEnabled() {
        return this.filestreamChk.isSelected();
    }

    public void updateFilestreamEnableStatus(boolean isDefineNewDB, boolean isSQLServerExpress, boolean isMirrorDb, boolean isSimpleRecoveryModel, boolean filestreamEnabledDb, boolean filestreamEnabledSQLServer, boolean hidePanel) {
        this.filestreamEnabledDb = filestreamEnabledDb;
        this.isDefineNewDB = isDefineNewDB;
        this.isSQLServerExpress = isSQLServerExpress;
        System.out.println("updateFilestreamEnableStatus >> isDefineNewDB: " + this.isDefineNewDB + ", isSQLServerExpress: " + this.isSQLServerExpress + ", filestreamEnabledDb: " + this.filestreamEnabledDb + ", filestreamEnabledSQLServer: " + filestreamEnabledSQLServer + ", hidePanel: " + hidePanel + ", isMirrorDb: " + isMirrorDb + ", isSimpleRecoveryModel: " + isSimpleRecoveryModel);
        this.setVisible(!hidePanel);
        if (isSQLServerExpress) {
            this.filestreamChk.setSelected(true);
            this.filestreamChk.setEnabled(false);
        } else if (isMirrorDb) {
            this.filestreamChk.setSelected(false);
            this.filestreamChk.setEnabled(false);
        } else {
            this.filestreamChk.setEnabled(true);
            if (isDefineNewDB) {
                this.filestreamChk.setSelected(filestreamEnabledSQLServer);
            } else {
                this.filestreamChk.setSelected(filestreamEnabledDb);
                if (!isSimpleRecoveryModel) {
                    this.filestreamChk.setEnabled(false);
                }
            }
        }
    }

    private JLabel getLinkPane(String displayText, final String kbUrl) {
        if (displayText == null || kbUrl == null) {
            throw new IllegalArgumentException();
        }
        HtmlEnabledJLabel pane = new HtmlEnabledJLabel(true);
        pane.setText(displayText);
        pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ex) {
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    ClientAgent.getCurrentInstance().openInNewTab(kbUrl);
                    return;
                }
                URLUtility.showURL(kbUrl);
            }
        });
        return pane;
    }
}

