/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class DaSliderUI
extends BasicSliderUI {
    private static final int BOLD_ADDITIONAL_MARGIN = 5;
    private static final int TRACK_ROUND_DIAMETER = 13;
    private static final int TRACK_WIDTH_HEIGHT = 18;
    private static final int MAX_LABEL_WIDTH_HEIGHT = 999999;
    protected Icon thumbIcon;

    public static ComponentUI createUI(JComponent component) {
        URL thumbURL = DaSliderUI.class.getClassLoader().getResource("com/sygate/scm/console/carrot.png");
        ImageIcon thumbIcon = null;
        if (null != thumbURL) {
            Image enabledImage = Toolkit.getDefaultToolkit().getImage(thumbURL);
            thumbIcon = new ImageIcon(enabledImage);
        }
        return new DaSliderUI(thumbIcon);
    }

    public DaSliderUI(Icon icon) {
        super(null);
        this.thumbIcon = icon;
    }

    private Icon getThumbIcon() {
        return this.thumbIcon;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollListener.setScrollByBlock(false);
    }

    @Override
    public void paintTrack(Graphics g) {
        g.translate(this.trackRect.x, this.trackRect.y);
        GradientPaint gradient = new GradientPaint(this.xPositionForValue(this.slider.getMinimum()), 0.0f, UIColorUtilities.ERROR_BACKGROUND, this.xPositionForValue(this.slider.getMaximum()), 0.0f, UIColorUtilities.SUCCESS_BACKGROUND);
        if (this.slider.isEnabled()) {
            ((Graphics2D)g).setPaint(gradient);
        } else {
            g.setColor(UIColorUtilities.CONTROL_BACKGROUND);
        }
        for (int value = this.slider.getMinimum(); value <= this.slider.getMaximum(); ++value) {
            int pos = this.xPositionForValue(value);
            g.fillOval(pos - 6 - this.trackBuffer - 5, 0, 13, 13);
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        this.getThumbIcon().paintIcon(this.slider, g, 0, 0);
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        size.width = this.getThumbIcon().getIconWidth();
        size.height = this.getThumbIcon().getIconHeight();
        return size;
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        this.scrollByUnit(dir);
    }

    protected int getHeightOfShortestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int shortest = 999999;
        if (null != dictionary) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                JComponent label = (JComponent)dictionary.get(keys.nextElement());
                shortest = Math.min(label.getPreferredSize().height, shortest);
            }
        } else {
            shortest = 0;
        }
        return shortest;
    }

    @Override
    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left + 5;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top + 5;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right + 10);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom + 10);
    }

    @Override
    protected void calculateTrackRect() {
        int centerSpacing = this.thumbRect.height * 2;
        if (this.slider.getPaintTicks()) {
            centerSpacing += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            centerSpacing += this.getHeightOfTallestLabel();
        }
        this.trackRect.x = this.contentRect.x + this.trackBuffer;
        this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
        this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
        this.trackRect.height = 18;
    }

    private int getSliderTickSpacing() {
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int result = minorTickSpacing > 0 ? minorTickSpacing : (majorTickSpacing > 0 ? majorTickSpacing : 0);
        return result;
    }

    @Override
    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int tickSpacing = this.getSliderTickSpacing();
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        int valuePosition = this.xPositionForValue(this.slider.getValue());
        this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        this.thumbRect.y = this.trackRect.y + this.trackRect.height + this.getHeightOfShortestLabel();
    }

    @Override
    public void paintLabels(Graphics g) {
        Dictionary dictionary = this.slider.getLabelTable();
        if (null == dictionary) {
            return;
        }
        Rectangle labelBounds = this.labelRect;
        Enumeration keys = dictionary.keys();
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        boolean enabled = this.slider.isEnabled();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            int value = key;
            if (value < minValue || value > maxValue) continue;
            JComponent label = (JComponent)dictionary.get(key);
            label.setEnabled(enabled);
            if (label instanceof JLabel) {
                Icon icon;
                Icon icon2 = icon = label.isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
                if (icon instanceof ImageIcon) {
                    Toolkit.getDefaultToolkit().checkImage(((ImageIcon)icon).getImage(), -1, -1, this.slider);
                }
            }
            g.translate(0, labelBounds.y);
            this.paintHorizontalLabel(g, value, label);
            g.translate(0, -labelBounds.y);
        }
        int xStart = this.trackRect.x;
        int xEnd = this.trackRect.x + this.trackRect.width - 1;
        int yStart = this.labelRect.y + this.getHeightOfShortestLabel() + this.thumbRect.height;
        int yEnd = this.labelRect.y + this.getHeightOfShortestLabel() * 2;
        g.setColor(this.getShadowColor());
        g.drawLine(xStart, yStart, xEnd, yStart);
        g.drawLine(xStart, yStart, xStart, yEnd);
        g.drawLine(xEnd, yStart, xEnd, yEnd);
    }
}

