/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.ButtonUI;
import com.sygate.scm.common.ui.CheckBoxIcon;
import com.sygate.scm.common.ui.CleanComboBoxUI;
import com.sygate.scm.common.ui.DaSliderUI;
import com.sygate.scm.common.ui.FileChooserListUI;
import com.sygate.scm.common.ui.FileChooserTableUI;
import com.sygate.scm.common.ui.FileChooserUI;
import com.sygate.scm.common.ui.NavigateButtonUI;
import com.sygate.scm.common.ui.NoSelectionSideBarButtonUI;
import com.sygate.scm.common.ui.OutlookButtonUI;
import com.sygate.scm.common.ui.RadioButtonIcon;
import com.sygate.scm.common.ui.SideBarButtonUI;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class CustomLookAndFeel {
    public static final Border UNDECORATED_DIALOG_BORDER = BorderFactory.createLineBorder(UIColorUtilities.ACCENT_BORDER, 2);
    public static final Border SIMPLE_BORDER = BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND);
    public static final Border CELL_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    public static final Border TITLED_PANEL_EMPTY_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    public static final Border DEFAULT_BORDER = BorderFactory.createCompoundBorder(SIMPLE_BORDER, TITLED_PANEL_EMPTY_BORDER);
    public static final Border TEXT_AREA_BORDER = BorderFactory.createCompoundBorder(SIMPLE_BORDER, CELL_BORDER);
    private static final Border SMALLER_BORDER = BorderFactory.createCompoundBorder(SIMPLE_BORDER, BorderFactory.createEmptyBorder(2, 5, 2, 5));
    public static final URL DOWN_ARROW_URL = CustomLookAndFeel.class.getResource("images/select_arrow_down.png");
    public static final URL CLOUD_URL = CustomLookAndFeel.class.getResource("images/cloud.png");
    public static final URL CLOUD_INHERITED_URL = CustomLookAndFeel.class.getResource("images/icnCloudInheritance_16.png");
    public static final Image DOWN_ARROW_IMAGE = Toolkit.getDefaultToolkit().getImage(DOWN_ARROW_URL);
    public static final URL UP_ARROW_URL = CustomLookAndFeel.class.getResource("images/select_arrow_up.png");
    public static final Image UP_ARROW_IMAGE = Toolkit.getDefaultToolkit().getImage(UP_ARROW_URL);
    public static final ImageIcon DOWN_ARROW_ICON = new ImageIcon(DOWN_ARROW_IMAGE);
    public static final ImageIcon UP_ARROW_ICON = new ImageIcon(UP_ARROW_IMAGE);
    public static final URL TITLE_LOGO_IMAGE_URL = CustomLookAndFeel.class.getResource("images/icon.png");
    public static final Image TITLE_LOGO_IMAGE = Toolkit.getDefaultToolkit().getImage(TITLE_LOGO_IMAGE_URL);
    public static final ImageIcon TITLE_LOGO_ICON = new ImageIcon(TITLE_LOGO_IMAGE);
    private static final URL QUESTION_MARK_URL = CustomLookAndFeel.class.getResource("images/Question.png");
    private static final Image QUESTION_MARK_IMAGE = Toolkit.getDefaultToolkit().getImage(QUESTION_MARK_URL);
    private static final ImageIcon QUESTION_IMAGE_ICON = new ImageIcon(QUESTION_MARK_IMAGE);
    private static final URL INFO_MARK_URL = CustomLookAndFeel.class.getResource("images/Inform.png");
    private static final Image INFO_MARK_IMAGE = Toolkit.getDefaultToolkit().getImage(INFO_MARK_URL);
    private static final ImageIcon INFO_IMAGE_ICON = new ImageIcon(INFO_MARK_IMAGE);
    private static final URL WARNING_MARK_URL = CustomLookAndFeel.class.getResource("images/WarningIcon.png");
    private static final Image WARNING_MARK_IMAGE = Toolkit.getDefaultToolkit().getImage(WARNING_MARK_URL);
    private static final ImageIcon WARNING_IMAGE_ICON = new ImageIcon(WARNING_MARK_IMAGE);
    private static final URL ERROR_MARK_URL = CustomLookAndFeel.class.getResource("images/ErrorIcon.png");
    private static final Image ERROR_MARK_IMAGE = Toolkit.getDefaultToolkit().getImage(ERROR_MARK_URL);
    private static final ImageIcon ERROR_IMAGE_ICON = new ImageIcon(ERROR_MARK_IMAGE);
    public static final String IS_CUSTOM_BUTTON = "isCustomButton";

    public static void setDefaults() {
        MetalLookAndFeel lookAndFeel = new MetalLookAndFeel();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable ex) {
            System.out.println("CustomLookAndFeel> setDefaults>> WARNING UnsupportedLookAndFeelException / RuntimeException: " + ex.getMessage());
        }
        Locale.setDefault(Locale.getDefault(Locale.Category.FORMAT));
        String displayLanguage = Locale.getDefault().getDisplayLanguage(Locale.US);
        System.out.println("CustomLookAndFeel> setDefaults>> displayLanguage: " + displayLanguage);
        UIDefaults uidf = UIManager.getDefaults();
        ResourceBundle bundle = MessageResources.getResourceBundle("com.sygate.scm.common.ui.customlook");
        if (bundle != null) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                uidf.put(key, bundle.getString(key));
            }
        }
        Object treeExpandedIcon = null;
        Object treeCollapsedIcon = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            String lookAndFeelClassName = lookAndFeelInfo.getClassName();
            if (!"com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lookAndFeelClassName)) continue;
            try {
                LookAndFeel windowsLookAndFeel = (LookAndFeel)Class.forName(lookAndFeelClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                UIDefaults auxDefaults = windowsLookAndFeel.getDefaults();
                treeExpandedIcon = auxDefaults.get("Tree.expandedIcon");
                treeCollapsedIcon = auxDefaults.get("Tree.collapsedIcon");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                System.out.println("CustomLookAndFeel> setDefaults>> Unable to get windows look and feel " + lookAndFeelClassName + " / RuntimeException: " + ex.getMessage());
            }
            break;
        }
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("a {color: " + UIColorUtilities.colorToString(UIColorUtilities.LINK_FOREGROUND) + "; text-decoration: none}");
        kit.setStyleSheet(styleSheet);
        Object[] uiDefaults = new Object[]{"DASliderUI", DaSliderUI.class.getName(), "NavButtonUI", NavigateButtonUI.class.getName(), "SideBarButtonUI", SideBarButtonUI.class.getName(), "SideBarTaskButtonUI", NoSelectionSideBarButtonUI.class.getName(), "PolicyButtonUI", SideBarButtonUI.class.getName(), "ArrowButtonUI", NoSelectionSideBarButtonUI.class.getName(), "OutlookButtonUI", OutlookButtonUI.class.getName(), "control", UIColorUtilities.DEFAULT_BACKGROUND, "controlShadow", UIColorUtilities.DEFAULT_BACKGROUND, "controlDkShadow", UIColorUtilities.DEFAULT_FOREGROUND, "controlHighlight", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "CheckBox.background", UIColorUtilities.DEFAULT_BACKGROUND, "CheckBoxMenuItem.background", UIColorUtilities.DEFAULT_BACKGROUND, "ComboBox.background", UIColorUtilities.DEFAULT_BACKGROUND, "EditorPane.background", UIColorUtilities.DEFAULT_BACKGROUND, "FormattedTextField.background", UIColorUtilities.DEFAULT_BACKGROUND, "Label.background", UIColorUtilities.DEFAULT_BACKGROUND, "List.background", UIColorUtilities.DEFAULT_BACKGROUND, "Menu.background", UIColorUtilities.DEFAULT_BACKGROUND, "MenuBar.background", UIColorUtilities.DEFAULT_BACKGROUND, "MenuItem.background", UIColorUtilities.DEFAULT_BACKGROUND, "OptionPane.background", UIColorUtilities.DEFAULT_BACKGROUND, "Panel.background", UIColorUtilities.DEFAULT_BACKGROUND, "PasswordField.background", UIColorUtilities.DEFAULT_BACKGROUND, "PopupMenu.background", UIColorUtilities.DEFAULT_BACKGROUND, "ProgressBar.background", UIColorUtilities.DEFAULT_BACKGROUND, "RadioButton.background", UIColorUtilities.DEFAULT_BACKGROUND, "RadioButtonMenuItem.background", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.background", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollPane.background", UIColorUtilities.DEFAULT_BACKGROUND, "Slider.background", UIColorUtilities.DEFAULT_BACKGROUND, "Spinner.background", UIColorUtilities.DEFAULT_BACKGROUND, "SplitPane.background", UIColorUtilities.DEFAULT_BACKGROUND, "Table.background", UIColorUtilities.DEFAULT_BACKGROUND, "TableHeader.background", UIColorUtilities.DEFAULT_BACKGROUND, "TextArea.background", UIColorUtilities.DEFAULT_BACKGROUND, "TextField.background", UIColorUtilities.DEFAULT_BACKGROUND, "TextPane.background", UIColorUtilities.DEFAULT_BACKGROUND, "ToggleButton.background", UIColorUtilities.DEFAULT_BACKGROUND, "ToolBar.background", UIColorUtilities.DEFAULT_BACKGROUND, "Tree.background", UIColorUtilities.DEFAULT_BACKGROUND, "Viewport.background", UIColorUtilities.DEFAULT_BACKGROUND, "Button.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "CheckBox.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "CheckBoxMenuItem.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "ComboBox.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "EditorPane.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "FormattedTextField.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "Label.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "List.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "Menu.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "MenuBar.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "MenuItem.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "OptionPane.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "OptionPane.messageForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Panel.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "PasswordField.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "PopupMenu.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "RadioButton.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "RadioButtonMenuItem.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "ScrollPane.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TabbedPane.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "Table.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TableHeader.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TextArea.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TextField.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TextPane.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "TitledBorder.titleColor", UIColorUtilities.DEFAULT_FOREGROUND, "ToggleButton.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "ToolBar.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "ToolTip.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "Tree.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "Tree.textForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Viewport.foreground", UIColorUtilities.DEFAULT_FOREGROUND, "CheckBoxMenuItem.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "ComboBox.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "EditorPane.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "FormattedTextField.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "List.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Menu.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "MenuItem.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "PasswordField.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "RadioButtonMenuItem.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Table.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "TextArea.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "TextField.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "TextPane.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Tree.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "Button.focus", UIColorUtilities.FOCUS_BORDER, "CheckBox.focus", UIColorUtilities.FOCUS_BORDER, "RadioButton.focus", UIColorUtilities.FOCUS_BORDER, "TabbedPane.focus", UIColorUtilities.FOCUS_BORDER, "Tree.selectionBorderColor", UIColorUtilities.FOCUS_BORDER, "ComboBox.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "Menu.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "PopupMenu.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "MenuItem.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "Tree.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "Table.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "RadioButtonMenuItem.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "CheckBoxMenuItem.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "List.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "TextField.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "TextPane.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "EditorPane.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "FormattedTextField.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "PasswordField.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "TextArea.selectionBackground", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "ComboBox.disabledBackground", UIColorUtilities.DEFAULT_BACKGROUND, "TextField.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "TextPane.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "EditorPane.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "FormattedTextField.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "PasswordField.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "TextArea.inactiveForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "ComboBox.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "Label.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "Menu.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "MenuItem.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "RadioButtonMenuItem.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "CheckBoxMenuItem.disabledForeground", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "Button.disabledText", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "RadioButton.disabledText", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "ToggleButton.disabledText", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "CheckBox.disabledText", UIColorUtilities.CONTROL_DISABLED_FOREGROUND, "ScrollBar.shadow", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.thumbHighlight", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.darkShadow", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.thumb", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.thumbDarkShadow", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.thumbShadow", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.track", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.trackHighlight", UIColorUtilities.DEFAULT_BACKGROUND, "ScrollBar.gradient", UIColorUtilities.CONTROL_GRADIENT, "TableHeader.cellBorder", CELL_BORDER, "Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder(0, 1, 0, 1), "List.focusCellHighlightBorder", BorderFactory.createEmptyBorder(0, 1, 0, 1), "Table.gridColor", UIColorUtilities.DEFAULT_BACKGROUND, "ProgressBar.foreground", UIColorUtilities.CONTROL_BACKGROUND, "ProgressBar.selectionForeground", UIColorUtilities.DEFAULT_FOREGROUND, "ProgressBar.selectionBackground", UIColorUtilities.DEFAULT_FOREGROUND, "TextField.darkShadow", UIColorUtilities.DEFAULT_BACKGROUND, "TextField.shadow", UIColorUtilities.DEFAULT_BACKGROUND, "TextField.border", DEFAULT_BORDER, "PasswordField.border", DEFAULT_BORDER, "ComboBox.border", SMALLER_BORDER, "Spinner.border", SMALLER_BORDER, "ProgressBar.border", SIMPLE_BORDER, "ScrollPane.border", BorderFactory.createEmptyBorder(), "SplitPane.border", BorderFactory.createEmptyBorder(), "SplitPaneDivider.border", BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND, 4), "Button.border", BorderFactory.createEmptyBorder(7, 17, 7, 17), "PopupMenu.border", DEFAULT_BORDER, "Menu.border", BorderFactory.createEmptyBorder(3, 0, 3, 0), "ToolTip.border", SIMPLE_BORDER, "Spinner.arrowButtonBorder", SIMPLE_BORDER, "ToolTip.background", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "Tree.hash", UIColorUtilities.CONTROL_BACKGROUND, "Button.background", UIColorUtilities.CONTROL_BACKGROUND, "Button.select", UIColorUtilities.CONTROL_BACKGROUND, "Button.highlight", UIColorUtilities.DEFAULT_SELECTION_BACKGROUND, "Button.toolBarBorderBackground", UIColorUtilities.CONTROL_BACKGROUND, "Button.darkShadow", UIColorUtilities.CONTROL_BACKGROUND, "Button.shadow", UIColorUtilities.CONTROL_BACKGROUND, "Button.rollover", Boolean.TRUE, "TitledBorder.border", SIMPLE_BORDER, "MenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "TabbedPane.background", UIColorUtilities.CONTROL_BACKGROUND, "TabbedPane.selectHighlight", UIColorUtilities.CONTROL_BACKGROUND, "TabbedPane.selected", UIColorUtilities.DEFAULT_BACKGROUND, "TabbedPane.light", UIColorUtilities.DEFAULT_BACKGROUND, "TabbedPane.darkShadow", UIColorUtilities.DEFAULT_BACKGROUND, "TabbedPane.contentAreaColor", UIColorUtilities.DEFAULT_BACKGROUND, "TabbedPane.tabInsets", new Insets(5, 9, 5, 9), "TabbedPane.borderHightlightColor", UIColorUtilities.DEFAULT_BACKGROUND, "Separator.background", UIColorUtilities.CONTROL_BACKGROUND, "Separator.foreground", UIColorUtilities.CONTROL_BACKGROUND, "SplitPane.dividerSize", 3, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}), "CheckBox.icon", new IconUIResource(new CheckBoxIcon()), "CheckBoxMenuItem.checkIcon", new IconUIResource(new CheckBoxIcon()), "RadioButton.icon", new IconUIResource(new RadioButtonIcon()), "RadioButtonMenuItem.checkIcon", new IconUIResource(new RadioButtonIcon()), "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "OptionPane.questionIcon", QUESTION_IMAGE_ICON, "OptionPane.informationIcon", INFO_IMAGE_ICON, "OptionPane.warningIcon", WARNING_IMAGE_ICON, "OptionPane.errorIcon", ERROR_IMAGE_ICON, "CheckBox.font", UIFontUtilities.STANDARD_FONT, "Button.font", UIFontUtilities.STANDARD_FONT, "CheckBoxMenuItem.font", UIFontUtilities.STANDARD_FONT, "CheckBoxMenuItem.acceleratorFont", UIFontUtilities.STANDARD_FONT, "ColorChooser.font", UIFontUtilities.STANDARD_FONT, "ComboBox.font", UIFontUtilities.STANDARD_FONT, "DesktopIcon.font", UIFontUtilities.BOLD_FONT, "EditorPane.font", UIFontUtilities.STANDARD_FONT, "FormattedTextField.font", UIFontUtilities.STANDARD_FONT, "Label.font", UIFontUtilities.STANDARD_FONT, "List.font", UIFontUtilities.STANDARD_FONT, "Menu.font", UIFontUtilities.STANDARD_FONT, "Menu.acceleratorFont", UIFontUtilities.STANDARD_FONT, "MenuBar.font", UIFontUtilities.STANDARD_FONT, "MenuItem.font", UIFontUtilities.STANDARD_FONT, "MenuItem.acceleratorFont", UIFontUtilities.STANDARD_FONT, "OptionPane.font", UIFontUtilities.STANDARD_FONT, "Panel.font", UIFontUtilities.STANDARD_FONT, "PasswordField.font", UIFontUtilities.STANDARD_FONT, "PopupMenu.font", UIFontUtilities.STANDARD_FONT, "ProgressBar.font", UIFontUtilities.STANDARD_FONT, "RadioButton.font", UIFontUtilities.STANDARD_FONT, "RadioButtonMenuItem.font", UIFontUtilities.STANDARD_FONT, "RadioButtonMenuItem.acceleratorFont", UIFontUtilities.STANDARD_FONT, "ScrollPane.font", UIFontUtilities.STANDARD_FONT, "Spinner.font", UIFontUtilities.STANDARD_FONT, "TabbedPane.font", UIFontUtilities.BOLD_FONT, "Table.font", UIFontUtilities.STANDARD_FONT, "TableHeader.font", UIFontUtilities.BOLD_FONT, "TextArea.font", UIFontUtilities.STANDARD_FONT, "TextField.font", UIFontUtilities.STANDARD_FONT, "TextPane.font", UIFontUtilities.STANDARD_FONT, "TitledBorder.font", UIFontUtilities.BOLD_FONT, "ToggleButton.font", UIFontUtilities.STANDARD_FONT, "ToolBar.font", UIFontUtilities.STANDARD_FONT, "ToolTip.font", UIFontUtilities.STANDARD_FONT, "Tree.font", UIFontUtilities.STANDARD_FONT, "Viewport.font", UIFontUtilities.STANDARD_FONT, "ComboBoxUI", CleanComboBoxUI.class.getName(), "FileChooserUI", FileChooserUI.class.getName(), "ListUI", FileChooserListUI.class.getName(), "TableUI", FileChooserTableUI.class.getName(), "ButtonUI", ButtonUI.class.getName(), "EditorPaneUI", EditorPaneUI.class.getName(), "ProgressBarUI", BasicProgressBarUI.class.getName()};
        UIDefaults defaults = UIManager.getDefaults();
        defaults.putDefaults(uiDefaults);
    }

    public static class EditorPaneUI
    extends BasicEditorPaneUI {
        public static ComponentUI createUI(JComponent component) {
            component.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            return new EditorPaneUI();
        }
    }

    public static interface UIClassIDs {
        public static final String DA_SLIDER = "DASliderUI";
        public static final String NAV_BUTTON = "NavButtonUI";
        public static final String SIDEBAR_BUTTON = "SideBarButtonUI";
        public static final String SIDEBAR_TASK_BUTTON = "SideBarTaskButtonUI";
        public static final String POLICY_BUTTON = "PolicyButtonUI";
        public static final String ARROW_BUTTON = "ArrowButtonUI";
        public static final String OUTLOOK_BUTTON = "OutlookButtonUI";
    }
}

