/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class ClientInstallationSAVFeaturesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ALL = 1;
    public static final int TYPE_AV_ONLY = 2;
    public static final int TYPE_AV_PT = 3;
    public static final int TYPE_FW_ONLY = 4;
    public static final int TYPE_FW_DC = 5;
    public static final int TYPE_SB = 6;
    private JTextArea descArea;
    private JCheckBox SAVChkBox;
    private JCheckBox emailChkBox;
    private JCheckBox outlookChkBox;
    private JCheckBox notesChkBox;
    private JCheckBox pop3ChkBox;
    private JCheckBox deviceChkBox;
    private JCheckBox downloadChkBox;
    private JCheckBox ntpChkBox;
    private JCheckBox truscanChkBox;
    private JCheckBox ITPChkBox;
    private ClientInstallationFeatures features;
    private boolean readOnly;
    private boolean showDesc;
    private boolean isSBProduct = false;
    private boolean showSeperator = true;
    private String currentVersion = "14.3.5000.0";

    public ClientInstallationSAVFeaturesPanel() {
        this(true);
    }

    private ClientInstallationSAVFeaturesPanel(boolean isSBE, boolean showDesc, boolean showSeperator, boolean readOnly) {
        this.isSBProduct = isSBE;
        this.readOnly = readOnly;
        this.showDesc = showDesc;
        this.showSeperator = showSeperator;
        this.features = this.createNewFeatures();
        this.setupPanel();
        this.setReadOnly();
    }

    public ClientInstallationSAVFeaturesPanel(boolean showDesc) {
        this(true, true);
    }

    private ClientInstallationSAVFeaturesPanel(boolean showDesc, boolean showSeperator) {
        this(false, showDesc, showSeperator, false);
    }

    private ClientInstallationFeatures createNewFeatures() {
        ClientInstallationFeatures result = ClientInstallFeatureSetUtility.createNewFeatureSet();
        return result;
    }

    public ClientInstallationFeatures getObject() {
        return this.features;
    }

    private void addFeature(ClientFeature feature) {
        EnabledClientFeatures enabledFeature = this.features.getEnabledClientFeatures().get(0);
        enabledFeature.addClientFeature(feature);
    }

    private void setFeature(String type, boolean enabled) {
        ClientFeature feature = this.getClientFeature(type);
        if (feature == null) {
            feature = new ClientFeature();
            feature.setFeatureName(type);
            this.addFeature(feature);
        }
        feature.setOptEnabled(enabled);
    }

    public void setFeaturePackage(int type) {
        switch (type) {
            case 1: {
                this.setAllSelected();
                break;
            }
            case 2: 
            case 3: {
                this.setAllSelected();
                this.getNTPChkBox().setSelected(false);
                this.getITPChkBox().setSelected(false);
                if (this.isSBProduct()) break;
                this.getDeviceChkBox().setSelected(false);
                break;
            }
            case 4: {
                this.setAllSelected(false);
                this.getNTPChkBox().setSelected(true);
                this.getITPChkBox().setSelected(true);
                break;
            }
            case 5: {
                this.setAllSelected(false);
                if (!this.isSBProduct()) {
                    this.getDeviceChkBox().setSelected(true);
                }
                this.getNTPChkBox().setSelected(true);
                this.getITPChkBox().setSelected(true);
                break;
            }
            case 6: {
                this.getSAVChkBox().setSelected(true);
                this.getNTPChkBox().setSelected(true);
                this.getITPChkBox().setSelected(true);
                this.getTruScanChkBox().setSelected(true);
                this.getEmailChkBox().setSelected(false);
                this.getPop3ChkBox().setSelected(false);
                this.getOutlookChkBox().setSelected(false);
                break;
            }
        }
        this.savChkBoxChanged();
        this.emailChkBoxChanged();
    }

    public void save() {
        this.setFeature("Core", true);
        boolean enabled = this.getSAVChkBox().isSelected();
        this.setFeature("SAVMain", enabled);
        if (!this.isSBProduct()) {
            enabled = this.getTruScanChkBox().isSelected();
            this.setFeature("TruScan", enabled);
            enabled = this.getDownloadChkBox().isSelected();
            this.setFeature("Download", enabled);
            enabled = this.getEmailChkBox().isSelected();
            this.setFeature("EMailTools", enabled);
            enabled = this.getOutlookChkBox().isSelected();
            this.setFeature("OutlookSnapin", enabled);
            enabled = this.getNotesChkBox().isSelected();
            this.setFeature("NotesSnapin", enabled);
            enabled = this.getPop3ChkBox().isSelected();
            this.setFeature("Pop3Smtp", enabled);
            enabled = this.getNTPChkBox().isSelected();
            this.setFeature("NTPMain", enabled);
            enabled = this.getITPChkBox().isSelected();
            this.setFeature("ITPMain", enabled);
            enabled = this.getDeviceChkBox().isSelected();
            this.setFeature("DCMain", enabled);
        } else {
            enabled = this.getEmailChkBox().isSelected();
            this.setFeature("EMailTools", enabled);
            enabled = this.getTruScanChkBox().isSelected();
            this.setFeature("TruScan", true);
            enabled = this.getNTPChkBox().isSelected();
            this.setFeature("NTPMain", enabled);
        }
    }

    private JCheckBox getNTPChkBox() {
        if (this.ntpChkBox == null) {
            this.ntpChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.NTPMain"));
            this.ntpChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.NTPMain"));
        }
        return this.ntpChkBox;
    }

    private JCheckBox getDownloadChkBox() {
        if (this.downloadChkBox == null) {
            this.downloadChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.DownloadChkBox"));
            this.downloadChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.DownloadChkBox"));
        }
        return this.downloadChkBox;
    }

    private JCheckBox getTruScanChkBox() {
        if (this.truscanChkBox == null) {
            this.truscanChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.TruScanChkBox"));
            this.truscanChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.TruScanChkBox"));
        }
        return this.truscanChkBox;
    }

    private JCheckBox getITPChkBox() {
        if (this.ITPChkBox == null) {
            this.ITPChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.IPSChkBox"));
            this.ITPChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.IPSChkBox"));
        }
        return this.ITPChkBox;
    }

    public void setEnableFW(boolean enable) {
        this.getNTPChkBox().setSelected(enable);
        this.getITPChkBox().setSelected(enable);
    }

    public void setAllSelected() {
        this.setAllSelected(true);
    }

    public void setAllSelected(boolean b) {
        this.getSAVChkBox().setSelected(b);
        this.getEmailChkBox().setSelected(b);
        this.getOutlookChkBox().setSelected(b);
        this.getTruScanChkBox().setSelected(b);
        this.getNTPChkBox().setSelected(b);
        if (!this.isSBProduct()) {
            this.getNotesChkBox().setSelected(b);
        }
        this.getPop3ChkBox().setSelected(b);
        if (!this.isSBProduct()) {
            this.getDownloadChkBox().setSelected(b);
            this.getDeviceChkBox().setSelected(b);
        }
        this.savChkBoxChanged();
        this.emailChkBoxChanged();
    }

    public void setObject(ClientInstallationFeatures cif) {
        this.features = cif;
        this.getSAVChkBox().setSelected(this.isFeatureEnabled("SAVMain"));
        this.getEmailChkBox().setSelected(this.isFeatureEnabled("EMailTools"));
        this.getOutlookChkBox().setSelected(this.isFeatureEnabled("OutlookSnapin"));
        this.getTruScanChkBox().setSelected(this.isFeatureEnabled("TruScan"));
        if (!this.isSBProduct()) {
            this.getNotesChkBox().setSelected(this.isFeatureEnabled("NotesSnapin"));
        }
        this.getPop3ChkBox().setSelected(this.isFeatureEnabled("Pop3Smtp"));
        this.getNTPChkBox().setSelected(this.isFeatureEnabled("NTPMain"));
        this.getITPChkBox().setSelected(this.isFeatureEnabled("ITPMain"));
        if (!this.isSBProduct()) {
            this.getDownloadChkBox().setSelected(this.isFeatureEnabled("Download"));
            this.getDeviceChkBox().setSelected(this.isFeatureEnabled("DCMain"));
        }
        this.savChkBoxChanged();
        this.emailChkBoxChanged();
        this.setReadOnly();
    }

    public void setClientFeatureEnabled(String type, boolean isEnabled) {
        if (type.equals("SAVMain")) {
            this.getSAVChkBox().setSelected(isEnabled);
        } else if (type.equals("EMailTools")) {
            this.getEmailChkBox().setSelected(isEnabled);
        } else if (type.equals("OutlookSnapin")) {
            this.getOutlookChkBox().setSelected(isEnabled);
        } else if (type.equals("NotesSnapin") && !this.isSBProduct()) {
            this.getNotesChkBox().setSelected(isEnabled);
        } else if (type.equals("Pop3Smtp")) {
            this.getPop3ChkBox().setSelected(isEnabled);
        } else if (type.equals("DCMain") && !this.isSBProduct()) {
            this.getDeviceChkBox().setSelected(isEnabled);
        } else if (type.equals("NTPMain")) {
            this.getNTPChkBox().setSelected(isEnabled);
        } else if (type.equals("ITPMain")) {
            this.getITPChkBox().setSelected(isEnabled);
        } else if (type.equals("Download") && !this.isSBProduct()) {
            this.getDownloadChkBox().setSelected(isEnabled);
        } else if (type.equals("TruScan")) {
            this.getTruScanChkBox().setSelected(isEnabled);
        }
    }

    private ClientFeature getClientFeature(String type) {
        EnabledClientFeatures eFeature = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(this.getCurrentVersion(), this.features, false);
        Vector<ClientFeature> allFeature = eFeature.getClientFeature();
        for (ClientFeature cFeature : allFeature) {
            if (!type.equals(cFeature.getFeatureName())) continue;
            return cFeature;
        }
        return null;
    }

    private boolean isFeatureEnabled(String type) {
        ClientFeature feature = this.getClientFeature(type);
        if (feature != null) {
            Boolean enabled = feature.getOptEnabled();
            if (enabled == null) {
                enabled = feature.getDefEnabled();
            }
            return enabled;
        }
        return false;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", key);
    }

    private void setupPanel() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        int y = 0;
        if (this.showDesc) {
            p.add((Component)this.getDescArea(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 10, 2, 10), 0, 0));
            p.add((Component)new JSeparator(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 2, 10), 0, 0));
        }
        p.add((Component)this.getSAVChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 20, 0, 10), 0, 0));
        if (!this.isSBProduct()) {
            p.add((Component)this.getTruScanChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 40, 0, 10), 0, 0));
            p.add((Component)this.getDownloadChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 40, 0, 10), 0, 0));
        }
        p.add((Component)this.getEmailChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 10), 0, 0));
        if (!this.isSBProduct()) {
            p.add((Component)this.getPop3ChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 60, 0, 10), 0, 0));
            p.add((Component)this.getOutlookChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 60, 0, 10), 0, 0));
        }
        if (!this.isSBProduct()) {
            p.add((Component)this.getNotesChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 60, 0, 10), 0, 0));
        }
        if (this.showSeperator) {
            p.add((Component)new JSeparator(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 2, 10), 0, 0));
        }
        p.add((Component)this.getNTPChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 20, 0, 10), 0, 0));
        if (this.showSeperator) {
            p.add((Component)new JSeparator(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 2, 10), 0, 0));
        }
        if (!this.isSBProduct()) {
            p.add((Component)this.getITPChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 20, 0, 10), 0, 0));
        }
        if (this.showSeperator) {
            p.add((Component)new JSeparator(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 10, 2, 10), 0, 0));
        }
        if (!this.isSBProduct()) {
            p.add((Component)this.getDeviceChkBox(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 20, 2, 10), 0, 0));
        }
        p.add((Component)new JLabel(""), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 30, 2, 10), 0, 0));
        this.add((Component)p, "Center");
    }

    private JTextArea getDescArea() {
        if (this.descArea == null) {
            this.descArea = new JTextArea();
            this.descArea.setOpaque(false);
            this.descArea.setEditable(false);
            this.descArea.setLineWrap(true);
            this.descArea.setWrapStyleWord(true);
            this.descArea.setText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.descShort"));
            this.descArea.setFocusable(false);
            this.descArea.setRows(2);
            LookAndFeel.installColorsAndFont(this.descArea, "JPanel.background", "Label.foreground", "Label.font");
        }
        return this.descArea;
    }

    private JCheckBox getSAVChkBox() {
        if (this.SAVChkBox == null) {
            this.SAVChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.SAVMainChkBox"));
            this.SAVChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.SAVMainChkBoxTips"));
            this.SAVChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientInstallationSAVFeaturesPanel.this.savChkBoxChanged();
                }
            });
        }
        return this.SAVChkBox;
    }

    private void savChkBoxChanged() {
        boolean enabled = this.getSAVChkBox().isSelected();
        this.getEmailChkBox().setEnabled(enabled);
        this.getDownloadChkBox().setEnabled(enabled);
        this.getTruScanChkBox().setEnabled(enabled);
        if (!enabled) {
            this.getEmailChkBox().setSelected(false);
            this.getDownloadChkBox().setSelected(enabled);
            this.getTruScanChkBox().setSelected(enabled);
            this.emailChkBoxChanged();
        }
    }

    private JCheckBox getEmailChkBox() {
        if (this.emailChkBox == null) {
            this.emailChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.EmailChkBox"));
            this.emailChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.EmailChkBoxTips"));
            this.emailChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientInstallationSAVFeaturesPanel.this.emailChkBoxChanged();
                }
            });
        }
        return this.emailChkBox;
    }

    private void emailChkBoxChanged() {
        boolean enabled = this.getEmailChkBox().isSelected();
        this.getOutlookChkBox().setEnabled(enabled);
        this.getPop3ChkBox().setEnabled(enabled);
        if (!this.isSBProduct()) {
            this.getNotesChkBox().setEnabled(enabled);
        }
        if (!enabled) {
            this.getOutlookChkBox().setSelected(enabled);
            this.getPop3ChkBox().setSelected(enabled);
            if (!this.isSBProduct()) {
                this.getNotesChkBox().setSelected(enabled);
            }
        }
    }

    private JCheckBox getOutlookChkBox() {
        if (this.outlookChkBox == null) {
            this.outlookChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.OutlookChkBox"));
            this.outlookChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.OutlookChkBoxTips"));
            this.outlookChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientInstallationSAVFeaturesPanel.this.onOutlookChkBoxChange(ClientInstallationSAVFeaturesPanel.this.outlookChkBox.isSelected());
                }
            });
        }
        return this.outlookChkBox;
    }

    protected void onOutlookChkBoxChange(boolean selected) {
    }

    private JCheckBox getNotesChkBox() {
        if (this.notesChkBox == null) {
            this.notesChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.NotesChkBox"));
            this.notesChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.NotesChkBoxTips"));
        }
        return this.notesChkBox;
    }

    private JCheckBox getPop3ChkBox() {
        if (this.pop3ChkBox == null) {
            this.pop3ChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.Pop3ChkBox"));
            this.pop3ChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.Pop3ChkBoxTips"));
        }
        return this.pop3ChkBox;
    }

    private JCheckBox getDeviceChkBox() {
        if (this.deviceChkBox == null) {
            this.deviceChkBox = new JCheckBox(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.DeviceChkBox"));
            this.deviceChkBox.setToolTipText(ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.DeviceChkBoxTips"));
        }
        return this.deviceChkBox;
    }

    public boolean isValidate() {
        boolean checked = false;
        if (!this.isSBProduct()) {
            if (this.SAVChkBox.isSelected() || this.emailChkBox.isSelected() || this.outlookChkBox.isSelected() || this.notesChkBox.isSelected() || this.pop3ChkBox.isSelected() || this.ntpChkBox.isSelected() || this.deviceChkBox.isSelected() || this.ITPChkBox.isSelected() || this.downloadChkBox.isSelected()) {
                checked = true;
            }
        } else if (this.isSBProduct() && (this.SAVChkBox.isSelected() || this.ntpChkBox.isSelected())) {
            checked = true;
        }
        return checked;
    }

    public String getEnabledCategories() {
        Object catString = "";
        if (this.SAVChkBox.isSelected() && this.ntpChkBox.isSelected() && (this.ITPChkBox.isSelected() || this.deviceChkBox.isSelected())) {
            catString = (String)catString + ClientInstallationSAVFeaturesPanel.getString("ClientInstallationSAVFeatureDlg.allFeatureOption");
        } else if (this.SAVChkBox.isSelected() && this.ntpChkBox.isSelected()) {
            catString = (String)catString + this.SAVChkBox.getText() + "+" + this.ntpChkBox.getText();
        } else if (this.ntpChkBox.isSelected() && (this.ITPChkBox.isSelected() || this.deviceChkBox.isSelected())) {
            catString = (String)catString + this.ntpChkBox.getText() + "+" + this.ITPChkBox.getText() + "+" + this.deviceChkBox.getText();
        } else if (this.SAVChkBox.isSelected() && (this.ITPChkBox.isSelected() || this.deviceChkBox.isSelected())) {
            catString = (String)catString + this.SAVChkBox.getText() + "+" + this.ITPChkBox.getText() + "+" + this.deviceChkBox.getText();
        } else if (this.SAVChkBox.isSelected()) {
            catString = (String)catString + this.SAVChkBox.getText();
        } else if (this.ntpChkBox.isSelected()) {
            catString = (String)catString + this.ntpChkBox.getText();
        } else if (this.ITPChkBox.isSelected() || this.deviceChkBox.isSelected()) {
            catString = (String)catString + this.ITPChkBox.getText() + "+" + this.deviceChkBox.getText();
        }
        return catString;
    }

    public void setSBProduct(boolean isSBProduct) {
        this.isSBProduct = isSBProduct;
    }

    public boolean isSBProduct() {
        return this.isSBProduct;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    private void setReadOnly() {
        this.setReadOnly(this.readOnly);
    }

    public void setReadOnly(boolean readOnly) {
        this.getSAVChkBox().setEnabled(!readOnly);
        this.getEmailChkBox().setEnabled(!readOnly);
        this.getOutlookChkBox().setEnabled(!readOnly);
        this.getNotesChkBox().setEnabled(!readOnly);
        this.getPop3ChkBox().setEnabled(!readOnly);
        this.getDeviceChkBox().setEnabled(!readOnly);
        this.getDescArea().setEnabled(!readOnly);
    }
}

