/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientInstallFeatureSetUtility {
    private static Logger logger = Logger.getLogger(ClientInstallFeatureSetUtility.class.getName());
    public static final String CURRENT_VERSION = "14.3.5000.0";
    public static final String VERSION_143RU5 = "14.3.5000.0";
    public static final String VERSION_143RU4 = "14.3.4000.0";
    public static final String VERSION_142RU1 = "14.2.1000.0";
    public static final String VERSION_142 = "14.2.0000.0";
    public static final String VERSION_121RU2 = "12.1.2000.0";
    public static final String VERSION_121 = "12.1.0.0";
    public static final String VERSION_110 = "11.0.0.0";
    public static final String VERSION_120 = "12.0.0.0";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String COMMONUI = "com.sygate.scm.common.ui.ui";
    public static final String STANDARD_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomStandard");
    public static final String EMAIL_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomEmail");
    public static final String BASIC_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomBasic");
    private static final String ALL_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBELaptopDesktopWorkstation");
    private static final String SERVERS_FULL = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBEServers");
    private static final String SERVERS_BASIC = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBEServerLimited");
    private static final String[] CDW_SBE_OPTIONS = new String[]{ALL_PROTECTION, SERVERS_FULL, SERVERS_BASIC};
    private static final String ALL_PROTECTION_DESC = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBEAllProtectionDesc");
    private static final String SERVERS_FULL_DESC = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBEServersDesc");
    private static final String SERVERS_BASIC_DESC = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.SBEServerLimitedDesc");
    private static final String[] CDW_SBE_OPTIONS_DESC = new String[]{ALL_PROTECTION_DESC, SERVERS_FULL_DESC, SERVERS_BASIC_DESC};

    public static ClientInstallationFeatures createNewFeatureSet() {
        ClientInstallationFeatures newFeature = new ClientInstallationFeatures();
        EnabledClientFeatures featurer110 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_110);
        EnabledClientFeatures featurer121 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_121);
        EnabledClientFeatures featurer121Ru2 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_121RU2);
        EnabledClientFeatures featurer142 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_142);
        EnabledClientFeatures featurer142Ru1 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_142RU1);
        EnabledClientFeatures featurer143Ru4 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject(VERSION_143RU4);
        EnabledClientFeatures featurer143Ru5 = ClientInstallFeatureSetUtility.getDefaultEnabledFeatureObject("14.3.5000.0");
        newFeature.addEnabledClientFeatures(featurer110);
        newFeature.addEnabledClientFeatures(featurer121);
        newFeature.addEnabledClientFeatures(featurer121Ru2);
        newFeature.addEnabledClientFeatures(featurer142);
        newFeature.addEnabledClientFeatures(featurer142Ru1);
        newFeature.addEnabledClientFeatures(featurer143Ru4);
        newFeature.addEnabledClientFeatures(featurer143Ru5);
        newFeature.setAppType("105");
        newFeature.setId(Utility.getGUIDString());
        newFeature.setName("");
        return newFeature;
    }

    static EnabledClientFeatures getDefaultEnabledFeatureObject(String version) {
        EnabledClientFeatures clientFeatures = new EnabledClientFeatures();
        if (Utility.compareVersion(version, VERSION_121) < 0) {
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("EMailTools", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ITPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Firewall", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("PTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("COHMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("DCMain", clientFeatures);
        } else if (Utility.compareVersion(version, VERSION_121) == 0) {
            ClientInstallFeatureSetUtility.addNewFeature("Core", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Download", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("PTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("TruScan", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("DCMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Firewall", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ITPMain", clientFeatures);
        } else if (Utility.compareVersion(version, VERSION_121RU2) == 0) {
            ClientInstallFeatureSetUtility.addNewFeature("Core", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Download", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("PTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("TruScan", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("DCMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Firewall", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ITPMain", clientFeatures);
        } else if (Utility.compareVersion(version, VERSION_142) == 0) {
            ClientInstallFeatureSetUtility.addNewFeature("Core", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Download", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("PTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("TruScan", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("DCMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Firewall", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ITPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Saep", clientFeatures);
        } else if (Utility.compareVersion(version, VERSION_142RU1) == 0 || Utility.compareVersion(version, VERSION_143RU4) == 0 || Utility.compareVersion(version, "14.3.5000.0") == 0) {
            ClientInstallFeatureSetUtility.addNewFeature("Core", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Download", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("PTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("TruScan", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("DCMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NTPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Firewall", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ITPMain", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("Saep", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("ADDefense", clientFeatures);
            ClientInstallFeatureSetUtility.addNewFeature("NTR", clientFeatures);
        }
        if (Utility.compareVersion(version, "14.3.5000.0") == 0) {
            clientFeatures.setOptEditable(true);
            clientFeatures.setOptPrimary(true);
        } else {
            clientFeatures.setOptEditable(false);
            clientFeatures.setOptPrimary(false);
        }
        clientFeatures.setOptMinVersion(version);
        return clientFeatures;
    }

    public static List<Object> getDefaultNewFeaturesinVersion(String version) {
        ArrayList<Object> nameList = new ArrayList<Object>();
        if (Utility.compareVersion(version, VERSION_142RU1) >= 0) {
            nameList.add("ADDefense");
            nameList.add("NTR");
        } else if (Utility.compareVersion(version, VERSION_121RU2) < 0 && Utility.compareVersion(version, VERSION_121) >= 0) {
            nameList.add("Core");
            nameList.add("Download");
            nameList.add("NTPMain");
        }
        return nameList;
    }

    public static List<Object> getDependantFeatureList(String name, String version) {
        logger.log(Level.INFO, "Get dependant feature list, name: {0}, version: {1}", new Object[]{name, version});
        ArrayList<Object> nameList = new ArrayList<Object>();
        if (Utility.compareVersion(version, VERSION_121) < 0) {
            if (name.compareToIgnoreCase("SAVMain") == 0) {
                nameList.add("COHMain");
            } else if (name.compareToIgnoreCase("ITPMain") == 0 || name.compareToIgnoreCase("Firewall") == 0) {
                nameList.add("DCMain");
            }
        } else if (Utility.compareVersion(version, VERSION_121) == 0) {
            if (name.compareToIgnoreCase("Download") == 0 || name.compareToIgnoreCase("SAVMain") == 0) {
                nameList.add("TruScan");
                nameList.add("ITPMain");
            }
        } else if (Utility.compareVersion(version, VERSION_121RU2) == 0) {
            if (name.compareToIgnoreCase("SAVMain") == 0) {
                nameList.add("TruScan");
            } else if (name.compareToIgnoreCase("Download") == 0) {
                nameList.add("TruScan");
            }
        } else if (Utility.compareVersion(version, VERSION_142) == 0) {
            if (name.compareToIgnoreCase("SAVMain") == 0) {
                nameList.add("Saep");
                nameList.add("TruScan");
            } else if (name.compareToIgnoreCase("Download") == 0) {
                nameList.add("TruScan");
            }
        } else if (Utility.compareVersion(version, VERSION_142RU1) == 0) {
            if (name.compareToIgnoreCase("SAVMain") == 0) {
                nameList.add("Saep");
                nameList.add("TruScan");
            } else if (name.compareToIgnoreCase("Download") == 0) {
                nameList.add("TruScan");
            }
        } else if (Utility.compareVersion(version, VERSION_143RU4) == 0 && (name.compareToIgnoreCase("SAVMain") == 0 || name.compareToIgnoreCase("Download") == 0)) {
            nameList.add("TruScan");
        } else if (Utility.compareVersion(version, "14.3.5000.0") == 0 && name.compareToIgnoreCase("SAVMain") == 0) {
            nameList.add("TruScan");
        }
        return nameList;
    }

    public static List<Object> getDependingFeatureList(String name, String version) {
        logger.log(Level.INFO, "Get depending feature list, name: {0}, version: {1}", new Object[]{name, version});
        ArrayList<Object> nameList = new ArrayList<Object>();
        if (Utility.compareVersion(version, VERSION_121) < 0) {
            if (name.compareToIgnoreCase("COHMain") == 0) {
                nameList.add("SAVMain");
            } else if (name.compareToIgnoreCase("DCMain") == 0) {
                nameList.add("ITPMain");
            }
        } else if (Utility.compareVersion(version, VERSION_121) == 0) {
            if (name.compareToIgnoreCase("TruScan") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            } else if (name.compareToIgnoreCase("ITPMain") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            }
        } else if (Utility.compareVersion(version, VERSION_121RU2) == 0) {
            if (name.compareToIgnoreCase("TruScan") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            }
        } else if (Utility.compareVersion(version, VERSION_142) == 0) {
            if (name.compareToIgnoreCase("TruScan") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            } else if (name.compareToIgnoreCase("Saep") == 0) {
                nameList.add("SAVMain");
            }
        } else if (Utility.compareVersion(version, VERSION_142RU1) == 0) {
            if (name.compareToIgnoreCase("TruScan") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            } else if (name.compareToIgnoreCase("Saep") == 0) {
                nameList.add("SAVMain");
            }
        } else if (Utility.compareVersion(version, VERSION_143RU4) == 0) {
            if (name.compareToIgnoreCase("TruScan") == 0) {
                nameList.add("SAVMain");
                nameList.add("Download");
            }
        } else if (Utility.compareVersion(version, "14.3.5000.0") == 0 && name.compareToIgnoreCase("TruScan") == 0) {
            nameList.add("SAVMain");
        }
        return nameList;
    }

    public static ClientInstallationFeatures getSBECDWCustomFeatureSet(String option, boolean emailOn) {
        ClientInstallationFeatures newFeature = new ClientInstallationFeatures();
        newFeature.setAppType("105");
        newFeature.setId(Utility.getGUIDString());
        newFeature.setName(option);
        EnabledClientFeatures ecf121Ru2 = ClientInstallFeatureSetUtility.getSBECDWCustomFeatures(option, emailOn, VERSION_121RU2);
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.getSBECDWCustomFeatures(option, emailOn, VERSION_121);
        EnabledClientFeatures ecfOld = ClientInstallFeatureSetUtility.getSBECDWCustomFeatures(option, emailOn, VERSION_120);
        newFeature.addEnabledClientFeatures(ecf121Ru2);
        newFeature.addEnabledClientFeatures(ecf);
        newFeature.addEnabledClientFeatures(ecfOld);
        return newFeature;
    }

    private static EnabledClientFeatures getSBECDWCustomFeatures(String option, boolean emailOn, String version) {
        EnabledClientFeatures clientFeatures = new EnabledClientFeatures();
        if (option.compareToIgnoreCase(STANDARD_PROTECTION) == 0) {
            if (Utility.compareVersion(version, VERSION_121) < 0) {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("EMailTools", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", false, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("COHMain", true, clientFeatures);
                clientFeatures.setOptPrimary(false);
                clientFeatures.setOptEditable(false);
            } else {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Download", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("TruScan", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("NTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("ITPMain", true, clientFeatures);
                if (Utility.compareVersion(version, "14.2.0.0", true) < 0) {
                    ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", false, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", emailOn, clientFeatures);
                } else {
                    ClientInstallFeatureSetUtility.addNewFeature("ADDefense", true, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("NTR", true, clientFeatures);
                }
                clientFeatures.setOptPrimary(true);
                clientFeatures.setOptEditable(true);
            }
            clientFeatures.setOptMinVersion(version);
        } else if (option.compareToIgnoreCase(BASIC_PROTECTION) == 0) {
            if (Utility.compareVersion(version, VERSION_121) < 0) {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("EMailTools", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", emailOn, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", emailOn, clientFeatures);
                clientFeatures.setOptPrimary(false);
                clientFeatures.setOptEditable(false);
            } else {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", emailOn, clientFeatures);
                if (Utility.compareVersion(version, "14.2.0.0", true) < 0) {
                    ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", false, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", emailOn, clientFeatures);
                } else {
                    ClientInstallFeatureSetUtility.addNewFeature("ADDefense", true, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("NTR", true, clientFeatures);
                }
                clientFeatures.setOptPrimary(true);
                clientFeatures.setOptEditable(true);
            }
            clientFeatures.setOptMinVersion(version);
        }
        return clientFeatures;
    }

    public static List<Object> getSBECDWFeatureOptions() {
        ArrayList<Object> options = new ArrayList<Object>();
        for (int i = 0; i < CDW_SBE_OPTIONS.length; ++i) {
            ClientInstallationFeatures cif = null;
            cif = ClientInstallFeatureSetUtility.getSBECDWFeatureSet(CDW_SBE_OPTIONS[i], CDW_SBE_OPTIONS_DESC[i]);
            options.add(cif);
        }
        return options;
    }

    private static ClientInstallationFeatures getSBECDWFeatureSet(String name, String desc) {
        ClientInstallationFeatures newFeature = new ClientInstallationFeatures();
        newFeature.setAppType("105");
        newFeature.setId(Utility.getGUIDString());
        newFeature.setName(name);
        newFeature.setOptDescription(desc);
        EnabledClientFeatures ecf121Ru2 = ClientInstallFeatureSetUtility.getSBECDWDefaultFeatures(name, VERSION_121RU2);
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.getSBECDWDefaultFeatures(name, VERSION_121);
        EnabledClientFeatures ecfOld = ClientInstallFeatureSetUtility.getSBECDWDefaultFeatures(name, VERSION_120);
        newFeature.addEnabledClientFeatures(ecf121Ru2);
        newFeature.addEnabledClientFeatures(ecf);
        newFeature.addEnabledClientFeatures(ecfOld);
        return newFeature;
    }

    private static EnabledClientFeatures getSBECDWDefaultFeatures(String option, String version) {
        EnabledClientFeatures clientFeatures = new EnabledClientFeatures();
        if (option.compareToIgnoreCase(ALL_PROTECTION) == 0) {
            if (Utility.compareVersion(version, VERSION_121) < 0) {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("EMailTools", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("ITPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("COHMain", true, clientFeatures);
                clientFeatures.setOptPrimary(false);
                clientFeatures.setOptEditable(false);
            } else {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Download", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("OutlookSnapin", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("TruScan", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("NTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("ITPMain", true, clientFeatures);
                if (Utility.compareVersion(version, "14.2.0.0", true) < 0) {
                    ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", false, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", false, clientFeatures);
                } else {
                    ClientInstallFeatureSetUtility.addNewFeature("ADDefense", true, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("NTR", true, clientFeatures);
                }
                clientFeatures.setOptPrimary(true);
                clientFeatures.setOptEditable(true);
            }
            clientFeatures.setOptMinVersion(version);
        } else if (option.compareToIgnoreCase(SERVERS_FULL) == 0) {
            if (Utility.compareVersion(version, VERSION_121) < 0) {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("ITPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("COHMain", true, clientFeatures);
                clientFeatures.setOptPrimary(false);
                clientFeatures.setOptEditable(false);
            } else {
                ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Download", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("PTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("TruScan", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("NTPMain", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("Firewall", true, clientFeatures);
                ClientInstallFeatureSetUtility.addNewFeature("ITPMain", true, clientFeatures);
                if (Utility.compareVersion(version, "14.2.0.0") < 0) {
                    ClientInstallFeatureSetUtility.addNewFeature("NotesSnapin", false, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("Pop3Smtp", false, clientFeatures);
                } else {
                    ClientInstallFeatureSetUtility.addNewFeature("ADDefense", true, clientFeatures);
                    ClientInstallFeatureSetUtility.addNewFeature("NTR", true, clientFeatures);
                }
                clientFeatures.setOptPrimary(true);
                clientFeatures.setOptEditable(true);
            }
            clientFeatures.setOptMinVersion(version);
        } else if (option.compareToIgnoreCase(SERVERS_BASIC) == 0) {
            ClientInstallFeatureSetUtility.addNewFeature("SAVMain", true, clientFeatures);
            boolean isCurrent = Utility.compareVersion(version, VERSION_121RU2) > 0;
            clientFeatures.setOptPrimary(isCurrent);
            clientFeatures.setOptEditable(isCurrent);
            clientFeatures.setOptMinVersion(version);
        }
        return clientFeatures;
    }

    private static void addNewFeature(String feature, boolean on, EnabledClientFeatures clientFeatures) {
        ClientFeature clientFeature = new ClientFeature();
        clientFeature.setFeatureName(feature);
        clientFeature.setOptEnabled(on);
        clientFeatures.addClientFeature(clientFeature);
    }

    private static void addNewFeature(String feature, EnabledClientFeatures clientFeatures) {
        ClientFeature clientFeature = new ClientFeature();
        clientFeature.setFeatureName(feature);
        clientFeature.setOptEnabled(true);
        clientFeatures.addClientFeature(clientFeature);
    }

    public static List<Object> getFeaturesListByVersion(String version) {
        ArrayList<Object> featureList = new ArrayList<Object>();
        if (Utility.compareVersion(version, VERSION_121) <= 0) {
            featureList.add("SAVMain");
            featureList.add("EMailTools");
            featureList.add("OutlookSnapin");
            featureList.add("NotesSnapin");
            featureList.add("Pop3Smtp");
            featureList.add("ITPMain");
            featureList.add("Firewall");
            featureList.add("PTPMain");
            featureList.add("COHMain");
            featureList.add("DCMain");
        } else if (Utility.compareVersion(version, VERSION_121RU2) <= 0) {
            featureList.add("Core");
            featureList.add("SAVMain");
            featureList.add("Download");
            featureList.add("OutlookSnapin");
            featureList.add("NotesSnapin");
            featureList.add("Pop3Smtp");
            featureList.add("PTPMain");
            featureList.add("TruScan");
            featureList.add("DCMain");
            featureList.add("NTPMain");
            featureList.add("Firewall");
            featureList.add("ITPMain");
        } else if (Utility.compareVersion(version, VERSION_142) <= 0) {
            featureList.add("Core");
            featureList.add("SAVMain");
            featureList.add("Download");
            featureList.add("OutlookSnapin");
            featureList.add("PTPMain");
            featureList.add("TruScan");
            featureList.add("DCMain");
            featureList.add("NTPMain");
            featureList.add("Firewall");
            featureList.add("ITPMain");
            featureList.add("Saep");
        } else if (Utility.compareVersion(version, "14.3.5000.0") <= 0) {
            featureList.add("Core");
            featureList.add("SAVMain");
            featureList.add("Download");
            featureList.add("OutlookSnapin");
            featureList.add("PTPMain");
            featureList.add("TruScan");
            featureList.add("DCMain");
            featureList.add("NTPMain");
            featureList.add("Firewall");
            featureList.add("ITPMain");
            featureList.add("Saep");
            featureList.add("ADDefense");
            featureList.add("NTR");
        }
        return featureList;
    }

    public static List<Object> getDefaultSecondLevelFeatureList(String version, String feature) {
        ArrayList<Object> featureList = new ArrayList<Object>();
        if (Utility.compareVersion(version, VERSION_121) < 0) {
            if (feature.compareToIgnoreCase("SAVMain") == 0) {
                featureList.add("OutlookSnapin");
                featureList.add("NotesSnapin");
                featureList.add("Pop3Smtp");
            } else if (feature.compareToIgnoreCase("ITPMain") == 0) {
                featureList.add("Firewall");
            } else {
                featureList.add("PTPMain");
                featureList.add("COHMain");
                featureList.add("DCMain");
            }
        } else if (feature.compareToIgnoreCase("SAVMain") == 0) {
            featureList.add("Download");
            featureList.add("OutlookSnapin");
            if (Utility.compareVersion(version, "14.2.0.0", true) < 0) {
                featureList.add("NotesSnapin");
                featureList.add("Pop3Smtp");
            } else {
                featureList.add("ADDefense");
                featureList.add("NTR");
            }
        } else if (feature.compareToIgnoreCase("NTPMain") == 0) {
            featureList.add("Firewall");
            featureList.add("ITPMain");
        } else {
            featureList.add("PTPMain");
            featureList.add("TruScan");
            featureList.add("DCMain");
        }
        return featureList;
    }

    public static EnabledClientFeatures findEnabledFeaturesByVersion(String version, ClientInstallationFeatures cif) {
        EnabledClientFeatures clientFeatures = null;
        clientFeatures = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(version, cif);
        return clientFeatures;
    }

    public static EnabledClientFeatures findFeatureVersionFromFeatureSet(String version, ClientInstallationFeatures features) {
        return ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(version, features, true);
    }

    public static EnabledClientFeatures findFeatureVersionFromFeatureSet(String version, ClientInstallationFeatures features, boolean isPackageVersion) {
        if (isPackageVersion) {
            version = Utility.getFeatureSetVersion(version);
        }
        Vector<EnabledClientFeatures> allList = features.getEnabledClientFeatures();
        EnabledClientFeatures clientFeatures = null;
        if (allList.size() > 0) {
            for (int i = 0; i < allList.size(); ++i) {
                EnabledClientFeatures ecf = allList.get(i);
                if (ecf == null) continue;
                String minVer = ecf.getOptMinVersion();
                if (minVer != null && minVer.compareToIgnoreCase(version) == 0) {
                    clientFeatures = ecf;
                    break;
                }
                if (version.equalsIgnoreCase(VERSION_120) && Utility.compareVersion(minVer, VERSION_110) == 0) {
                    clientFeatures = ecf;
                    break;
                }
                if (Utility.compareVersion(version, VERSION_110) != 0 || Utility.compareVersion(version, minVer) >= 0 || Utility.compareVersion(minVer, VERSION_121) >= 0) continue;
                clientFeatures = ecf;
                break;
            }
        }
        return clientFeatures;
    }

    private static Vector<ClientFeature> getActiveFeatures(EnabledClientFeatures ef) {
        Vector<ClientFeature> activeList = new Vector<ClientFeature>();
        Vector<ClientFeature> all = ef.getClientFeature();
        if (all != null && !all.isEmpty()) {
            boolean enabled = false;
            for (int i = 0; i < all.size(); ++i) {
                ClientFeature cf = all.get(i);
                boolean bl = enabled = cf.getOptEnabled() == null ? cf.getDefEnabled().booleanValue() : cf.getOptEnabled().booleanValue();
                if (!enabled) continue;
                activeList.add(cf);
            }
        }
        return activeList;
    }

    public static boolean updateFeatureSet(String featureSetVersion, ClientInstallationFeatures cif, EnabledClientFeatures selected) {
        boolean tf = false;
        Vector<EnabledClientFeatures> allList = cif.getEnabledClientFeatures();
        if (allList.size() > 0) {
            for (int i = 0; i < allList.size(); ++i) {
                EnabledClientFeatures ecf = allList.get(i);
                if (ecf == null || !ecf.getOptMinVersion().equalsIgnoreCase(featureSetVersion)) continue;
                cif.removeEnabledClientFeatures(ecf);
                cif.addEnabledClientFeatures(selected);
                break;
            }
        }
        return tf;
    }

    public static List<String> getVersionList() {
        ArrayList<String> vl = new ArrayList<String>();
        vl.add("14.3.5000.0");
        vl.add(VERSION_143RU4);
        vl.add(VERSION_142RU1);
        vl.add(VERSION_142);
        vl.add(VERSION_121RU2);
        vl.add(VERSION_121);
        vl.add(VERSION_110);
        return vl;
    }

    public static boolean containsFeature(EnabledClientFeatures ecf, String feature) {
        boolean tf = false;
        Vector<ClientFeature> list = ecf.getClientFeature();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ClientFeature cf = list.get(i);
                if (cf.getFeatureName().compareToIgnoreCase(feature) != 0) continue;
                tf = true;
                break;
            }
        }
        return tf;
    }

    public static ClientFeature findFeature(EnabledClientFeatures ecf, String feature) {
        ClientFeature retFeature = null;
        Vector<ClientFeature> list = ecf.getClientFeature();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ClientFeature cf = list.get(i);
                if (cf.getFeatureName().compareToIgnoreCase(feature) != 0) continue;
                retFeature = cf;
                break;
            }
        }
        return retFeature;
    }

    public static EnabledClientFeatures autoConvertFeatures(EnabledClientFeatures ecf, String toVersion) {
        EnabledClientFeatures retFeatures = ecf;
        if (Utility.compareVersion(toVersion, VERSION_121) < 0) {
            ClientFeature sonar;
            ClientFeature ntp;
            ClientFeature cf;
            ClientFeature core = ClientInstallFeatureSetUtility.findFeature(ecf, "Core");
            if (core != null) {
                retFeatures.removeClientFeature(core);
            }
            if ((cf = ClientInstallFeatureSetUtility.findFeature(ecf, "Download")) != null) {
                retFeatures.removeClientFeature(cf);
            }
            if ((ntp = ClientInstallFeatureSetUtility.findFeature(ecf, "NTPMain")) != null) {
                retFeatures.removeClientFeature(ntp);
            }
            if ((sonar = ClientInstallFeatureSetUtility.findFeature(ecf, "TruScan")) != null) {
                retFeatures.removeClientFeature(sonar);
                ClientInstallFeatureSetUtility.turnOnOff("COHMain", retFeatures, true);
            }
        }
        retFeatures = ClientInstallFeatureSetUtility.doDependencyCheck(retFeatures, toVersion);
        retFeatures.setOptEditable(false);
        retFeatures.setOptMinVersion(toVersion);
        retFeatures.setOptPrimary(false);
        return retFeatures;
    }

    public static EnabledClientFeatures autoConvertFeaturesFromList(List<ClientFeature> cfl, String toVersion, boolean editable) {
        EnabledClientFeatures ecf = new EnabledClientFeatures();
        ecf.setOptMinVersion(toVersion);
        List<Object> newList = ClientInstallFeatureSetUtility.getDefaultNewFeaturesinVersion(VERSION_121);
        ecf.setOptEditable(editable);
        boolean isTo121Version = Utility.compareVersion(toVersion, VERSION_121) >= 0;
        ecf.setOptPrimary(isTo121Version);
        if (cfl != null && !cfl.isEmpty()) {
            for (ClientFeature cf : cfl) {
                String name;
                if (null == cf || (name = cf.getFeatureName()).isEmpty() || newList.contains(name)) continue;
                if (name.compareToIgnoreCase("TruScan") == 0 && !isTo121Version) {
                    cf.setFeatureName("COHMain");
                    ecf.addClientFeature(cf);
                    continue;
                }
                if (name.compareToIgnoreCase("COHMain") == 0 && isTo121Version) {
                    cf.setFeatureName("TruScan");
                    ecf.addClientFeature(cf);
                    continue;
                }
                ecf.addClientFeature(cf);
            }
        }
        ecf = ClientInstallFeatureSetUtility.doDependencyCheck(ecf, toVersion);
        return ecf;
    }

    public static EnabledClientFeatures autoConvert121Ru2FeaturesFromList(List<ClientFeature> l, String toVersion, boolean editable) {
        EnabledClientFeatures ecf = new EnabledClientFeatures();
        ecf.setOptMinVersion(toVersion);
        List<Object> newList = ClientInstallFeatureSetUtility.getDefaultNewFeaturesinVersion(VERSION_121RU2);
        ecf.setOptEditable(editable);
        boolean isTo121Ru2Version = Utility.compareVersion(toVersion, VERSION_121RU2) >= 0;
        ecf.setOptPrimary(isTo121Ru2Version);
        if (l != null && !l.isEmpty()) {
            for (int i = 0; i < l.size(); ++i) {
                ClientFeature cf = l.get(i);
                String name = cf.getFeatureName();
                if (name.isEmpty() || newList.contains(name)) continue;
                ecf.addClientFeature(cf);
            }
        }
        ecf = ClientInstallFeatureSetUtility.doDependencyCheck(ecf, toVersion);
        return ecf;
    }

    public static EnabledClientFeatures autoConvert142FeaturesFromList(List<ClientFeature> l, String toVersion, boolean editable) {
        EnabledClientFeatures ecf = new EnabledClientFeatures();
        ecf.setOptMinVersion(toVersion);
        List<Object> newList = ClientInstallFeatureSetUtility.getDefaultNewFeaturesinVersion(VERSION_142);
        ecf.setOptEditable(editable);
        boolean isTo142Version = Utility.compareVersion(toVersion, VERSION_142) >= 0;
        ecf.setOptPrimary(isTo142Version);
        if (l != null && !l.isEmpty()) {
            for (int i = 0; i < l.size(); ++i) {
                ClientFeature cf = l.get(i);
                String name = cf.getFeatureName();
                if (name.isEmpty() || newList.contains(name)) continue;
                ecf.addClientFeature(cf);
            }
        }
        ecf = ClientInstallFeatureSetUtility.doDependencyCheck(ecf, toVersion);
        return ecf;
    }

    public static EnabledClientFeatures autoConvert142RU1FeaturesFromList(List<ClientFeature> l, String toVersion, boolean editable) {
        EnabledClientFeatures ecf = new EnabledClientFeatures();
        ecf.setOptMinVersion(toVersion);
        List<Object> newList = ClientInstallFeatureSetUtility.getDefaultNewFeaturesinVersion(VERSION_142RU1);
        ecf.setOptEditable(editable);
        boolean isTo142Ru1Version = Utility.compareVersion(toVersion, VERSION_142RU1) >= 0;
        ecf.setOptPrimary(isTo142Ru1Version);
        if (l != null && !l.isEmpty()) {
            for (int i = 0; i < l.size(); ++i) {
                ClientFeature cf = l.get(i);
                String name = cf.getFeatureName();
                if (name.isEmpty() || newList.contains(name)) continue;
                ecf.addClientFeature(cf);
            }
        }
        ecf = ClientInstallFeatureSetUtility.doDependencyCheck(ecf, toVersion);
        return ecf;
    }

    public static EnabledClientFeatures autoConvertFeatures(List<ClientFeature> features, String toVersion, boolean editable) {
        EnabledClientFeatures ecf = new EnabledClientFeatures();
        ecf.setOptMinVersion(toVersion);
        ecf.setOptEditable(editable);
        boolean isTo143Ru4AndLaterVersion = Utility.compareVersion(toVersion, VERSION_143RU4) >= 0;
        ecf.setOptPrimary(isTo143Ru4AndLaterVersion);
        if (features != null && !features.isEmpty()) {
            for (int i = 0; i < features.size(); ++i) {
                ClientFeature cf = features.get(i);
                String name = cf.getFeatureName();
                if (name.isEmpty()) continue;
                ecf.addClientFeature(cf);
            }
        }
        ecf = ClientInstallFeatureSetUtility.doDependencyCheck(ecf, toVersion);
        return ecf;
    }

    private static EnabledClientFeatures doDependencyCheck(EnabledClientFeatures ecf, String toVersion) {
        EnabledClientFeatures retValue = ecf;
        Vector<ClientFeature> fList = ClientInstallFeatureSetUtility.getActiveFeatures(retValue);
        if (fList != null) {
            for (int i = 0; i < fList.size(); ++i) {
                ClientFeature cf = fList.get(i);
                String feature = cf.getFeatureName();
                if (Utility.compareVersion(toVersion, VERSION_121) < 0) {
                    if (feature.compareToIgnoreCase("COHMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        continue;
                    }
                    if (feature.compareToIgnoreCase("DCMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("ITPMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Firewall", retValue);
                        continue;
                    }
                    if (feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("Firewall", retValue);
                        continue;
                    }
                    if (feature.compareToIgnoreCase("Firewall") != 0) continue;
                    ClientInstallFeatureSetUtility.turnOn("ITPMain", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, VERSION_121) == 0) {
                    if (feature.compareToIgnoreCase("TruScan") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Download", retValue);
                    }
                    if (feature.compareToIgnoreCase("Firewall") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                    }
                    ClientInstallFeatureSetUtility.turnOn("Core", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, VERSION_121RU2) == 0) {
                    if (feature.compareToIgnoreCase("TruScan") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Download", retValue);
                    }
                    if (feature.compareToIgnoreCase("Firewall") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                    }
                    ClientInstallFeatureSetUtility.turnOn("Core", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, VERSION_142) == 0) {
                    if (feature.compareToIgnoreCase("TruScan") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Download", retValue);
                    }
                    if (feature.compareToIgnoreCase("Firewall") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                    }
                    if (feature.compareToIgnoreCase("Saep") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                    }
                    ClientInstallFeatureSetUtility.turnOn("Core", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, VERSION_142RU1) == 0) {
                    if (feature.compareToIgnoreCase("TruScan") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Download", retValue);
                    }
                    if (feature.compareToIgnoreCase("Firewall") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                    }
                    if (feature.compareToIgnoreCase("Saep") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                    }
                    ClientInstallFeatureSetUtility.turnOn("Core", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, VERSION_143RU4) == 0) {
                    if (feature.compareToIgnoreCase("TruScan") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                        ClientInstallFeatureSetUtility.turnOn("Download", retValue);
                    }
                    if (feature.compareToIgnoreCase("Firewall") == 0 || feature.compareToIgnoreCase("ITPMain") == 0) {
                        ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                    }
                    ClientInstallFeatureSetUtility.turnOn("Core", retValue);
                    continue;
                }
                if (Utility.compareVersion(toVersion, "14.3.5000.0") != 0) continue;
                if (feature.compareToIgnoreCase("TruScan") == 0) {
                    ClientInstallFeatureSetUtility.turnOn("SAVMain", retValue);
                }
                if (feature.compareToIgnoreCase("ITPMain") == 0 || feature.compareToIgnoreCase("Firewall") == 0) {
                    ClientInstallFeatureSetUtility.turnOn("NTPMain", retValue);
                }
                ClientInstallFeatureSetUtility.turnOn("Core", retValue);
            }
        }
        return retValue;
    }

    private static void turnOn(String feature, EnabledClientFeatures ecf) {
        ClientFeature cf = ClientInstallFeatureSetUtility.findFeature(ecf, feature);
        if (cf == null) {
            cf = new ClientFeature();
            cf.setFeatureName(feature);
            cf.setOptEnabled(true);
            ecf.addClientFeature(cf);
        } else {
            cf.setOptEnabled(true);
        }
    }

    public static void turnOnOff(String feature, EnabledClientFeatures ecf, boolean onoff) {
        ClientFeature cf = ClientInstallFeatureSetUtility.findFeature(ecf, feature);
        if (cf == null) {
            cf = new ClientFeature();
            cf.setFeatureName(feature);
            cf.setOptEnabled(onoff);
            ecf.addClientFeature(cf);
        } else {
            cf.setOptEnabled(onoff);
        }
    }

    public static ClientFeature findFeature(String feature, String version, ClientInstallationFeatures cif) {
        ClientFeature cf = null;
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(version, cif, false);
        if (ecf != null) {
            cf = ClientInstallFeatureSetUtility.findFeature(ecf, feature);
        }
        return cf;
    }

    public static boolean mapClientInstallationFeatures(ClientInstallationFeatures installFeature) {
        boolean updated = false;
        if (installFeature == null) {
            return false;
        }
        Vector<EnabledClientFeatures> vFeatures = installFeature.getEnabledClientFeatures();
        if (vFeatures != null && vFeatures.size() == 1) {
            EnabledClientFeatures ecf;
            if (installFeature.getOptObjAttributes() != null && installFeature.getOptObjAttributes() == 1L) {
                installFeature.setOptObjAttributes(null);
            }
            if ((ecf = installFeature.getEnabledClientFeatures(0)) == null) {
                return false;
            }
            ecf.setOptEditable(false);
            ecf.setOptMinVersion(VERSION_110);
            ecf.setOptPrimary(false);
            Vector<ClientFeature> vFeat = ecf.getClientFeature();
            for (int iFeat = 0; vFeat != null && iFeat < vFeat.size(); ++iFeat) {
                ClientFeature feature = vFeat.get(iFeat);
                feature.setOptEnabled(true);
            }
            EnabledClientFeatures ecf121 = ClientInstallFeatureSetUtility.autoConvertFeaturesFromList(ecf.getClientFeature(), VERSION_121, true);
            installFeature.addEnabledClientFeatures(ecf121);
            updated = true;
        }
        return updated;
    }

    public static boolean validateClientFeatureNames(ClientInstallationFeatures clientFeatures, boolean correct) {
        boolean hasInvalid = false;
        try {
            Vector<EnabledClientFeatures> vFeatures = clientFeatures.getEnabledClientFeatures();
            for (int iEnabled = 0; vFeatures != null && iEnabled < vFeatures.size(); ++iEnabled) {
                int i;
                ClientFeature clientFeature;
                int iFeatureUnit;
                Vector<ClientFeature> vFeatureUnit;
                EnabledClientFeatures features = vFeatures.get(iEnabled);
                if (VERSION_110.equalsIgnoreCase(features.getOptMinVersion())) {
                    vFeatureUnit = features.getClientFeature();
                    boolean updated = false;
                    for (iFeatureUnit = 0; vFeatureUnit != null && iFeatureUnit < vFeatureUnit.size(); ++iFeatureUnit) {
                        clientFeature = vFeatureUnit.get(iFeatureUnit);
                        if (!"TruScan".equalsIgnoreCase(clientFeature.getFeatureName())) continue;
                        if (correct && !clientFeatures.isReadonly()) {
                            clientFeature.setFeatureName("COHMain");
                            updated = true;
                        }
                        hasInvalid = true;
                    }
                    if (!updated) continue;
                    features = ClientInstallFeatureSetUtility.doDependencyCheck(features, VERSION_110);
                    continue;
                }
                if (VERSION_121.equalsIgnoreCase(features.getOptMinVersion())) {
                    vFeatureUnit = features.getClientFeature();
                    ArrayList<ClientFeature> invalidFeatures = new ArrayList<ClientFeature>();
                    for (iFeatureUnit = 0; vFeatureUnit != null && iFeatureUnit < vFeatureUnit.size(); ++iFeatureUnit) {
                        clientFeature = vFeatureUnit.get(iFeatureUnit);
                        if (!"EMailTools".equalsIgnoreCase(clientFeature.getFeatureName())) continue;
                        invalidFeatures.add(clientFeature);
                        hasInvalid = true;
                    }
                    if (!correct || !hasInvalid || clientFeatures.isReadonly()) continue;
                    for (i = 0; i < invalidFeatures.size(); ++i) {
                        features.removeClientFeature((ClientFeature)invalidFeatures.get(i));
                    }
                    features = ClientInstallFeatureSetUtility.doDependencyCheck(features, VERSION_121);
                    continue;
                }
                if (!VERSION_121RU2.equalsIgnoreCase(features.getOptMinVersion())) continue;
                vFeatureUnit = features.getClientFeature();
                ArrayList<ClientFeature> invalidFeatures = new ArrayList<ClientFeature>();
                for (iFeatureUnit = 0; vFeatureUnit != null && iFeatureUnit < vFeatureUnit.size(); ++iFeatureUnit) {
                    clientFeature = vFeatureUnit.get(iFeatureUnit);
                    if (!"EMailTools".equalsIgnoreCase(clientFeature.getFeatureName())) continue;
                    invalidFeatures.add(clientFeature);
                    hasInvalid = true;
                }
                if (!correct || !hasInvalid || clientFeatures.isReadonly()) continue;
                for (i = 0; i < invalidFeatures.size(); ++i) {
                    features.removeClientFeature((ClientFeature)invalidFeatures.get(i));
                }
                features = ClientInstallFeatureSetUtility.doDependencyCheck(features, VERSION_121RU2);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return hasInvalid;
    }

    public static boolean containsEnabledClientFeatures(ClientInstallationFeatures installFeature, String featureSetVersion) {
        for (int i = 0; i < installFeature.getEnabledClientFeaturesCount(); ++i) {
            EnabledClientFeatures ecf = installFeature.getEnabledClientFeatures(i);
            if (!featureSetVersion.equals(ecf.getOptMinVersion())) continue;
            return true;
        }
        return false;
    }

    public static boolean mapClientInstallationFeaturesToNewVersion(ClientInstallationFeatures installFeature, String featureSetVersionFrom, String featureSetVersionTo, String domainID) {
        EnabledClientFeatures ecf143ru4 = null;
        for (int i = 0; i < installFeature.getEnabledClientFeaturesCount(); ++i) {
            EnabledClientFeatures ecf = installFeature.getEnabledClientFeatures(i);
            if (!featureSetVersionFrom.equals(ecf.getOptMinVersion())) continue;
            ecf.setOptEditable(false);
            ecf.setOptPrimary(false);
            ArrayList<ClientFeature> features = new ArrayList<ClientFeature>();
            Vector<ClientFeature> all = ecf.getClientFeature();
            for (int j = 0; j < all.size(); ++j) {
                features.add((ClientFeature)all.get(j).clone());
            }
            ecf143ru4 = ClientInstallFeatureSetUtility.autoConvertFeatures(features, featureSetVersionTo, true);
            break;
        }
        if (ecf143ru4 == null) {
            return false;
        }
        DeterministicIdWasher.resetEnabledClientFeaturesIDs(ecf143ru4, domainID + installFeature.getName() + featureSetVersionTo);
        installFeature.addEnabledClientFeatures(ecf143ru4);
        return true;
    }
}

