/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIColorUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class CleanComboBoxUI
extends MetalComboBoxUI {
    private ImageIcon enabledIcon = CustomLookAndFeel.DOWN_ARROW_ICON;
    private ImageIcon disabledIcon = CustomLookAndFeel.DOWN_ARROW_ICON;

    public static ComponentUI createUI(JComponent component) {
        return new CleanComboBoxUI();
    }

    @Override
    protected JButton createArrowButton() {
        JButton button;
        if (null == this.enabledIcon || null == this.disabledIcon) {
            button = super.createArrowButton();
        } else {
            button = new JButton(this.enabledIcon);
            button.setDisabledIcon(this.disabledIcon);
        }
        button.putClientProperty("isCustomButton", Boolean.TRUE);
        button.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isPressed() {
                return false;
            }
        });
        button.setBackground(UIColorUtilities.DEFAULT_BACKGROUND);
        button.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        return button;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component component = comboBoxEditor.getEditorComponent();
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder());
        }
        return comboBoxEditor;
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (hasFocus && !this.isPopupVisible(this.comboBox) && this.arrowButton != null) {
            g.setColor(this.listBox.getSelectionBackground());
            Insets buttonInsets = this.arrowButton.getInsets();
            if (buttonInsets.top > 2) {
                g.fillRect(bounds.x + 2, bounds.y + 2, bounds.width - 3, buttonInsets.top - 2);
            }
            if (buttonInsets.bottom > 2) {
                g.fillRect(bounds.x + 2, bounds.y + bounds.height - buttonInsets.bottom, bounds.width - 3, buttonInsets.bottom - 2);
            }
        }
    }
}

