/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CheckBoxNode;
import com.sygate.scm.common.ui.CheckBoxNodeRenderer;
import com.sygate.scm.common.ui.FeatureChangeEvent;
import com.sygate.scm.common.ui.FeatureChangeListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = 1L;
    private transient CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    private JTree tree;
    private DefaultMutableTreeNode editedNode;
    private final transient ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            final FeatureChangeEvent featureEvent = new FeatureChangeEvent(itemEvent.getSource());
            CheckBoxNodeEditor.this.fireEditingStopped();
            AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckBoxNodeEditor.this.fireFeatureChangeEvent(featureEvent);
                }
            }), () -> CheckBoxNodeEditor.this.fireFeatureChangeEvent(featureEvent));
        }
    };

    public CheckBoxNodeEditor(JTree tree) {
        this.tree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        JCheckBox checkbox = this.renderer.getLeafRenderer();
        CheckBoxNode checkBoxNode = new CheckBoxNode(checkbox.getText(), checkbox.isSelected());
        return checkBoxNode;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        boolean returnValue = false;
        if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
            this.editedNode = (DefaultMutableTreeNode)node;
            Object userObject = this.editedNode.getUserObject();
            Rectangle r = this.tree.getPathBounds(path);
            if (r != null) {
                int x = mouseEvent.getX() - r.x;
                JCheckBox checkbox = this.renderer.getLeafRenderer();
                checkbox.setText("");
                returnValue = userObject instanceof CheckBoxNode && x > 0 && x < checkbox.getPreferredSize().width;
            }
        }
        return returnValue;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        if (editor instanceof JCheckBox && !Arrays.asList((ItemListener[])((JCheckBox)editor).getListeners(ItemListener.class)).contains(this.itemListener)) {
            ((JCheckBox)editor).addItemListener(this.itemListener);
        }
        return editor;
    }

    public void addFeatureChangeEventListener(FeatureChangeListener listener) {
        this.listenerList.add(FeatureChangeListener.class, listener);
    }

    private void fireFeatureChangeEvent(FeatureChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != FeatureChangeListener.class) continue;
            ((FeatureChangeListener)listeners[i + 1]).featureChanged(evt);
        }
    }
}

