/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CertificateDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JButton jBYes = new JButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.btnYes"));
    private final JButton jBNo = new JButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.btnNo"));
    private final JButton jBOK = new JButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.btnOK"));
    private final JButton jBMore = new JButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.btnMoreDetails"));
    protected X509Certificate cert = null;
    private boolean isOk;
    private ImageIcon icon;
    private final JFrame frame;
    private String message = MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.msgPartnerCertificateVerified");
    private String continueMsg = MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.msgDoUWantToTrustCertificate");
    private static final String SERVER_HOME = "catalina.home";
    private static final String KEYSTORE = System.getProperty("catalina.home") + File.separator + "etc" + File.separator + "keystore.jks";
    private static final String STORE_PASSWD_FILE = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + "server.xml";
    private char[] storePasswd;
    public static final String CN = "CN";
    public static final String OU = "OU";
    public static final String O = "O";

    public CertificateDlg(JFrame frame, X509Certificate cert, ImageIcon icon) {
        super(frame, MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.titleWarningSecurity"), true);
        this.frame = frame;
        this.icon = icon;
        this.cert = cert;
        this.message = MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.msgPartnerCertificateCannotVerified");
        this.initialize(false);
        CertificateDlg.centerDlg(this);
        this.setVisible(true);
    }

    public CertificateDlg(JFrame frame, X509Certificate cert, ImageIcon icon, String dlgMessage) {
        super(frame, MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.titleWarningSecurity"), true);
        this.frame = frame;
        this.icon = icon;
        this.cert = cert;
        this.message = dlgMessage;
    }

    public CertificateDlg(JFrame frame) {
        super(frame, MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.titleWarningSecurity"), true);
        this.frame = frame;
        this.cert = this.getCertificates();
        this.message = MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.msgSiteCertificateDetails");
        this.continueMsg = "";
        this.initialize(true);
        CertificateDlg.centerDlg(this);
        this.setVisible(true);
    }

    private static void centerDlg(Window dlg) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dlg.getSize();
        if (dlgSize.height > screenSize.height) {
            dlgSize.height = screenSize.height;
        }
        if (dlgSize.width > screenSize.width) {
            dlgSize.width = screenSize.width;
        }
        dlg.setLocation((screenSize.width - dlgSize.width) / 2, (screenSize.height - dlgSize.height) / 2);
    }

    public void initialize() {
        this.initialize(false);
        CertificateDlg.centerDlg(this);
        this.setVisible(true);
    }

    private void initialize(boolean addOk) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getTitlePanel(), "North");
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(addOk), "South");
        Dimension preferredSize = this.getContentPane().getPreferredSize();
        preferredSize.setSize(preferredSize.getWidth() * 1.2, preferredSize.getHeight() * 1.2);
        this.getContentPane().setPreferredSize(preferredSize);
        this.pack();
    }

    private String ReadStorePasswd() {
        String retStr = "";
        try {
            XmlParser parser = new XmlParser();
            parser.readXmlFile(STORE_PASSWD_FILE);
            Document document = parser.getDocument();
            Element serverElement = document.getDocumentElement();
            Element serviceElement = XmlParser.getFirstChildElement(serverElement, "Service");
            NodeList connectorList = serviceElement.getElementsByTagName("Connector");
            for (int i = 0; i < connectorList.getLength(); ++i) {
                Element connectorElement = (Element)connectorList.item(i);
                if (!"https".equalsIgnoreCase(connectorElement.getAttribute("scheme")) || !"true".equalsIgnoreCase(connectorElement.getAttribute("SSLEnabled"))) continue;
                retStr = connectorElement.getAttribute("keystorePass");
                break;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            System.out.println("Unable to read the Storepasswd from file: " + STORE_PASSWD_FILE);
        }
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate getCertificates() {
        X509Certificate storecert = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            this.storePasswd = this.ReadStorePasswd().toCharArray();
            System.out.println(this.storePasswd);
            System.out.println();
            System.out.println("Searching in keystore for the issuer's certificate ...");
            char[] pswd = this.storePasswd;
            KeyStore keystore = KeyStore.getInstance("JKS");
            fis = new FileInputStream(KEYSTORE);
            bis = new BufferedInputStream(fis);
            keystore.load(bis, pswd);
            Enumeration<String> en = keystore.aliases();
            while (en.hasMoreElements()) {
                String ali = en.nextElement();
                storecert = (X509Certificate)keystore.getCertificate(ali);
                if (storecert == null) {
                    System.out.println("Couldn't find the Server certificate in the Store: ");
                    continue;
                }
                System.out.println("Found the Server certificate in the Store: ");
                break;
            }
            IOUtilities.closeInputStream(bis);
        }
        catch (Exception ex) {
            System.err.println("Caught exception " + ex.toString());
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(fis);
        }
        IOUtilities.closeInputStream(fis);
        return storecert;
    }

    private JPanel getTitlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myLabel(this.message), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(this.continueMsg), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(this.icon);
        imageLabel.setBounds(new Rectangle(10, 10, 175, 305));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)imageLabel, "East");
        titlePanel.add((Component)panel, "West");
        titlePanel.add((Component)new JSeparator(), "South");
        return titlePanel;
    }

    protected JLabel myLabel(String title) {
        JLabel lbl = new JLabel(title);
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> lbl.setFont(UIFontUtilities.SUBTITLE_FONT));
        return lbl;
    }

    private JPanel getCenterPanel() {
        this.jBMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                CertificateDlg.this.more();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbCertificateInfo")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbVersion")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("" + this.cert.getVersion()), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbSubject")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getName(this.cert.getSubjectX500Principal(), panel), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbIssuer")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getName(this.cert.getIssuerX500Principal(), panel), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbSerialNo")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        BigInteger serialNumber = this.cert.getSerialNumber();
        panel.add((Component)new JLabel(serialNumber == null ? "" : serialNumber.toString()), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbValidFrom")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        DateFormat df = DateFormat.getDateInstance(0);
        df.setTimeZone(Utility.getLocalTimeZone());
        Date notBeforeDate = this.cert.getNotBefore();
        panel.add((Component)new JLabel(notBeforeDate == null ? "" : df.format(notBeforeDate)), new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbValidTo")), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        Date notAfterDate = this.cert.getNotAfter();
        panel.add((Component)new JLabel(notAfterDate == null ? "" : df.format(notAfterDate)), new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbSignatureAlg")), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(this.cert.getSigAlgName()), new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.myLabel(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.lbPublicKeyAlg")), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(this.cert.getPublicKey().getAlgorithm()), new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        int nextRow = 12;
        if (this.addFingerprint(panel, nextRow)) {
            ++nextRow;
        }
        if (this.addAlternateNames(panel, nextRow)) {
            nextRow += 2;
        }
        panel.add((Component)this.jBMore, new GridBagConstraints(3, nextRow++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(0, nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    static void getNameEx(X500Principal principal, String[] components) {
        try {
            LdapName ln = new LdapName(principal.getName());
            for (Rdn rdn : ln.getRdns()) {
                if (rdn.getType().equalsIgnoreCase(CN)) {
                    components[0] = "CN=" + rdn.getValue();
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase(OU)) {
                    components[1] = "OU=" + rdn.getValue();
                    continue;
                }
                if (!rdn.getType().equalsIgnoreCase(O)) continue;
                components[2] = "O=" + rdn.getValue();
            }
        }
        catch (Exception ex) {
            components[0] = "CN=Unknown";
            components[1] = "OU=Unknown";
            components[2] = "O=Unknown";
        }
    }

    static String[] getComponentNames(X500Principal principal) {
        String[] components = new String[3];
        try {
            Map<String, String> nameMap = Arrays.stream(principal.getName("RFC1779").split(",")).map(String::trim).map(keypair -> keypair.split("=")).collect(Collectors.toMap(kp -> kp[0], kp -> kp[1]));
            components[0] = "CN=" + Optional.ofNullable(nameMap.get(CN)).orElse("");
            components[1] = "OU=" + Optional.ofNullable(nameMap.get(OU)).orElse("");
            components[2] = "O=" + Optional.ofNullable(nameMap.get(O)).orElse("");
        }
        catch (Exception ex) {
            components[0] = "CN=";
            components[1] = "OU=";
            components[2] = "O=";
            CertificateDlg.getNameEx(principal, components);
        }
        return components;
    }

    private JScrollPane getName(X500Principal principal, JPanel panel) {
        String[] components = CertificateDlg.getComponentNames(principal);
        JList<String> list = new JList<String>(components);
        list.setVisibleRowCount(3);
        list.setBackground(panel.getBackground());
        list.setForeground(panel.getForeground());
        list.setSelectionBackground(panel.getBackground());
        list.setSelectionForeground(panel.getForeground());
        return new JScrollPane(list);
    }

    protected boolean addAlternateNames(JPanel panel, int nextRow) {
        return false;
    }

    protected boolean addFingerprint(JPanel panel, int nextRow) {
        return false;
    }

    protected JPanel getButtonPanel(boolean addOk) {
        if (addOk) {
            this.jBOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDlg.this.ok();
                }
            });
        } else {
            this.jBYes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDlg.this.yes();
                }
            });
            this.jBNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDlg.this.no();
                }
            });
        }
        JPanel panel = new JPanel();
        if (addOk) {
            CertificateDlg.layoutButtonPanel(panel, new JButton[]{this.jBOK}, 0, 0, true);
            UiUtilities.setDefaultButton(this, this.jBOK);
            this.jBOK.setFocusable(true);
        } else {
            CertificateDlg.layoutButtonPanel(panel, new JButton[]{this.jBYes, this.jBNo}, 0, 0, true);
            UiUtilities.setDefaultButton(this, this.jBYes);
            this.jBYes.setFocusable(true);
        }
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JSeparator(), "North");
        bottomPanel.add((Component)panel, "Center");
        return bottomPanel;
    }

    private static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons, boolean hasBorder, int strutSize) {
        if (isFitButtons) {
            CertificateDlg.fitJComponent(jButtons);
        }
        jButtonPanel.setOpaque(false);
        jButtonPanel.setLayout(new BoxLayout(jButtonPanel, directory));
        if (hasBorder) {
            jButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        if (directory == 0 && alignment != 2 || directory == 1 && alignment != 1) {
            jButtonPanel.add(Box.createGlue());
        }
        for (int i = 0; i < jButtons.length; ++i) {
            if (i != 0) {
                Component strut = directory == 0 ? Box.createHorizontalStrut(strutSize) : Box.createVerticalStrut(strutSize);
                jButtonPanel.add(strut);
            }
            jButtonPanel.add(jButtons[i]);
        }
        if (directory == 0 && alignment != 4 || directory == 1 && alignment != 3) {
            jButtonPanel.add(Box.createGlue());
        }
    }

    public static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons) {
        CertificateDlg.layoutButtonPanel(jButtonPanel, jButtons, directory, alignment, isFitButtons, true, 3);
    }

    private static void fitJComponent(JComponent[] components) {
        int i;
        int width = 0;
        int height = 0;
        for (i = 0; i < components.length; ++i) {
            Dimension d = components[i].getPreferredSize();
            width = (int)Math.max(d.getWidth(), (double)width);
            height = (int)Math.max(d.getHeight(), (double)height);
        }
        for (i = 0; i < components.length; ++i) {
            components[i].setPreferredSize(new Dimension(width, height));
            components[i].setMaximumSize(new Dimension(width, height));
        }
    }

    private boolean yes() {
        if (!this.isValidate()) {
            return false;
        }
        this.commit();
        this.isOk = true;
        this.dispose();
        return true;
    }

    private void commit() {
    }

    private boolean isValidate() {
        return true;
    }

    private void no() {
        this.isOk = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.isOk;
    }

    private void ok() {
        this.dispose();
        CertificateDlg.exitSystem(0);
    }

    public String toHex(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int j;
            if (i % 16 == 0) {
                buf.append(Integer.toHexString(i & 0xFFFF | 0x10000).substring(1, 5) + " - ");
            }
            buf.append(Integer.toHexString(b[i] & 0xFF | 0x100).substring(1, 3) + " ");
            if (i % 16 != 15 && i != b.length - 1) continue;
            for (j = 16 - i % 16; j > 1; --j) {
                buf.append("   ");
            }
            buf.append(" - ");
            int start = i / 16 * 16;
            int end = b.length < i + 1 ? b.length : i + 1;
            for (j = start; j < end; ++j) {
                if (b[j] >= 32 && b[j] <= 126) {
                    buf.append((char)b[j]);
                    continue;
                }
                buf.append(".");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private void more() {
        try {
            System.out.println(this.cert.toString());
            byte[] signature = this.cert.getSignature();
            String txt = signature == null ? "" : this.toHex(signature);
            JTextArea txtarea = new JTextArea(txt);
            JOptionPane.showMessageDialog(this.frame, txtarea, MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "CertificateDlg.titleCertificateSignature"), 1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static void exitSystem(int exitCode) {
        System.exit(exitCode);
    }
}

