/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.ui;

import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HttpCertUtil;
import com.sygate.scm.util.Base64Util;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.webswing.toolkit.api.WebswingUtil;

public class AjaxSwingCommonUtil {
    public static final String SCM_WEBSWING_FEATURE_ENABLED = "scm.webswing.feature.enabled";
    private static final boolean IS_AJAXSWING_RUNNING = com.creamtec.ajaxswing.AjaxSwingManager.isAjaxSwingRunning();

    protected static void internalUpdateSwingAgentBrowser(boolean update) {
        ClientAgent.getCurrentInstance().setUpdateBrowser(update);
    }

    protected static void internalUpdateSwingAgentBrowserInterval(int interval) {
        ClientAgent.getCurrentInstance().setUpdateBrowserInterval(interval);
    }

    public static boolean isAjaxSwingRunning() {
        return IS_AJAXSWING_RUNNING || AjaxSwingCommonUtil.isWebswingRunning();
    }

    public static void updateSwingAgentBrowser(boolean update) {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            AjaxSwingCommonUtil.internalUpdateSwingAgentBrowser(update);
        }
    }

    public static void updateSwingAgentBrowser(boolean update, int interval) {
        AjaxSwingCommonUtil.updateSwingAgentBrowser(update);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            AjaxSwingCommonUtil.internalUpdateSwingAgentBrowserInterval(interval);
        }
    }

    public static void executeIfWebConsoleIsRunning(Runnable work) {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            work.run();
        }
    }

    public static void executeIfWebConsoleIsNotRunning(Runnable work) {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            work.run();
        }
    }

    public static void executeOneBasedOnWebConsoleRunning(Runnable workIfRunning, Runnable workIfNotRunning) {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            workIfRunning.run();
        } else {
            workIfNotRunning.run();
        }
    }

    protected static void internalExecuteIfAll(Runnable work, Boolean ... conditions) {
        if (Arrays.stream(conditions).allMatch(Boolean::booleanValue)) {
            work.run();
        }
    }

    protected static void internalExecuteIfAny(Runnable work, Boolean ... conditions) {
        if (Arrays.stream(conditions).anyMatch(Boolean::booleanValue)) {
            work.run();
        }
    }

    protected static <T> T[] extendByOne(T[] original, T value) {
        T[] newarray = Arrays.copyOf(original, original.length + 1);
        newarray[newarray.length - 1] = value;
        return newarray;
    }

    public static void executeIfInWebConsoleAndAll(Runnable work, Boolean ... conditions) {
        Boolean[] allConditions = AjaxSwingCommonUtil.extendByOne(conditions, AjaxSwingCommonUtil.isAjaxSwingRunning());
        AjaxSwingCommonUtil.internalExecuteIfAll(work, allConditions);
    }

    public static void executeIfNotInWebConsoleAndAll(Runnable work, Boolean ... conditions) {
        Boolean[] allConditions = AjaxSwingCommonUtil.extendByOne(conditions, !AjaxSwingCommonUtil.isAjaxSwingRunning());
        AjaxSwingCommonUtil.internalExecuteIfAll(work, allConditions);
    }

    public static void executeIfInWebConsoleOrAny(Runnable work, Boolean ... conditions) {
        Boolean[] allConditions = AjaxSwingCommonUtil.extendByOne(conditions, AjaxSwingCommonUtil.isAjaxSwingRunning());
        AjaxSwingCommonUtil.internalExecuteIfAny(work, allConditions);
    }

    public static void executeIfNotInWebConsoleOrAny(Runnable work, Boolean ... conditions) {
        Boolean[] allConditions = AjaxSwingCommonUtil.extendByOne(conditions, !AjaxSwingCommonUtil.isAjaxSwingRunning());
        AjaxSwingCommonUtil.internalExecuteIfAny(work, allConditions);
    }

    public static void beginOperation() {
        AjaxSwingManager.beginOperation();
    }

    public static void endOperation() {
        AjaxSwingManager.endOperation();
    }

    public static void endOperation(boolean endAfterNextModalDialog) {
        AjaxSwingManager.endOperation(endAfterNextModalDialog);
    }

    public static boolean isWebswingRunning() {
        String webswingFeatureEnabled = System.getProperty(SCM_WEBSWING_FEATURE_ENABLED, "false");
        if (!Boolean.parseBoolean(webswingFeatureEnabled)) {
            return false;
        }
        return WebswingUtil.isWebswing();
    }

    public static List<X509Certificate> getCertificatesFromHttpRequest() {
        return ClientAgent.getCurrentInstance().getRequestData().map(d -> (HttpServletRequest)d.getHttpRequest()).map(HttpCertUtil::getCertificatesFromHttpConnection).or(() -> AjaxSwingCommonUtil.getWebswingUserAttr("x509_certs").map(attr -> (List)((Object)attr)).map(attr -> attr.stream().map(AjaxSwingCommonUtil::certFromString).flatMap(Optional::stream).collect(Collectors.toList()))).orElseGet(List::of);
    }

    public static Optional<X509Certificate> certFromString(String data) {
        return Optional.ofNullable(data).map(Base64Util::decode).flatMap(HttpCertUtil::toX509Certificates);
    }

    public static Optional<Serializable> getWebswingUserAttr(String attr) {
        return Optional.ofNullable(WebswingUtil.getWebswingApi()).map(api -> api.getPrimaryUser()).map(primaryUser -> primaryUser.getUserAttributes()).map(userAttrs -> (Serializable)userAttrs.get(attr));
    }

    public static void logoutWebConsole() {
        Optional.ofNullable(WebswingUtil.getWebswingApi()).ifPresent(api -> api.notifyShutdown(1000));
    }
}

