/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.statping;

import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum PingType {
    ADMIN_INFO(18110, "<Admin Information>"),
    CLIENT_INFO(18703, "<Clients Information>"),
    CLIENT_OS_INFO(18108, "<Client OS Information>"),
    CLIENT_GROUP_INFO(18702, "<Group Information>"),
    SHARED_POLICY_INFO(18704, "<Shared Policy Information>"),
    REPLICATION_INFO(18102, "<Replication Information>"),
    REPLICATION_FAILURE_EVENTS(18103, "<Replication Failure Events>", false, (PingSubModule[])ReplicationFailureEvent.values()),
    LOCATION_CONFIG(18101, "<Location Configuration>"),
    PROTECTION_TECHNOLOGY(18113, "<Protection Technology>"),
    LU_CONFIG(18105, "<LU Configuration>"),
    SVA_INFO(18707, "<SVA Information>"),
    POLICY_LU_CONTENT_NAMEDVERSION(18401, "<LU Content Policy>"),
    POLICY_AV_AS_CONFIG(18402, "<AV/AS Policy>", AVPolicyConfig.values()),
    POLICY_FW_CONFIG(18403, "<FW Policy>"),
    POLICY_SSL_CONFIG(18450, "<Server SSL Configuration>", CLIENT_INFO),
    NOTIFICATION_CONDITION_INFO(18502, "<Notification conditions Information>"),
    BACKGROUND_TASK_INFO(18302, "<Background Task Information>", Task.values()),
    MEMORY_USAGE(18301, "<Memory Usage>"),
    LOCATION_SWITCH_CRITERIA(18111, "<Location Switch Criteria>", LocationSwitchCriteria.values()),
    APACHE_BW_CONFIG(18151, "<Apache Bandwidth Config>", ApacheBwConfigType.values()),
    WEB_SERVICE_RMM_USAGE(18601, "<RMM Web Services Usage>", false, (PingSubModule[])WebServiceCall.values()),
    WEB_SERVICE_SMR_COMMAND(18602, "<SMR Web Service Command>", false, new PingSubModule[0]),
    WEB_SERVICE_EOC_SIZE(18603, "<EOC Web Service Payload Size>", false, new PingSubModule[0]),
    REPORTS_PROCESS_TIME(18501, "<Reports Information>", false, new PingSubModule[0]),
    CONSOLE_LOGIN_INFO(18706, "<Console Login Information>", false, new PingSubModule[0]),
    CONSOLE_LDAP_IMPORT(18705, "<Console LDAP Import Information>", false, new PingSubModule[0]),
    CONSOLE_POLICY_USAGE(18701, "<Console Policy Usage>", false, new PingSubModule[0]),
    CONSOLE_CLIENT_SEARCH_CRITERIA(18708, "<Console client search Criteria>", false, new PingSubModule[0]),
    DATABASE_LOG_SETTINGS(18106, "<Database Log Settings>", true, (PingSubModule[])DatabaseLogSettings.values()),
    AGENT_COMMAND_INFORMATION(18709, "<Agent Command Information>", false, new PingSubModule[0]),
    SEPM_TOOL_USAGE(18800, "<Sepm Tool Usage>", false, DefaultSubModule.DEFAULT),
    USER_INITIATED_SCAN_INFORMATION(18107, "<No. of User Initiated Scans Information>"),
    CLIENT_PROPERTY_STATISTICS(18109, "<Client Property Statistics>", ClientPropertyStatistics.values()),
    CLIENT_PROPERTY_HARDWARE_STATISTICS(18112, "<Client Property Hardware Statistics>", ClientPropertyHardwareStatistics.values()),
    FULL_CONTENT_DOWNLOAD_STATISTICS(18710, "<Full content download statistics>", true, (PingSubModule[])FullContentEvent.values()),
    CACHE_LICENSING_STATISTICS_1(18712, "<Cache_Licensing_1>", false, (PingSubModule[])CachePingModules.values()),
    CACHE_LICENSING_STATISTICS_2(18713, "<Cache_Licensing_2>", false, (PingSubModule[])CachePingModules.values()),
    CACHE_FEATURE_STATISTICS_1(18714, "<Cache_Feature_1>", false, (PingSubModule[])CachePingModules.values()),
    CACHE_FEATURE_STATISTICS_2(18715, "<Cache_Feature_2>", false, (PingSubModule[])CachePingModules.values());

    private final int typeId;
    private final String description;
    private final List<PingSubModule> subModules = new ArrayList<PingSubModule>();
    private final boolean isLocalPing;
    private final PingType dependency;

    public static PingType getInstance(int moduleId) {
        for (PingType type : PingType.values()) {
            if (type.getTypeId() != moduleId) continue;
            return type;
        }
        return null;
    }

    public static List<PingType> getAllLocalPings() {
        ArrayList<PingType> result = new ArrayList<PingType>();
        for (PingType type : PingType.values()) {
            if (!type.isLocalPing) continue;
            result.add(type);
        }
        return result;
    }

    public static Set<PingType> getPingTypesForSNACOnly() {
        HashSet<PingType> sepOnly = new HashSet<PingType>();
        sepOnly.add(POLICY_AV_AS_CONFIG);
        sepOnly.add(POLICY_FW_CONFIG);
        sepOnly.add(POLICY_LU_CONTENT_NAMEDVERSION);
        HashSet<PingType> result = new HashSet<PingType>();
        for (PingType type : PingType.values()) {
            if (sepOnly.contains((Object)type)) continue;
            result.add(type);
        }
        return result;
    }

    private PingType(int typeId, String description) {
        this(typeId, description, true, new PingSubModule[0]);
    }

    private PingType(int typeId, String description, PingType dependency) {
        this(typeId, description, true, dependency, (PingSubModule[])null);
    }

    private PingType(int typeId, String description, PingSubModule ... subModules) {
        this(typeId, description, true, subModules);
    }

    private PingType(int typeId, String description, boolean isLocalPing, PingSubModule ... subModules) {
        this(typeId, description, isLocalPing, (PingType)null, subModules);
    }

    private PingType(int typeId, String description, boolean isLocalPing, PingType dependency, PingSubModule ... subModules) {
        this.typeId = typeId;
        this.description = description;
        this.isLocalPing = isLocalPing;
        this.dependency = dependency;
        this.initSubModule(subModules);
    }

    private void initSubModule(PingSubModule ... subModules) {
        if (subModules != null) {
            for (PingSubModule subModule : subModules) {
                this.subModules.add(subModule);
            }
        } else {
            this.subModules.add(DefaultSubModule.DEFAULT);
        }
        if (this.typeId == 18102) {
            this.subModules.add(DefaultSubModule.DEFAULT);
        }
    }

    public PingType dependOn() {
        return this.dependency;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Integer> getSubModuleIds() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (PingSubModule subModule : this.subModules) {
            if (subModule == null) continue;
            result.add(subModule.getId());
        }
        return result;
    }

    public boolean contains(int subModuleId) {
        return this.getSubModuleIds().contains(subModuleId);
    }

    public static enum FullContentEvent implements PingSubModule
    {
        UNKNOWN(0),
        AV(1),
        AV_R(2),
        SRTSP(3),
        SMR_DEFINITIONS(4),
        DECOMPOSER(5),
        PTS_ENGINE(6),
        PTS_CONTENT(7),
        BASH(8),
        KNOWN_APPLICATION(9),
        SYMC_SECURITY_CONTENT_A1(10),
        SYMC_SECURITY_CONTENT_B1(11),
        IPS_SIG(12),
        CIDS_SIG(13),
        IRON_WHILELIST(14),
        IRON_REVOKATION(15),
        IRON_SETTINGS(16),
        SUBMISSION_CONTROL(17),
        EFAVT(18);

        private int id;

        private FullContentEvent(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum ClientProtectionTechnologyPolicyConfig implements PingSubModule
    {
        AV_ENABLED(0),
        AV_MALWARE_ACTIONS(1),
        AV_VIRUS_ACTIONS(2),
        AV_SECURITY_RISK_ACTIONS(3),
        DOWNLOAD_ADVISOR_ENABLED(4),
        DOWNLOAD_ADVISOR_ACTIONS(5),
        DOWNLOAD_ADVISOR_UNPROVEN_FILE_ACTIONS(6),
        SONAR_ENABLED(7),
        SONAR_RISK_DETECTION_ACTIONS(8),
        SONAR_DNS_CHANGE_ACTIONS(9),
        SONAR_HOST_FILE_CHANGE_ACTION(10),
        SONAR_SUSPICIOUS_BEHAVIOR_RISK_ACTIONS(11),
        EARLY_LAUNCH_ANTI_MALWARE_DRIVE_ENABLED(12),
        EARLY_LAUNCH_ANTI_MALWARE_DETECTION_SETTINGS(13);

        private int id;

        private ClientProtectionTechnologyPolicyConfig(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum ClientPropertyHardwareStatistics implements PingSubModule
    {
        EmbeddedWin8AndWin81Clients(0),
        EmbeddedWin7Clients(1),
        EmbeddedXPAnd2009Clients(2),
        AllClients(3);

        private int id;

        private ClientPropertyHardwareStatistics(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum ClientPropertyStatistics implements PingSubModule
    {
        EmbeddedWin8AndWin81Clients(0),
        EmbeddedWin7Clients(1),
        EmbeddedXPAnd2009Clients(2),
        AllClients(3);

        private int id;

        private ClientPropertyStatistics(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum AVPolicyConfig implements PingSubModule
    {
        GLOBAL_SCAN_OPTIONS(1),
        DOWNLOAD_PROTECTION(2),
        AUTO_PROTECT(3);

        private int id;

        private AVPolicyConfig(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum ReplicationFailureEvent implements PingSubModule
    {
        REPLICATION_LOGIN_FAILED(770),
        REPLICATION_DATA_FETCH_FAILED(771),
        REPLICATION_FAILED(773),
        REPLICATION_MERGE_FAILED(774),
        REPLICATION_SERVER_REACH_FAILED(775),
        REPLICATION_GROUP_FULLPATH_TOO_LONG_FAILED(777),
        REPLICATION_RETRIEVE_CHANGEDDATA_FOR_REMOTE_FAILED(780),
        REPLICATION_KILLED_BY_DB(781),
        REPLICATION_DB_VERSION_NO_MATCH(783),
        REPLICATION_REMOTE_SERVER_NOT_EE(787),
        REPLICATION_PARTNER_SCHEMA_MISMATCH(789);

        private int id;

        private ReplicationFailureEvent(int value) {
            this.id = value;
        }

        public static boolean contains(int eventId) {
            for (ReplicationFailureEvent event : ReplicationFailureEvent.values()) {
                if (event.getId() != eventId) continue;
                return true;
            }
            return false;
        }

        public static String getSQLCondition() {
            StringBuilder builder = new StringBuilder(" (");
            for (ReplicationFailureEvent event : ReplicationFailureEvent.values()) {
                builder.append(event.getId());
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(") ");
            return builder.toString();
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum ApacheBwConfigType implements PingSubModule
    {
        BANDWIDTH_MODULE(0),
        MODULE_CONFIG(1);

        private int id;

        private ApacheBwConfigType(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum WebServiceCall implements PingSubModule
    {
        CLIENT_SERVICE_getComputersByHostName(101),
        CLIENT_SERVICE_getComputersByIP(102),
        CLIENT_SERVICE_getGroupsByName(103),
        COMMAND_SERVICE_getCommandStatusDetails(201),
        COMMAND_SERVICE_runClientCommandDisableDownloadInsight(202),
        COMMAND_SERVICE_runClientCommandDisableNTP(203),
        COMMAND_SERVICE_runClientCommandEnableAP(204),
        COMMAND_SERVICE_runClientCommandEnableDownloadInsight(205),
        COMMAND_SERVICE_runClientCommandEnableNTP(206),
        COMMAND_SERVICE_runClientCommandScan(207),
        COMMAND_SERVICE_runClientCommandUpdateContent(208),
        COMMAND_SERVICE_runClientCommandUpdateContentAndScan(209),
        COMMAND_SERVICE_runClientCommandPowerEraser(210),
        COMMAND_SERVICE_runClientCommandEvidenceOfCompromiser(211),
        LICENSE_SERVICE_getLicenseSummaryInfo(301),
        LIVEUPDATE_SERVICE_getLiveUpdateContentVersion(401),
        LIVEUPDATE_SERVICE_runLiveUpdate(402),
        POLICY_SERVICE_assignPolicy(501),
        POLICY_SERVICE_getPolicySummaryInfo(502),
        POLICY_SERVICE_importPolicy(503);

        private int id;

        public static WebServiceCall getInstance(String name) {
            if (StringUtilities.isEmpty(name)) {
                return null;
            }
            for (WebServiceCall call : WebServiceCall.values()) {
                if (!call.name().toUpperCase().endsWith(name.trim().toUpperCase())) continue;
                return call;
            }
            return null;
        }

        private WebServiceCall(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum LocationSwitchCriteria implements PingSubModule
    {
        GatewayAddress(0),
        DHCPServerAddress(1),
        LocalHostAddress(2),
        WINSServerAddress(3),
        DNSServerAddress(4),
        CMSConnection(5),
        NetworkConnection(6),
        ALHostIntegrity(7),
        TPMDevice(8),
        DNSResolve(9),
        ALRegistry(10),
        WirelessSSID(11),
        NICDescription(12),
        DomainName(13),
        RemoteDeviceCommunication(14),
        ICMPReqeust(15),
        LocalHostName(16),
        UserName(17),
        FileExists(18),
        OSVersion(19);

        private int id;

        private LocationSwitchCriteria(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum DatabaseLogSettings implements PingSubModule
    {
        ServerLogSettings(0),
        ClientLogSettings(1),
        RiskLogSettings(2);

        private int id;

        private DatabaseLogSettings(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum Task implements PingSubModule
    {
        AgentInfoTask(0),
        AgentSweepingTask(1),
        ApplicationCollector(2),
        DeltaContentTask(3),
        DeltaPackageTask(4),
        IISCacheTask(5),
        LiveUpdateTask(6),
        PackagePublisherTask(7),
        ReplicationTask(8);

        private int id;

        private Task(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum CachePingModules implements PingSubModule
    {
        LICENSE_DATA_1(0),
        LICENSE_DATA_2(0),
        FEATURE_DATA_1(1),
        FEATURE_DATA_2(1);

        private int id;

        private CachePingModules(int value) {
            this.id = value;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    private static enum DefaultSubModule implements PingSubModule
    {
        DEFAULT(0);

        int id;

        private DefaultSubModule(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    private static interface PingSubModule {
        public int getId();
    }
}

