/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.statping;

import com.sygate.scm.common.statping.CommonPingLogger;
import com.sygate.scm.common.statping.CountablePingData;
import com.sygate.scm.common.statping.DefaultPingLogger;
import com.sygate.scm.common.statping.PingDataHelper;
import com.sygate.scm.common.statping.PingType;
import com.sygate.scm.common.valueobject.ValueObject;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PingData
extends ValueObject {
    private static final long serialVersionUID = 4064235134926738380L;
    private static final String PARAM_MODULE = "module";
    private static final String PARAM_SUBMODULE = "error";
    private static CommonPingLogger logger = DefaultPingLogger.newInstance();
    private static int submissionThreshold = 0;
    private final PingType pingType;
    protected final Map<Integer, List<Map<String, Object>>> dataSetMap = new ConcurrentHashMap<Integer, List<Map<String, Object>>>();
    protected transient Map<String, Object> currentMap;

    protected PingData(PingType type) {
        if (type == null) {
            throw new IllegalArgumentException("PingData::contructor - The parameter PingType cannot be null! ");
        }
        this.pingType = type;
    }

    public static PingData newInstance(PingType type) {
        return new PingData(type);
    }

    public static PingData newCountableInstance(PingType type) {
        return new CountablePingData(type);
    }

    public static void setSubmissionThreshold(int submissionThreshold) {
        if (submissionThreshold > 0) {
            PingData.submissionThreshold = submissionThreshold;
        }
    }

    public List<String> toUrl() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : this.dataSetMap.entrySet()) {
            if (entry == null) continue;
            for (Map<String, Object> parameters : entry.getValue()) {
                StringBuilder builder = new StringBuilder();
                builder.append(PARAM_MODULE);
                builder.append("=");
                builder.append(this.getModuleId());
                builder.append("&");
                builder.append(PARAM_SUBMODULE);
                builder.append("=");
                builder.append(entry.getKey());
                for (Map.Entry<String, Object> entrySet : parameters.entrySet()) {
                    if (entrySet.getKey() == null) continue;
                    builder.append("&");
                    builder.append(entrySet.getKey().trim());
                    builder.append("=");
                    String s = entrySet.getValue().toString();
                    s = Utility.encodeStringForURL(s, false);
                    builder.append(s);
                }
                result.add(builder.toString());
            }
        }
        return result;
    }

    public String getTypeString() {
        return this.getPingType().getDescription();
    }

    public PingType getPingType() {
        return this.pingType;
    }

    public int getModuleId() {
        return this.getPingType().getTypeId();
    }

    public List<Integer> getSubModuleId() {
        return this.getPingType().getSubModuleIds();
    }

    public void newPingRequest() {
        this.newPingRequest(0);
    }

    public void newPingRequest(int subModuleId) {
        if (this.dataSetMap.get(subModuleId) == null) {
            this.dataSetMap.put(subModuleId, new CopyOnWriteArrayList());
        }
        List<Map<String, Object>> dataSet = this.dataSetMap.get(subModuleId);
        this.currentMap = new ConcurrentSkipListMap<String, Object>();
        if (this.isPingDataFull()) {
            logger.logFineMessage("The threshold of the ping data has reached: " + submissionThreshold);
            logger.logFineMessage("All following ping data will be dropped! ");
            return;
        }
        dataSet.add(this.currentMap);
    }

    public void clear() {
        if (this.currentMap != null) {
            this.currentMap.clear();
        }
        this.dataSetMap.clear();
    }

    public void putAll(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entrySet : map.entrySet()) {
            this.put(entrySet.getKey(), entrySet.getValue());
        }
    }

    public void put(String key, Object value) {
        if (StringUtilities.isEmpty(key)) {
            return;
        }
        if (this.currentMap == null) {
            throw new RuntimeException("PingData::put - Please call newPingRequest() first! ");
        }
        Object revisedValue = value;
        if (value == null) {
            revisedValue = -1;
        }
        if (value instanceof Boolean) {
            revisedValue = PingDataHelper.toInt((Boolean)value);
        }
        this.currentMap.put(key, revisedValue);
    }

    public void remove(String key) {
        if (StringUtilities.isEmpty(key)) {
            return;
        }
        if (this.currentMap == null) {
            throw new RuntimeException("PingData::remove - Please call newPingRequest() first! ");
        }
        this.currentMap.remove(key);
    }

    public boolean isEmpty() {
        if (this.dataSetMap.isEmpty()) {
            return true;
        }
        Set<Map.Entry<Integer, List<Map<String, Object>>>> entrySet = this.dataSetMap.entrySet();
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : entrySet) {
            for (Map<String, Object> p : this.dataSetMap.get(entry.getKey())) {
                if (p.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<Integer, List<Map<String, Object>>> getDataSetMap() {
        HashMap<Integer, List<Map<String, Object>>> result = new HashMap<Integer, List<Map<String, Object>>>();
        Set<Map.Entry<Integer, List<Map<String, Object>>>> entrySet = this.dataSetMap.entrySet();
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : entrySet) {
            LinkedList subModuleList = new LinkedList();
            result.put(entry.getKey(), subModuleList);
            for (Map<String, Object> p : this.dataSetMap.get(entry.getKey())) {
                TreeMap<String, Object> newP = new TreeMap<String, Object>();
                subModuleList.add(newP);
                for (Map.Entry<String, Object> entrySet2 : p.entrySet()) {
                    newP.put(entrySet2.getKey(), entrySet2.getValue());
                }
            }
        }
        return result;
    }

    public void merge(PingData that) {
        if (that == null || !this.getPingType().equals((Object)that.getPingType())) {
            return;
        }
        for (Integer subModuleId : that.getDataSetMap().keySet()) {
            List<Map<String, Object>> l = this.dataSetMap.get(subModuleId);
            if (l == null) {
                l = new CopyOnWriteArrayList<Map<String, Object>>();
                this.dataSetMap.put(subModuleId, l);
            }
            l.addAll((Collection<Map<String, Object>>)that.getDataSetMap().get(subModuleId));
        }
    }

    void removeSubModule(int subModuleId) {
        if (!this.getSubModuleId().contains(subModuleId)) {
            return;
        }
        this.dataSetMap.remove(subModuleId);
    }

    int size() {
        int result = 0;
        for (List<Map<String, Object>> pings : this.dataSetMap.values()) {
            result += pings.size();
        }
        return result;
    }

    private boolean isPingDataFull() {
        return submissionThreshold > 0 && submissionThreshold <= this.size();
    }
}

