/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.statping;

import com.sygate.scm.common.statping.PingData;
import com.sygate.scm.common.statping.PingType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;

class CountablePingData
extends PingData {
    private static final long serialVersionUID = -6610696279094755162L;

    CountablePingData(PingType type) {
        super(type);
    }

    @Override
    public void newPingRequest(int subModuleId) {
        if (this.dataSetMap.get(subModuleId) == null) {
            ConcurrentSkipListMap theOnlyMap = new ConcurrentSkipListMap();
            CopyOnWriteArrayList dataSet = new CopyOnWriteArrayList();
            dataSet.add(theOnlyMap);
            this.dataSetMap.put(subModuleId, dataSet);
        }
        this.currentMap = (Map)((List)this.dataSetMap.get(subModuleId)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(PingData that) {
        if (that == null || that.isEmpty()) {
            return;
        }
        CountablePingData countablePingData = this;
        synchronized (countablePingData) {
            for (Map.Entry<Integer, List<Map<String, Object>>> dataSetMapEntry : that.getDataSetMap().entrySet()) {
                this.newPingRequest(dataSetMapEntry.getKey());
                for (Map<String, Object> thatMap : dataSetMapEntry.getValue()) {
                    for (Map.Entry<String, Object> thatMapEntry : thatMap.entrySet()) {
                        Object thisValue = this.currentMap.get(thatMapEntry.getKey());
                        Object thatValue = thatMapEntry.getValue();
                        if (thatValue == null) continue;
                        if (thisValue == null) {
                            this.currentMap.put(thatMapEntry.getKey(), thatValue);
                            continue;
                        }
                        this.currentMap.put(thatMapEntry.getKey(), this.mergeCounter(thisValue, thatValue));
                    }
                }
            }
        }
    }

    protected Object mergeCounter(Object o1, Object o2) {
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            return o1;
        }
        return (Integer)o1 + (Integer)o2;
    }
}

