/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.statping;

import com.sygate.scm.util.StringUtilities;
import java.util.HashMap;
import java.util.Map;

public final class ClientSearchCriteriaPingMapping {
    private static final Map<String, Integer> internalMap = new HashMap<String, Integer>();
    private static final ClientSearchCriteriaPingMapping instance = new ClientSearchCriteriaPingMapping();

    public static ClientSearchCriteriaPingMapping getInstance() {
        return instance;
    }

    public Integer getSubModuleID(String key) {
        if (StringUtilities.isEmpty(key)) {
            return null;
        }
        return internalMap.get(key);
    }

    private ClientSearchCriteriaPingMapping() {
        this.initialMapping();
    }

    private void initialMapping() {
        this.initialAgentCriteria();
        this.initialComputerCriteria();
        this.initialClientCriteria();
        this.initialCompositeCriteria();
        this.initialQueryCriteria();
    }

    private void initialAgentCriteria() {
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "AGENT_TYPE"), 257);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "AGENT_VERSION"), 258);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "PROFILE_VERSION"), 259);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "PROFILE_SERIAL_NO"), 260);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "PROFILE_CHECKSUM"), 261);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "IDS_VERSION"), 262);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "IDS_SERIAL_NO"), 263);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "IDS_CHECKSUM"), 264);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "STATUS"), 265);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "LAST_UPDATE_TIME"), 266);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "TIMEZONE"), 267);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "FREE_MEM"), 268);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "FREE_DISK"), 269);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "LAST_SERVER_ID"), 270);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "LAST_SITE_ID"), 271);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "HI_STATUS"), 272);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "HI_REASONCODE"), 273);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "HI_REASONDESC"), 274);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "INSTALL_TYPE"), 275);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "PEP_ONOFF"), 276);
    }

    private void initialComputerCriteria() {
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "COMPUTER_ID"), 513);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "HARDWARE_KEY"), 514);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "COMPUTER_DOMAIN_NAME"), 515);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "PROCESSOR_TYPE"), 516);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "PROCESSOR_CLOCK"), 517);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "PROCESSOR_NUM"), 518);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "BIOS_VERSION"), 519);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "TPM_DEVICE"), 520);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "OPERATION_SYSTEM"), 521);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "SERVICE_PACK"), 522);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "MEMORY"), 523);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "DISK_TOTAL"), 524);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "OS_LANG"), 525);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "IP_ADDR1"), 526);
        internalMap.put(this.getCriteriaMappingKey("GUP_LIST", "DELETED"), 527);
        internalMap.put(this.getCriteriaMappingKey("DUMMY_TABLE", "DUMMY_COLUMN"), 528);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "DOMAIN_ID"), 529);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "UUID"), 530);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "EWF"), 532);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "FBWF"), 533);
        internalMap.put(this.getCriteriaMappingKey("SEM_COMPUTER", "UWF"), 534);
    }

    private void initialClientCriteria() {
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "CLIENT_ID"), 769);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "GROUP_ID"), 770);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "USER_DOMAIN_NAME"), 771);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "CREATION_TIME"), 772);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "POLICY_MODE"), 773);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "GROUP_IS_OU"), 774);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "OU_GUID"), 775);
    }

    private void initialCompositeCriteria() {
        internalMap.put(this.getCriteriaMappingKey("SELECT TOP 1 PATTERN.VERSION FROM PATTERN WITH(NOLOCK) WHERE SEM_AGENT.PATTERN_IDX=PATTERN.PATTERN_IDX AND SEM_AGENT.DELETED=0 AND PATTERN.DELETED=0 AND SEM_AGENT.AP_ONOFF IN(0,1) ", ""), 1025);
        internalMap.put(this.getCriteriaMappingKey("SELECT TOP 1 PATTERN.VERSION FROM PATTERN INNER JOIN SEM_CONTENT with (NOLOCK) ON PATTERN.PATTERN_IDX=SEM_CONTENT.PATTERN_IDX WHERE SEM_AGENT.AGENT_ID = SEM_CONTENT.AGENT_ID AND PATTERN.DELETED=0 AND SEM_AGENT.AP_ONOFF IN(0,1) AND SEM_AGENT.DELETED=0 AND SEM_CONTENT.DELETED=0 AND PATTERN.PATTERN_TYPE=", "'DEUCE_SIG'"), 1026);
        internalMap.put(this.getCriteriaMappingKey("SELECT TOP 1 PATTERN.VERSION FROM PATTERN INNER JOIN SEM_CONTENT with (NOLOCK) ON PATTERN.PATTERN_IDX=SEM_CONTENT.PATTERN_IDX WHERE SEM_AGENT.AGENT_ID = SEM_CONTENT.AGENT_ID AND PATTERN.DELETED=0 AND SEM_AGENT.AP_ONOFF IN(0,1) AND SEM_AGENT.DELETED=0 AND SEM_CONTENT.DELETED=0 AND PATTERN.PATTERN_TYPE=", "'SYKNAPPS_WHITELIST'"), 1027);
        internalMap.put(this.getCriteriaMappingKey("SELECT TOP 1 PATTERN.VERSION FROM PATTERN INNER JOIN SEM_CONTENT with (NOLOCK) ON PATTERN.PATTERN_IDX=SEM_CONTENT.PATTERN_IDX WHERE SEM_AGENT.AGENT_ID = SEM_CONTENT.AGENT_ID AND PATTERN.DELETED=0 AND SEM_AGENT.AP_ONOFF IN(0,1) AND SEM_AGENT.DELETED=0 AND SEM_CONTENT.DELETED=0 AND PATTERN.PATTERN_TYPE=", "'BASH_CONTENT'"), 1028);
    }

    private void initialQueryCriteria() {
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "COMPUTER_NAME"), 1281);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "USER_NAME"), 1282);
        internalMap.put(this.getCriteriaMappingKey("SEM_CLIENT", "DESCRIPTION"), 1283);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "FULL_NAME"), 1284);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "EMAIL"), 1285);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "JOB_TITLE"), 1286);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "DEPARTMENT"), 1288);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "EMPLOYEE_NUMBER"), 1289);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "EMPLOYMENT_STATUS"), 1290);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "OFFICE_PHONE"), 1291);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "MOBILE_PHONE"), 1292);
        internalMap.put(this.getCriteriaMappingKey("SEM_AGENT", "HOME_PHONE"), 1293);
    }

    public String getCriteriaMappingKey(String tableName, String columnName) {
        return tableName + "." + columnName;
    }
}

