/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.statping;

import com.sygate.scm.common.statping.BasePings;
import com.sygate.scm.common.statping.CommonPingLogger;
import com.sygate.scm.common.statping.DefaultPingLogger;
import com.sygate.scm.common.statping.IStatPingManager;
import com.sygate.scm.common.statping.PingData;
import com.sygate.scm.common.statping.PingType;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPings
implements BasePings,
Serializable {
    private static final long serialVersionUID = 9047769707112980395L;
    protected Map<PingType, PingData> dataSet = new ConcurrentHashMap<PingType, PingData>();
    protected static final CommonPingLogger logger = DefaultPingLogger.newInstance();

    @Override
    public void clearPings() {
        if (this.dataSet != null) {
            this.dataSet.clear();
        }
    }

    public Collection<PingData> getDataSet() {
        return Collections.unmodifiableCollection(this.dataSet.values());
    }

    @Override
    public void submitPings(IStatPingManager sp, String sBaseUrl, int limit) throws IOException {
        String className = this.getClass().getSimpleName();
        if (!this.canSubmitPing()) {
            logger.logFinestMessage(className + " : It's not the time to submit this ping to server now.");
            return;
        }
        logger.logFinestMessage(className + " : Inside submitPings");
        this.populateData();
        this.tailDataForLicense(sp);
        this.tailDataForSetting(sp);
        if (this.dataSet.size() == 0) {
            logger.logFinestMessage(className + " : No ping data, skipping this ping object.");
            return;
        }
        int count = 0;
        for (PingData pingData : this.dataSet.values()) {
            if (pingData.isEmpty()) {
                logger.logFineMessage(className + " : No ping data, skipping the ping type - " + pingData.getTypeString());
                continue;
            }
            logger.logFineMessage(className + " : Sending the ping requests : " + pingData.getTypeString());
            for (String url : pingData.toUrl()) {
                if (this.isPingLimited() && count >= limit) {
                    logger.logWarnMessage(className + " : The maximum Ping limit has reached: " + limit);
                    logger.logWarnMessage(className + " : All following pings of " + this.getClass().getName() + " will be dropped! ");
                    return;
                }
                try {
                    sp.sendUrlRequest(sBaseUrl + url);
                    ++count;
                }
                catch (MalformedURLException e) {
                    logger.logException(e);
                }
            }
        }
    }

    protected void mergeData(Collection<PingData> dataSet) {
        for (PingData pingData : dataSet) {
            this.mergeData(pingData);
        }
    }

    protected void mergeData(PingData thatData) {
        if (thatData == null || thatData.isEmpty()) {
            return;
        }
        if (this.dataSet.get((Object)thatData.getPingType()) == null) {
            this.dataSet.put(thatData.getPingType(), thatData);
        } else {
            for (PingData thisData : this.dataSet.values()) {
                if (!thisData.getPingType().equals((Object)thatData.getPingType())) continue;
                thisData.merge(thatData);
                break;
            }
        }
    }

    protected void increase(int moduleId, int subModuleId) {
        PingType pingType = PingType.getInstance(moduleId);
        if (pingType == null) {
            logger.logWarnMessage("The PingType for the supplied moduleId is null : " + moduleId);
            return;
        }
        this.increase(pingType, subModuleId);
    }

    protected void increase(PingType pingType, int subModuleId) {
        if (pingType == null) {
            logger.logWarnMessage("The PingType for the supplied moduleId is null. ");
            return;
        }
        PingData pingData = this.dataSet.get((Object)pingType);
        if (pingData == null) {
            pingData = PingData.newCountableInstance(pingType);
            pingData.newPingRequest(subModuleId);
            pingData.put("A", 1);
            this.dataSet.put(pingData.getPingType(), pingData);
        } else {
            PingData newPingData = PingData.newCountableInstance(pingType);
            newPingData.newPingRequest(subModuleId);
            newPingData.put("A", 1);
            pingData.merge(newPingData);
        }
    }

    protected boolean canSubmitPing() {
        return true;
    }

    protected boolean isPingLimited() {
        return true;
    }

    protected void populateData() {
    }

    protected static Set<PingType> getAllLicenseAllowedPingTypes(IStatPingManager manager) {
        return AbstractPings.getAllowedPingtypes(manager, Arrays.asList(PingType.values()));
    }

    private void tailDataForLicense(IStatPingManager manager) {
        String className = this.getClass().getSimpleName();
        logger.logFinestMessage(className + " : Tailing the ping data by license type...");
        ConcurrentHashMap<PingType, PingData> newdata = new ConcurrentHashMap<PingType, PingData>();
        Set<PingType> allowedType = AbstractPings.getAllowedPingtypes(manager, this.dataSet.keySet());
        for (PingType type : allowedType) {
            newdata.put(type, this.dataSet.get((Object)type));
        }
        this.dataSet = newdata;
    }

    private void tailDataForSetting(IStatPingManager manager) {
        for (PingData data : this.dataSet.values()) {
            for (int subModuleId : data.getSubModuleId()) {
                if (manager.shouldSendPing(data.getModuleId(), subModuleId)) continue;
                logger.logFineMessage("Ignoring the submodule because it's either disabled or dropped according to probability in setttings: " + data.getModuleId() + "->" + data.getSubModuleId());
                data.removeSubModule(subModuleId);
            }
        }
    }

    private static Set<PingType> getAllowedPingtypes(IStatPingManager manager, Collection<PingType> pingTypes) {
        return new HashSet<PingType>(pingTypes);
    }
}

