/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.sso;

import com.sygate.scm.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonTicket {
    public static final int TICKET_MAGIC = 191232814;
    public static final int TICKET_FORMAT_VERSION = 1;
    private String _userName;
    private String _domainName;
    private String _targetURL;
    protected static final Logger logger = Logger.getLogger(CommonTicket.class.getName());

    public CommonTicket(String userName, String domainName, String targetURL) throws Exception {
        if (userName == null || userName.isEmpty()) {
            throw new Exception("Required argument: userName.");
        }
        if (targetURL == null || targetURL.isEmpty()) {
            throw new Exception("Required argument: targetURL.");
        }
        this._userName = userName;
        this._domainName = domainName;
        this._targetURL = targetURL;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public String gettargetURL() {
        return this._targetURL;
    }

    public static CommonTicket readBase64(String ticketBase64) throws Exception {
        try {
            byte[] ticketData = Base64Util.decode(ticketBase64);
            DataInputStream ticketDataStream = new DataInputStream(new ByteArrayInputStream(ticketData));
            int ticketMagic = ticketDataStream.readInt();
            if (ticketMagic != 191232814) {
                throw new Exception("SSOError:227");
            }
            ticketDataStream.readInt();
            short formatVersion = ticketDataStream.readShort();
            if (formatVersion != 1) {
                throw new Exception("SSOError:229");
            }
            GregorianCalendar issueDate = new GregorianCalendar();
            issueDate.setTimeInMillis(ticketDataStream.readLong());
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.setTimeInMillis(ticketDataStream.readLong());
            String userInfo = CommonTicket.readString(ticketDataStream);
            int idx = userInfo.indexOf(92);
            String userName = "";
            String domainName = "";
            if (idx >= 0 && idx < userInfo.length() + 1) {
                domainName = userInfo.substring(0, idx);
                userName = userInfo.substring(idx + 1);
            }
            if (idx == -1) {
                domainName = "";
                userName = userInfo;
            }
            if (userName == null || userName.length() == 0) {
                throw new Exception("SSOError:233");
            }
            String targetURL = CommonTicket.readString(ticketDataStream);
            return new CommonTicket(userName, domainName, targetURL);
        }
        catch (IOException eReadFromStream) {
            throw new Exception("An I/O error occurred while decoding the ticket from the input stream." + eReadFromStream);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private static String readString(DataInputStream inputStream) throws IOException, Exception {
        if (inputStream == null) {
            throw new Exception("Required argument: inputStream.");
        }
        int stringLength = inputStream.readInt();
        byte[] buffer = new byte[stringLength];
        int retRead = inputStream.read(buffer, 0, stringLength);
        if (retRead <= 0) {
            logger.log(Level.FINEST, "Stream has reached the end. Or length is 0. RET = " + retRead);
        }
        CharBuffer chars = Charset.forName("UTF8").decode(ByteBuffer.wrap(buffer));
        return chars.toString();
    }
}

