/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryMatchEntity;
import com.sygate.scm.common.configobject.schema.TargetRegistryMatch;
import com.sygate.scm.common.configobject.schema.TargetRegistryNoMatch;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;

public class SEPMigrationRegMatcher {
    static final String[] SEP_MIGRATION_REQUIRED_REGISTRY_ARRAY = new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec AntiVirus", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec AntiVirus\\*\\*", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ccEvtMgr\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ccSetMgr\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\EraserUtilRebootDrv\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SmcService\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SNAC\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SnacNp\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SPBBCDrv\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SRTSP\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SRTSPL\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SRTSPX\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Symantec AntiVirus\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SymEvent\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SYMREDRV\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SYMTDI\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SysPlant\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Teefer2\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\WPS\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\WpsHelper\\*\\*", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\WGX\\*\\*"};

    protected static boolean blockMatch(OpRegistryAccess opRegistryAccess) {
        ArrayList<String> matchedMigrationItemList = new ArrayList<String>();
        if (opRegistryAccess != null && opRegistryAccess.getOpTargetRegistry() != null && SEPMigrationRegMatcher.containBlockAction(opRegistryAccess)) {
            TargetRegistryNoMatch regNoMatch;
            TargetRegistryMatch regMatch = opRegistryAccess.getOpTargetRegistry().getOptTargetRegistryMatch();
            if (regMatch != null) {
                for (OpRegistryMatchEntity entity : regMatch.getOpRegistryMatchEntity()) {
                    String fileName = SEPMigrationRegMatcher.matchMigrationItem(entity);
                    if (fileName == null) continue;
                    matchedMigrationItemList.add(fileName);
                }
            }
            if (matchedMigrationItemList.size() > 0 && (regNoMatch = opRegistryAccess.getOpTargetRegistry().getOptTargetRegistryNoMatch()) != null) {
                for (OpRegistryMatchEntity entity : regNoMatch.getOpRegistryMatchEntity()) {
                    String fileName = SEPMigrationRegMatcher.matchMigrationItem(entity);
                    if (fileName == null) continue;
                    matchedMigrationItemList.remove(fileName);
                }
            }
        }
        return matchedMigrationItemList.size() > 0;
    }

    protected static boolean containBlockAction(OpRegistryAccess opRegistryAccess) {
        Integer action;
        if (opRegistryAccess.getOptOpRegistryRead() != null && (OpAction.BLOCK.equals(action = opRegistryAccess.getOptOpRegistryRead().getOpAction().getAction()) || OpAction.TERMINATE.equals(action))) {
            return true;
        }
        return opRegistryAccess.getOptOpRegistryWrite() != null && (OpAction.BLOCK.equals(action = opRegistryAccess.getOptOpRegistryWrite().getOpAction().getAction()) || OpAction.TERMINATE.equals(action));
    }

    protected static String matchMigrationItem(OpRegistryMatchEntity opRegistryMatchEntity) {
        String reg = opRegistryMatchEntity.getRegKey();
        if (!StringUtilities.isEmpty(reg)) {
            for (int i = 0; i < SEP_MIGRATION_REQUIRED_REGISTRY_ARRAY.length; ++i) {
                if (!SEP_MIGRATION_REQUIRED_REGISTRY_ARRAY[i].equalsIgnoreCase(reg.trim())) continue;
                return SEP_MIGRATION_REQUIRED_REGISTRY_ARRAY[i];
            }
        }
        return null;
    }
}

