/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcess;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.ProcessImageNoMatch;
import com.sygate.scm.common.osprotect.SEPMigrationBlockDetectorHelper;
import com.sygate.scm.util.Utility;
import java.util.Vector;

public class SEPMigrationProcessMatcher {
    static final String[] SEP_PROCESS_MIGRATION_EXCLUSIONS = new String[]{"%windir%\\system32\\msiexec.exe", "%windir%\\syswow64\\msiexec.exe", "#HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection\\Migration\\TargetPath#*\\*.exe", "#HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection\\Migration\\TargetPath#*\\*\\*.exe"};

    protected static boolean containAllSEPMirgraionExclusions(OpAppRule rule) {
        for (int i = 0; i < SEP_PROCESS_MIGRATION_EXCLUSIONS.length; ++i) {
            if (SEPMigrationProcessMatcher.containNoMatchProcessByName(rule.getOpProcess(), SEP_PROCESS_MIGRATION_EXCLUSIONS[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean addExclusionForSEPMigration(OpAppRule rule) {
        boolean added = false;
        for (int i = 0; i < SEP_PROCESS_MIGRATION_EXCLUSIONS.length; ++i) {
            if (SEPMigrationProcessMatcher.containNoMatchProcessByName(rule.getOpProcess(), SEP_PROCESS_MIGRATION_EXCLUSIONS[i])) continue;
            ProcessImageNoMatch exclusion = rule.getOpProcess().getOptProcessImageNoMatch();
            if (exclusion == null) {
                exclusion = new ProcessImageNoMatch();
                exclusion.setI(Utility.calculateHash(rule.getI() + SEP_PROCESS_MIGRATION_EXCLUSIONS[i]));
                rule.getOpProcess().setOptProcessImageNoMatch(exclusion);
            }
            OpProcessMatchEntity opProcessMatchEntity = new OpProcessMatchEntity();
            opProcessMatchEntity.setOptEnable(Boolean.TRUE);
            opProcessMatchEntity.setI(Utility.calculateHash(exclusion.getI() + SEP_PROCESS_MIGRATION_EXCLUSIONS[i]));
            exclusion.addOpProcessMatchEntity(opProcessMatchEntity);
            OpFileNameMatchEntity opFileNameMatchEntity = new OpFileNameMatchEntity();
            opFileNameMatchEntity.setOptEnable(Boolean.TRUE);
            opFileNameMatchEntity.setOptMethod(OpFileNameMatchEntity.NORMAL);
            opFileNameMatchEntity.setKeyString(SEP_PROCESS_MIGRATION_EXCLUSIONS[i]);
            opFileNameMatchEntity.setI(Utility.calculateHash(opProcessMatchEntity.getI() + SEP_PROCESS_MIGRATION_EXCLUSIONS[i]));
            opProcessMatchEntity.setOptOpFileNameMatchEntity(opFileNameMatchEntity);
            added = true;
        }
        return added;
    }

    protected static boolean containNoMatchProcessByName(OpProcess opProcess, String processName) {
        ProcessImageNoMatch exclusion = opProcess.getOptProcessImageNoMatch();
        if (exclusion != null) {
            Vector<OpProcessMatchEntity> noMatchEntiry = exclusion.getOpProcessMatchEntity();
            for (OpProcessMatchEntity entity : noMatchEntiry) {
                if (!SEPMigrationBlockDetectorHelper.isFileNameEquals(entity.getOptOpFileNameMatchEntity(), processName)) continue;
                return true;
            }
        }
        return false;
    }
}

