/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.osprotect.SEPMigrationBlockDetectorHelper;
import java.util.ArrayList;

public class SEPMigrationFileMatcher {
    static final String[] SEP_MIGRATION_REQUIRED_FILE_ARRAY = new String[]{"#HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection\\SMC\\smc_install_path#*", "#HKEY_LOCAL_MACHINE\\SOFTWARE\\Symantec\\Symantec Endpoint Protection\\SMC\\smc_install_path#*\\*", "%windir%\\system32\\drivers\\COH_Mon.sys", "%windir%\\system32\\drivers\\srtsp.sys", "%windir%\\system32\\drivers\\srtspl.sys", "%windir%\\system32\\drivers\\srtspx.sys", "%windir%\\system32\\drivers\\symdns.sys", "%windir%\\system32\\drivers\\SYMEVENT.SYS", "%windir%\\system32\\drivers\\symfw.sys", "%windir%\\system32\\drivers\\symids.sys", "%windir%\\system32\\drivers\\symndis.sys", "%windir%\\system32\\drivers\\symndisv.sys", "%windir%\\system32\\drivers\\symredrv.sys", "%windir%\\system32\\drivers\\symtdi.sys", "%windir%\\system32\\drivers\\SysPlant.sys", "%windir%\\system32\\drivers\\teefer2.sys", "%windir%\\system32\\drivers\\WGX.SYS", "%windir%\\system32\\drivers\\WPSDRVnt.sys", "%windir%\\system32\\drivers\\WpsHelper.sys", "%windir%\\system32\\s32evnt1.dll", "%windir%\\system32\\symneti.dll", "%windir%\\system32\\symredir.dll", "%windir%\\system32\\sysfer.dll", "%windir%\\system32\\symvpn.dll"};

    protected static boolean blockMatch(OpFileAccess opFileAccess) {
        ArrayList<String> matchedMigrationFileList = new ArrayList<String>();
        if (opFileAccess != null && opFileAccess.getOpTargetFile() != null && SEPMigrationFileMatcher.containBlockAction(opFileAccess)) {
            String fileName;
            if (opFileAccess.getOpTargetFile().getOptTargetFileMatch() != null) {
                for (OpFileMatchEntity entity : opFileAccess.getOpTargetFile().getOptTargetFileMatch().getOpFileMatchEntity()) {
                    fileName = SEPMigrationFileMatcher.matchMigrationItem(entity);
                    if (fileName == null) continue;
                    matchedMigrationFileList.add(fileName);
                }
            }
            if (matchedMigrationFileList.size() > 0 && opFileAccess.getOpTargetFile().getOptTargetFileNoMatch() != null) {
                for (OpFileMatchEntity entity : opFileAccess.getOpTargetFile().getOptTargetFileNoMatch().getOpFileMatchEntity()) {
                    fileName = SEPMigrationFileMatcher.matchMigrationItem(entity);
                    if (fileName == null) continue;
                    matchedMigrationFileList.remove(fileName);
                }
            }
        }
        return matchedMigrationFileList.size() > 0;
    }

    protected static boolean containBlockAction(OpFileAccess opFileAccess) {
        Integer action;
        if (opFileAccess.getOptOpFileRead() != null && (OpAction.BLOCK.equals(action = opFileAccess.getOptOpFileRead().getOpAction().getAction()) || OpAction.TERMINATE.equals(action))) {
            return true;
        }
        return opFileAccess.getOptOpFileWrite() != null && (OpAction.BLOCK.equals(action = opFileAccess.getOptOpFileWrite().getOpAction().getAction()) || OpAction.TERMINATE.equals(action));
    }

    protected static String matchMigrationItem(OpFileMatchEntity opFileMatchEntity) {
        OpFileNameMatchEntity fileEntity = opFileMatchEntity.getOptOpFileNameMatchEntity();
        if (fileEntity != null) {
            for (int i = 0; i < SEP_MIGRATION_REQUIRED_FILE_ARRAY.length; ++i) {
                if (!SEPMigrationBlockDetectorHelper.isFileNameEquals(fileEntity, SEP_MIGRATION_REQUIRED_FILE_ARRAY[i])) continue;
                return SEP_MIGRATION_REQUIRED_FILE_ARRAY[i];
            }
        }
        return null;
    }
}

