/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.BaselineAppProtectionBlockArray;
import com.sygate.scm.common.configobject.schema.EnforcedAppProtectionBlockArray;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtBlockEntity;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplate;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.osprotect.IOpAppProtTemplateRetriever;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;

public class SEPMigrationBlockDetectorHelper {
    protected static boolean isFileNameEquals(OpFileNameMatchEntity opFileNameMatchEntity, String targetFileName) {
        boolean equals = false;
        if (opFileNameMatchEntity != null && !StringUtilities.isEmpty(opFileNameMatchEntity.getKeyString()) && !StringUtilities.isEmpty(targetFileName)) {
            equals = opFileNameMatchEntity.getKeyString().trim().equalsIgnoreCase(targetFileName.trim());
        }
        return equals;
    }

    protected static ArrayList<OpAppProtectionBlock> getAllADCRuleset(OpAppProtectionPolicy adcPolicy, IOpAppProtTemplateRetriever opAppProtTemplateRetriever, GUID domainGUID) {
        ArrayList<OpAppProtectionBlock> allRulesetList = new ArrayList<OpAppProtectionBlock>();
        if (adcPolicy != null && adcPolicy.getOptAppProtectionRuleSystem() != null) {
            BaselineAppProtectionBlockArray baselineAppProtectionBlockArray;
            ArrayList<OpAppProtBlockEntity> allEntityList = new ArrayList<OpAppProtBlockEntity>();
            EnforcedAppProtectionBlockArray enforcedAppProtectionBlockArray = adcPolicy.getOptAppProtectionRuleSystem().getOptEnforcedAppProtectionBlockArray();
            if (enforcedAppProtectionBlockArray != null) {
                allEntityList.addAll(enforcedAppProtectionBlockArray.getOpAppProtBlockEntity());
            }
            if ((baselineAppProtectionBlockArray = adcPolicy.getOptAppProtectionRuleSystem().getOptBaselineAppProtectionBlockArray()) != null) {
                allEntityList.addAll(baselineAppProtectionBlockArray.getOpAppProtBlockEntity());
            }
            for (OpAppProtBlockEntity entity : allEntityList) {
                OpAppProtectionBlock block = entity.getOptOpAppProtectionBlock();
                if (block != null) {
                    allRulesetList.add(block);
                    continue;
                }
                ObjReference objRef = entity.getOptObjReference();
                if (objRef == null) continue;
                try {
                    OpAppProtTemplate ospTemplate = opAppProtTemplateRetriever.retrieve(new GUID(objRef.getTargetId()), domainGUID);
                    if (ospTemplate == null || ospTemplate.getOpAppProtectionBlock() == null) continue;
                    allRulesetList.add(ospTemplate.getOpAppProtectionBlock());
                }
                catch (Exception e) {
                    System.out.println("Warning:  get a error when  retrieven OpAppProtTemplate: " + e.getMessage());
                }
            }
        }
        return allRulesetList;
    }
}

