/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpCreateProcess;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileRead;
import com.sygate.scm.common.configobject.schema.OpFileWrite;
import com.sygate.scm.common.configobject.schema.OpLoadModule;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpPermissionList;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryAccess;
import com.sygate.scm.common.configobject.schema.OpRegistryRead;
import com.sygate.scm.common.configobject.schema.OpRegistryWrite;
import com.sygate.scm.common.configobject.schema.OpTerminateProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.osprotect.IOpAppProtTemplateRetriever;
import com.sygate.scm.common.osprotect.SEPMigrationBlockDetectorHelper;
import com.sygate.scm.common.osprotect.SEPMigrationFileMatcher;
import com.sygate.scm.common.osprotect.SEPMigrationProcessMatcher;
import com.sygate.scm.common.osprotect.SEPMigrationRegMatcher;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SEPMigrationBlockDetector {
    public static final String AC1_RULE_PROTECT_SEP_FILE_REGISTRY = "Protect client files and registry keys";
    public static final String AC1_RULE_ALLOW_CLIENT_PROCESSES = "Allow client processess";
    private IOpAppProtTemplateRetriever opAppProtTemplateRetriever = null;
    private GUID domainGUID = null;
    private OpAppProtectionPolicy adcPolicy = null;
    private ArrayList<OpAppRule> needExclusionRuleListCache = null;

    public SEPMigrationBlockDetector(OpAppProtectionPolicy adcPolicy, IOpAppProtTemplateRetriever opAppProtTemplateRetriever, GUID domainGUID) {
        this.adcPolicy = adcPolicy;
        this.opAppProtTemplateRetriever = opAppProtTemplateRetriever;
        this.domainGUID = domainGUID;
    }

    public boolean needExclusions() {
        this.needExclusionRuleListCache = new ArrayList();
        ArrayList<OpAppProtectionBlock> allRuleset = SEPMigrationBlockDetectorHelper.getAllADCRuleset(this.adcPolicy, this.opAppProtTemplateRetriever, this.domainGUID);
        this.needExclusionRuleListCache = SEPMigrationBlockDetector.findSEPBlockRulesByName(allRuleset);
        if (this.needExclusionRuleListCache.size() == 0) {
            this.needExclusionRuleListCache = SEPMigrationBlockDetector.findSuspectedAC1Rules(allRuleset);
        }
        for (OpAppRule rule : this.needExclusionRuleListCache) {
            if (SEPMigrationProcessMatcher.containAllSEPMirgraionExclusions(rule)) continue;
            return true;
        }
        return false;
    }

    public List<OpAppRule> migrateAllowClientProcessRules() {
        ArrayList<OpAppRule> migrationdRuleList = new ArrayList<OpAppRule>();
        if (this.adcPolicy == null || this.opAppProtTemplateRetriever == null || this.domainGUID == null) {
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> ADCPolicy or opAppProtTemplateRetriever or domain ID is invalid");
            return migrationdRuleList;
        }
        ArrayList<OpAppProtectionBlock> allRuleset = SEPMigrationBlockDetectorHelper.getAllADCRuleset(this.adcPolicy, this.opAppProtTemplateRetriever, this.domainGUID);
        List<OpAppRule> rules = SEPMigrationBlockDetector.findAllowClientProcessesRules(allRuleset);
        boolean needMigration = false;
        for (OpAppRule rule : rules) {
            boolean ruleEnabled;
            if (rule.getOptEnable() == null) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> The Enable property of this rule is null, skip it... The rule is:" + rule.getName() + ", id=" + rule.getId());
                continue;
            }
            OpPermissionList permissionList = rule.getOpPermissionList();
            if (permissionList == null) continue;
            Vector<OpFileAccess> fileAccessList = permissionList.getOpFileAccess();
            Vector<OpRegistryAccess> registryAccessList = permissionList.getOpRegistryAccess();
            Vector<OpProcessAccess> processAccessList = permissionList.getOpProcessAccess();
            Vector<OpModuleAccess> moduleAccessList = permissionList.getOpModuleAccess();
            HashMap<Integer, OpFileAccess> disabledOpFileAccessList = new HashMap<Integer, OpFileAccess>();
            HashMap<Integer, OpRegistryAccess> disabledOpRegistryAccessList = new HashMap<Integer, OpRegistryAccess>();
            HashMap<Integer, OpProcessAccess> disabledOpProcessAccessList = new HashMap<Integer, OpProcessAccess>();
            HashMap<Integer, OpModuleAccess> disabledOpModuleAccessList = new HashMap<Integer, OpModuleAccess>();
            boolean includeBlockAction = false;
            boolean isSubRuleDisabled = false;
            includeBlockAction = this.processOpFileAccessList(fileAccessList, disabledOpFileAccessList);
            if (includeBlockAction) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> This rule[" + rule.getName() + ", id=" + rule.getId() + "]includes  OpFileAccess block actions, so skip it and will not fix it...");
                continue;
            }
            includeBlockAction = this.processOpRegistryAccessList(registryAccessList, disabledOpRegistryAccessList);
            if (includeBlockAction) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> This rule[" + rule.getName() + ", id=" + rule.getId() + "]includes  OpRegistryAccess block actions, so skip it and will not fix it...");
                continue;
            }
            includeBlockAction = this.processOpProcessAccessList(processAccessList, disabledOpProcessAccessList);
            if (includeBlockAction) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> This rule[" + rule.getName() + ", id=" + rule.getId() + "]includes  OpProcessAccess block actions, so skip it and will not fix it...");
                continue;
            }
            includeBlockAction = this.processOpModuleAccessList(moduleAccessList, disabledOpModuleAccessList);
            if (includeBlockAction) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> This rule[" + rule.getName() + ", id=" + rule.getId() + "]includes  OpModuleAccess block actions, so skip it and will not fix it...");
                continue;
            }
            int size = disabledOpFileAccessList.size() + disabledOpRegistryAccessList.size() + disabledOpProcessAccessList.size() + disabledOpModuleAccessList.size();
            if (size > 0) {
                isSubRuleDisabled = true;
            }
            if ((ruleEnabled = rule.getOptEnable().booleanValue()) && !isSubRuleDisabled) continue;
            if (!ruleEnabled && !includeBlockAction) {
                System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> All the sub-rule include ALLOW or DONOTHING actions, set the rule as enabled, rule name is:" + rule.getName() + ", id=" + rule.getId());
                rule.setOptEnable(true);
                needMigration = true;
            }
            boolean fileAccessResult = this.processDiabledOpFileAccessList(disabledOpFileAccessList, rule);
            boolean registryAccessResult = this.processDisabledOpRegistryAccessList(disabledOpRegistryAccessList, rule);
            boolean processAccessReult = this.processDisabledOpProcessAccessList(disabledOpProcessAccessList, rule);
            boolean moduleAccessResult = this.processDisabledModuleAccessList(disabledOpModuleAccessList, rule);
            if (!(needMigration = needMigration || fileAccessResult || registryAccessResult || processAccessReult || moduleAccessResult)) continue;
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> Add rule [" + rule.getName() + ", id=" + rule.getId() + "] to migration List for further upate.");
            migrationdRuleList.add(rule);
        }
        return migrationdRuleList;
    }

    private boolean processOpFileAccessList(Vector<OpFileAccess> fileAccessList, Map<Integer, OpFileAccess> disabledOpFileAccessList) {
        boolean includeBlockAction = false;
        boolean enabled = false;
        int len = fileAccessList.size();
        for (int i = 0; i < len; ++i) {
            OpFileAccess fileAccess = fileAccessList.get(i);
            if (fileAccess == null) continue;
            enabled = fileAccess.getOptEnable() == null ? fileAccess.getDefEnable().booleanValue() : fileAccess.getOptEnable().booleanValue();
            if (!enabled) {
                disabledOpFileAccessList.put(i, fileAccess);
                continue;
            }
            if (!this.detectBlockActionFromFileAccess(fileAccess)) continue;
            includeBlockAction = true;
            break;
        }
        return includeBlockAction;
    }

    private boolean processOpRegistryAccessList(Vector<OpRegistryAccess> registryAccessList, Map<Integer, OpRegistryAccess> disabledOpRegistryAccessList) {
        boolean includeBlockAction = false;
        boolean enabled = false;
        int len = registryAccessList.size();
        for (int i = 0; i < len; ++i) {
            OpRegistryAccess registryAccess = registryAccessList.get(i);
            if (registryAccess == null) continue;
            enabled = registryAccess.getOptEnable() == null ? registryAccess.getDefEnable().booleanValue() : registryAccess.getOptEnable().booleanValue();
            if (!enabled) {
                disabledOpRegistryAccessList.put(i, registryAccess);
                continue;
            }
            if (!this.detectBlockActionFromRegistryAccess(registryAccess)) continue;
            includeBlockAction = true;
            break;
        }
        return includeBlockAction;
    }

    private boolean processOpProcessAccessList(Vector<OpProcessAccess> processAccessList, Map<Integer, OpProcessAccess> disabledOpProcessAccessList) {
        boolean includeBlockAction = false;
        boolean enabled = false;
        int len = processAccessList.size();
        for (int i = 0; i < len; ++i) {
            OpProcessAccess processAccess = processAccessList.get(i);
            if (processAccess == null) continue;
            enabled = processAccess.getOptEnable() == null ? processAccess.getDefEnable().booleanValue() : processAccess.getOptEnable().booleanValue();
            if (!enabled) {
                disabledOpProcessAccessList.put(i, processAccess);
                continue;
            }
            if (!this.detectBlockActionFromProcessAccess(processAccess)) continue;
            includeBlockAction = true;
            break;
        }
        return includeBlockAction;
    }

    private boolean processOpModuleAccessList(Vector<OpModuleAccess> moduleAccessList, Map<Integer, OpModuleAccess> disabledOpModuleAccessList) {
        boolean includeBlockAction = false;
        boolean enabled = false;
        int len = moduleAccessList.size();
        for (int i = 0; i < len; ++i) {
            OpModuleAccess moduleAccess = moduleAccessList.get(i);
            if (moduleAccess == null) continue;
            enabled = moduleAccess.getOptEnable() == null ? true : moduleAccess.getOptEnable();
            if (!enabled) {
                disabledOpModuleAccessList.put(i, moduleAccess);
                continue;
            }
            if (!this.detectBlockActionFromModuleAccess(moduleAccess)) continue;
            includeBlockAction = true;
            break;
        }
        return includeBlockAction;
    }

    private boolean processDiabledOpFileAccessList(Map<Integer, OpFileAccess> disabledOpFileAccessList, OpAppRule rule) {
        boolean result = false;
        int count = 0;
        for (Map.Entry<Integer, OpFileAccess> entry : disabledOpFileAccessList.entrySet()) {
            OpAction action;
            OpFileAccess fileAccess = entry.getValue();
            boolean update = false;
            OpFileRead read = fileAccess.getOptOpFileRead();
            OpFileWrite write = fileAccess.getOptOpFileWrite();
            if (null != read) {
                action = read.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (null != write) {
                action = write.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (!update) continue;
            fileAccess.setOptEnable(true);
            ++count;
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> Update OpFileAccess[" + fileAccess.getName() + "] as enabled for rule:" + rule.getName() + ", id=" + rule.getId());
        }
        if (count > 0) {
            result = true;
        }
        return result;
    }

    private boolean processDisabledOpRegistryAccessList(Map<Integer, OpRegistryAccess> disabledOpRegistryAccessList, OpAppRule rule) {
        boolean result = false;
        int count = 0;
        for (Map.Entry<Integer, OpRegistryAccess> entry : disabledOpRegistryAccessList.entrySet()) {
            OpAction action;
            OpRegistryAccess registryAccess = entry.getValue();
            OpRegistryRead read = registryAccess.getOptOpRegistryRead();
            OpRegistryWrite write = registryAccess.getOptOpRegistryWrite();
            boolean update = false;
            if (null != read) {
                action = read.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (null != write) {
                action = write.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (!update) continue;
            registryAccess.setOptEnable(true);
            ++count;
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> Update OpRegistryAccess[" + registryAccess.getName() + "] as enabled for rule:" + rule.getName() + ", id=" + rule.getId());
        }
        if (count > 0) {
            result = true;
        }
        return result;
    }

    private boolean processDisabledOpProcessAccessList(Map<Integer, OpProcessAccess> disabledOpProcessAccessList, OpAppRule rule) {
        boolean result = false;
        int count = 0;
        for (Map.Entry<Integer, OpProcessAccess> entry : disabledOpProcessAccessList.entrySet()) {
            OpAction action;
            OpProcessAccess processAccess = entry.getValue();
            OpCreateProcess create = processAccess.getOptOpCreateProcess();
            OpTerminateProcess terminate = processAccess.getOptOpTerminateProcess();
            boolean update = false;
            if (create != null) {
                action = create.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (terminate != null) {
                action = terminate.getOpAction();
                update = action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING);
            }
            if (!update) continue;
            processAccess.setOptEnable(true);
            ++count;
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> Update OpProcessAccess[" + processAccess.getName() + "] as enabled for rule:" + rule.getName() + ", id=" + rule.getId());
        }
        if (count > 0) {
            result = true;
        }
        return result;
    }

    private boolean processDisabledModuleAccessList(Map<Integer, OpModuleAccess> disabledOpModuleAccessList, OpAppRule rule) {
        boolean result = false;
        int count = 0;
        for (Map.Entry<Integer, OpModuleAccess> entry : disabledOpModuleAccessList.entrySet()) {
            OpAction action;
            OpModuleAccess moduleAccess = entry.getValue();
            OpLoadModule load = moduleAccess.getOptOpLoadModule();
            boolean update = false;
            if (load != null && ((action = load.getOpAction()).getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING))) {
                update = true;
            }
            if (!update) continue;
            moduleAccess.setOptEnable(true);
            ++count;
            System.out.println("SEPMigrationBlockDetector>>findMigrationADCRules>> Update OpModuleAccess[" + moduleAccess.getName() + "] as enabled for rule:" + rule.getName() + ", id=" + rule.getId());
        }
        if (count > 0) {
            result = true;
        }
        return result;
    }

    private boolean detectBlockActionFromFileAccess(OpFileAccess fileAccess) {
        OpAction action;
        boolean result = false;
        if (fileAccess == null) {
            return result;
        }
        OpFileRead read = fileAccess.getOptOpFileRead();
        OpFileWrite write = fileAccess.getOptOpFileWrite();
        if (null != read) {
            action = read.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromFileAccess>> Detect other actions value:" + action.getActionValue() + " from OpFileRead, this sub rule:" + fileAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        if (null != write) {
            action = write.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromFileAccess>> Detect other actions value:" + action.getActionValue() + " from OpFileWrite, this sub rule:" + fileAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        return result;
    }

    private boolean detectBlockActionFromRegistryAccess(OpRegistryAccess registryAccess) {
        OpAction action;
        boolean result = false;
        if (registryAccess == null) {
            return result;
        }
        OpRegistryRead read = registryAccess.getOptOpRegistryRead();
        OpRegistryWrite write = registryAccess.getOptOpRegistryWrite();
        if (null != read) {
            action = read.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromRegistryAccess>> Detect other actions value:" + action.getActionValue() + " from OpRegistryRead, this sub rule:" + registryAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        if (null != write) {
            action = write.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromRegistryAccess>> Detect other actions value:" + action.getActionValue() + " from OpRegistryWrite, this sub rule:" + registryAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                result = true;
            }
        }
        return result;
    }

    private boolean detectBlockActionFromProcessAccess(OpProcessAccess processAccess) {
        OpAction action;
        boolean result = false;
        if (processAccess == null) {
            return result;
        }
        OpCreateProcess create = processAccess.getOptOpCreateProcess();
        OpTerminateProcess terminate = processAccess.getOptOpTerminateProcess();
        if (create != null) {
            action = create.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromProcessAccess>> Detect other actions value:" + action.getActionValue() + " from OpCreateProcess, this sub rule:" + processAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        if (terminate != null) {
            action = terminate.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromProcessAccess>> Detect other actions value:" + action.getActionValue() + " from OpTerminateProcess, this sub rule:" + processAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        return result;
    }

    private boolean detectBlockActionFromModuleAccess(OpModuleAccess moduleAccess) {
        boolean result = false;
        if (moduleAccess == null) {
            return result;
        }
        OpLoadModule load = moduleAccess.getOptOpLoadModule();
        if (load != null) {
            OpAction action = load.getOpAction();
            if (action.getAction().equals(OpAction.ALLOW) || action.getAction().equals(OpAction.DONOTHING)) {
                result = false;
            } else {
                try {
                    System.out.println("SEPMigrationBlockDetector>>detectBlockActionFromModuleAccess>> Detect other actions value:" + action.getActionValue() + " from OpLoadModule, this sub rule:" + moduleAccess.getName());
                }
                catch (Exception e) {
                    LoggerUtilities.logException(e);
                }
                return true;
            }
        }
        return result;
    }

    public boolean addExclusions() {
        boolean added = false;
        if (this.needExclusionRuleListCache == null) {
            this.needExclusions();
        }
        for (OpAppRule rule : this.needExclusionRuleListCache) {
            added |= SEPMigrationProcessMatcher.addExclusionForSEPMigration(rule);
        }
        return added;
    }

    protected static ArrayList<OpAppRule> findSEPBlockRulesByName(ArrayList<OpAppProtectionBlock> rulesetList) {
        ArrayList<OpAppRule> ruleList = new ArrayList<OpAppRule>();
        if (rulesetList != null) {
            for (OpAppProtectionBlock ruleset : rulesetList) {
                for (OpAppRule rule : ruleset.getOpAppRule()) {
                    if (!AC1_RULE_PROTECT_SEP_FILE_REGISTRY.equalsIgnoreCase(rule.getName()) && !rule.getName().equalsIgnoreCase(SEPMigrationBlockDetector.getAC1ProProtectSEPFileRegI18nName())) continue;
                    ruleList.add(rule);
                }
            }
        }
        return ruleList;
    }

    protected static List<OpAppRule> findAllowClientProcessesRules(List<OpAppProtectionBlock> rulesetList) {
        ArrayList<OpAppRule> ruleList = new ArrayList<OpAppRule>();
        if (rulesetList != null) {
            for (OpAppProtectionBlock ruleset : rulesetList) {
                for (OpAppRule rule : ruleset.getOpAppRule()) {
                    if (!AC1_RULE_ALLOW_CLIENT_PROCESSES.equalsIgnoreCase(rule.getName()) && !rule.getName().equalsIgnoreCase(SEPMigrationBlockDetector.getAllowClientProcessesI18nName())) continue;
                    ruleList.add(rule);
                }
            }
        }
        return ruleList;
    }

    protected static String getAC1ProProtectSEPFileRegI18nName() {
        String i18n = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.DefaultSPlcyTp.OpAppRule.2.NAME$$");
        return i18n;
    }

    protected static String getAllowClientProcessesI18nName() {
        String i18n = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.DefaultSPlcyTp.OpAppRule.1.NAME$$");
        return i18n;
    }

    protected static ArrayList<OpAppRule> findSuspectedAC1Rules(ArrayList<OpAppProtectionBlock> allRulesets) {
        ArrayList<OpAppRule> suspsectedRuleList = new ArrayList<OpAppRule>();
        for (OpAppProtectionBlock ruleset : allRulesets) {
            for (OpAppRule rule : ruleset.getOpAppRule()) {
                boolean suspsected = false;
                if (rule.getOpPermissionList() == null) continue;
                for (OpFileAccess opFileAccess : rule.getOpPermissionList().getOpFileAccess()) {
                    if (!SEPMigrationFileMatcher.blockMatch(opFileAccess)) continue;
                    suspsected = true;
                    break;
                }
                if (!suspsected) {
                    for (OpRegistryAccess opRegistryAccess : rule.getOpPermissionList().getOpRegistryAccess()) {
                        if (!SEPMigrationRegMatcher.blockMatch(opRegistryAccess)) continue;
                        suspsected = true;
                        break;
                    }
                }
                if (!suspsected) continue;
                suspsectedRuleList.add(rule);
            }
        }
        return suspsectedRuleList;
    }
}

