/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.osprotect;

import com.sygate.scm.common.configobject.schema.EnforcedAppProtectionBlockArray;
import com.sygate.scm.common.configobject.schema.OpAppProtBlockEntity;
import com.sygate.scm.common.configobject.schema.OpAppProtectionBlock;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpAppRule;
import com.sygate.scm.common.configobject.schema.OpFileAccess;
import com.sygate.scm.common.configobject.schema.OpFileMatchEntity;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.configobject.schema.OpModuleAccess;
import com.sygate.scm.common.configobject.schema.OpModuleMatchEntity;
import com.sygate.scm.common.configobject.schema.OpProcess;
import com.sygate.scm.common.configobject.schema.OpProcessAccess;
import com.sygate.scm.common.configobject.schema.OpProcessMatchEntity;
import com.sygate.scm.common.configobject.schema.OpTargetFile;
import com.sygate.scm.common.configobject.schema.OpTargetModule;
import com.sygate.scm.common.configobject.schema.OpTargetProcess;
import com.sygate.scm.common.configobject.schema.ProcessImageMatch;
import com.sygate.scm.common.configobject.schema.ProcessImageNoMatch;
import com.sygate.scm.common.configobject.schema.TargetFileMatch;
import com.sygate.scm.common.configobject.schema.TargetFileNoMatch;
import com.sygate.scm.common.configobject.schema.TargetModuleMatch;
import com.sygate.scm.common.configobject.schema.TargetModuleNoMatch;
import com.sygate.scm.common.configobject.schema.TargetProcessMatch;
import com.sygate.scm.common.configobject.schema.TargetProcessNoMatch;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Vector;

public class SEP12SupportForADCPolicy {
    private static final String KEYSTRING_FORSEP12 = "#HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\services\\SysPlant\\SysFer\\SEPBaseDir#*\\*";
    private static final String KEYWORD_FORSEP11 = "smc_install_path";
    private static final String KEYWORD_FORSEP12 = "SEPBaseDir";
    private static final String PREFIX_FORSEP11 = "#HKEY_LOCAL_MACHINE\\SOFTWARE";
    private static final String PREFIX_FORSEP12 = "#HKEY_LOCAL_MACHINE\\SYSTEM";

    public static boolean upgradeOpAppProtectionPolicies(OpAppProtectionPolicy optPolicy) {
        boolean updatePolicy = false;
        if (null == optPolicy || null == optPolicy.getOptAppProtectionRuleSystem()) {
            return false;
        }
        EnforcedAppProtectionBlockArray array = optPolicy.getOptAppProtectionRuleSystem().getOptEnforcedAppProtectionBlockArray();
        if (array != null) {
            Vector<OpAppProtBlockEntity> allEntity = array.getOpAppProtBlockEntity();
            for (OpAppProtBlockEntity entity : allEntity) {
                OpAppProtectionBlock block = entity.getOptOpAppProtectionBlock();
                if (block == null) continue;
                Vector<OpAppRule> rules = block.getOpAppRule();
                for (OpAppRule rule : rules) {
                    boolean updateOpProcess = SEP12SupportForADCPolicy.fixOpProcess(rule);
                    if (null == rule.getOpPermissionList()) continue;
                    boolean updateOpFileAccess = SEP12SupportForADCPolicy.fixOpFileAccess(rule);
                    boolean updateOpProcessAccess = SEP12SupportForADCPolicy.fixOpProcessAccess(rule);
                    boolean updateOpModuleAccess = SEP12SupportForADCPolicy.fixOpModuleAccess(rule);
                    if (!updateOpProcess && !updateOpFileAccess && !updateOpProcessAccess && !updateOpModuleAccess) continue;
                    updatePolicy = true;
                }
            }
        }
        return updatePolicy;
    }

    private static boolean fixOpProcess(OpAppRule rule) {
        boolean existSmcInstallPath = false;
        boolean existSEPBaseDir = false;
        boolean updatePolicy = false;
        OpFileNameMatchEntity sep11OpFileNameMatchEntity = null;
        OpProcess opProcess = rule.getOpProcess();
        if (null != opProcess) {
            String keyStringForSep11;
            ProcessImageMatch optProcessImageMatch = opProcess.getOptProcessImageMatch();
            if (null != optProcessImageMatch) {
                Vector<OpProcessMatchEntity> entity1 = optProcessImageMatch.getOpProcessMatchEntity();
                for (OpProcessMatchEntity matchEntity : entity1) {
                    if (matchEntity.getOptOpFileNameMatchEntity() == null) continue;
                    keyStringForSep11 = matchEntity.getOptOpFileNameMatchEntity().getKeyString();
                    if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                        existSmcInstallPath = true;
                        sep11OpFileNameMatchEntity = matchEntity.getOptOpFileNameMatchEntity();
                    }
                    if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                    existSEPBaseDir = true;
                }
                if (existSmcInstallPath && !existSEPBaseDir) {
                    OpProcessMatchEntity matchEntity = new OpProcessMatchEntity();
                    OpFileNameMatchEntity fileNameMatchentity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
                    matchEntity.setOptOpFileNameMatchEntity(fileNameMatchentity);
                    optProcessImageMatch.addOpProcessMatchEntity(matchEntity);
                    updatePolicy = true;
                    System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpProcess->OptProcessImageMatch->OpProcessMatchEntity->OpFileNameMatchEntity of rule: " + rule.getName());
                }
            }
            existSmcInstallPath = false;
            existSEPBaseDir = false;
            ProcessImageNoMatch optProcessImageNoMatch = opProcess.getOptProcessImageNoMatch();
            if (null != optProcessImageNoMatch) {
                Vector<OpProcessMatchEntity> entity2 = optProcessImageNoMatch.getOpProcessMatchEntity();
                for (OpProcessMatchEntity matchEntity : entity2) {
                    if (matchEntity.getOptOpFileNameMatchEntity() == null) continue;
                    keyStringForSep11 = matchEntity.getOptOpFileNameMatchEntity().getKeyString();
                    if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                        existSmcInstallPath = true;
                        sep11OpFileNameMatchEntity = matchEntity.getOptOpFileNameMatchEntity();
                    }
                    if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                    existSEPBaseDir = true;
                }
                if (existSmcInstallPath && !existSEPBaseDir) {
                    OpProcessMatchEntity matchEntity;
                    matchEntity = new OpProcessMatchEntity();
                    OpFileNameMatchEntity fileNameMatchentity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
                    matchEntity.setOptOpFileNameMatchEntity(fileNameMatchentity);
                    optProcessImageNoMatch.addOpProcessMatchEntity(matchEntity);
                    updatePolicy = true;
                    System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpProcess->OptProcessImageNoMatch->OpProcessMatchEntity of rule: " + rule.getName());
                }
            }
        }
        return updatePolicy;
    }

    private static boolean fixOpFileAccess(OpAppRule rule) {
        Vector<OpFileAccess> listOfFileAccess = rule.getOpPermissionList().getOpFileAccess();
        boolean existSmcInstallPath = false;
        boolean existSEPBaseDir = false;
        boolean updatePolicy = false;
        OpFileNameMatchEntity sep11OpFileNameMatchEntity = null;
        OpTargetFile opTargetFile = null;
        for (OpFileAccess opFileAccess : listOfFileAccess) {
            TargetFileNoMatch targetNoMatch;
            String keyStringForSep11;
            opTargetFile = opFileAccess.getOpTargetFile();
            if (null == opTargetFile) continue;
            TargetFileMatch targetFileMatch = opTargetFile.getOptTargetFileMatch();
            if (null != targetFileMatch) {
                Vector<OpFileMatchEntity> listOfOpFileMatchEntity = targetFileMatch.getOpFileMatchEntity();
                for (OpFileMatchEntity opFileMatchEntity : listOfOpFileMatchEntity) {
                    if (null == opFileMatchEntity.getOptOpFileNameMatchEntity()) continue;
                    keyStringForSep11 = opFileMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                    if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                        existSmcInstallPath = true;
                        sep11OpFileNameMatchEntity = opFileMatchEntity.getOptOpFileNameMatchEntity();
                    }
                    if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                    existSEPBaseDir = true;
                }
                if (existSmcInstallPath && !existSEPBaseDir) {
                    OpFileMatchEntity matchEntity = new OpFileMatchEntity();
                    OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
                    matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
                    targetFileMatch.addOpFileMatchEntity(matchEntity);
                    existSmcInstallPath = false;
                    existSEPBaseDir = false;
                    updatePolicy = true;
                    System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpTargetFile->OptTargetFileMatch of rule: " + rule.getName());
                }
            }
            if (null == (targetNoMatch = opTargetFile.getOptTargetFileNoMatch())) continue;
            Vector<OpFileMatchEntity> listOfOpFileNoMatchEntity = targetNoMatch.getOpFileMatchEntity();
            for (OpFileMatchEntity opFileMatchEntity : listOfOpFileNoMatchEntity) {
                if (null == opFileMatchEntity.getOptOpFileNameMatchEntity()) continue;
                keyStringForSep11 = opFileMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                    existSmcInstallPath = true;
                    sep11OpFileNameMatchEntity = opFileMatchEntity.getOptOpFileNameMatchEntity();
                }
                if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                existSEPBaseDir = true;
            }
            if (!existSmcInstallPath || existSEPBaseDir) continue;
            OpFileMatchEntity matchEntity = new OpFileMatchEntity();
            OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
            matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
            targetNoMatch.addOpFileMatchEntity(matchEntity);
            existSmcInstallPath = false;
            existSEPBaseDir = false;
            updatePolicy = true;
            System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpTargetFile->OptTargetFileNoMatch of rule: " + rule.getName());
        }
        return updatePolicy;
    }

    private static boolean fixOpProcessAccess(OpAppRule rule) {
        Vector<OpProcessAccess> listOfOpProcessAccess = rule.getOpPermissionList().getOpProcessAccess();
        boolean existSmcInstallPath = false;
        boolean existSEPBaseDir = false;
        boolean updatePolicy = false;
        OpFileNameMatchEntity sep11OpFileNameMatchEntity = null;
        OpTargetProcess opTargetProcess = null;
        for (OpProcessAccess opProcessAccess : listOfOpProcessAccess) {
            TargetProcessNoMatch targetProcessNoMatch;
            String keyStringForSep11;
            opTargetProcess = opProcessAccess.getOpTargetProcess();
            if (null == opTargetProcess) continue;
            TargetProcessMatch targetProcessMatch = opTargetProcess.getOptTargetProcessMatch();
            if (null != targetProcessMatch) {
                Vector<OpProcessMatchEntity> listOfOpProcessMatchEntity = targetProcessMatch.getOpProcessMatchEntity();
                for (OpProcessMatchEntity opProcessMatchEntity : listOfOpProcessMatchEntity) {
                    if (null == opProcessMatchEntity.getOptOpFileNameMatchEntity()) continue;
                    keyStringForSep11 = opProcessMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                    if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                        existSmcInstallPath = true;
                        sep11OpFileNameMatchEntity = opProcessMatchEntity.getOptOpFileNameMatchEntity();
                    }
                    if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                    existSEPBaseDir = true;
                }
                if (existSmcInstallPath && !existSEPBaseDir) {
                    OpProcessMatchEntity matchEntity = new OpProcessMatchEntity();
                    OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
                    matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
                    targetProcessMatch.addOpProcessMatchEntity(matchEntity);
                    existSmcInstallPath = false;
                    existSEPBaseDir = false;
                    updatePolicy = true;
                    System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpTargetProcess->OptTargetProcessMatch of rule: " + rule.getName());
                }
            }
            if (null == (targetProcessNoMatch = opTargetProcess.getOptTargetProcessNoMatch())) continue;
            Vector<OpProcessMatchEntity> listOfOpProcessNoMatchEntity = targetProcessNoMatch.getOpProcessMatchEntity();
            for (OpProcessMatchEntity opProcessMatchEntity : listOfOpProcessNoMatchEntity) {
                if (null == opProcessMatchEntity.getOptOpFileNameMatchEntity()) continue;
                keyStringForSep11 = opProcessMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                    existSmcInstallPath = true;
                    sep11OpFileNameMatchEntity = opProcessMatchEntity.getOptOpFileNameMatchEntity();
                }
                if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                existSEPBaseDir = true;
            }
            if (!existSmcInstallPath || existSEPBaseDir) continue;
            OpProcessMatchEntity matchEntity = new OpProcessMatchEntity();
            OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
            matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
            targetProcessNoMatch.addOpProcessMatchEntity(matchEntity);
            existSmcInstallPath = false;
            existSEPBaseDir = false;
            updatePolicy = true;
            System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpTargetProcess->OptTargetProcessNoMatch of rule: " + rule.getName());
        }
        return updatePolicy;
    }

    private static boolean fixOpModuleAccess(OpAppRule rule) {
        Vector<OpModuleAccess> listOfOpModuleAccess = rule.getOpPermissionList().getOpModuleAccess();
        boolean existSmcInstallPath = false;
        boolean existSEPBaseDir = false;
        boolean updatePolicy = false;
        OpFileNameMatchEntity sep11OpFileNameMatchEntity = null;
        OpTargetModule opTargetModule = null;
        for (OpModuleAccess opModuleAccessObj : listOfOpModuleAccess) {
            TargetModuleNoMatch targetModuleNoMatch;
            String keyStringForSep11;
            opTargetModule = opModuleAccessObj.getOpTargetModule();
            if (null == opTargetModule) continue;
            TargetModuleMatch targetModuleMatch = opTargetModule.getOptTargetModuleMatch();
            if (null != targetModuleMatch) {
                Vector<OpModuleMatchEntity> listOfOpModuleMatchEntity = targetModuleMatch.getOpModuleMatchEntity();
                for (OpModuleMatchEntity opModuleMatchEntity : listOfOpModuleMatchEntity) {
                    if (null == opModuleMatchEntity.getOptOpFileNameMatchEntity()) continue;
                    keyStringForSep11 = opModuleMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                    if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                        existSmcInstallPath = true;
                        sep11OpFileNameMatchEntity = opModuleMatchEntity.getOptOpFileNameMatchEntity();
                    }
                    if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                    existSEPBaseDir = true;
                }
                if (existSmcInstallPath && !existSEPBaseDir) {
                    OpModuleMatchEntity matchEntity = new OpModuleMatchEntity();
                    OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
                    matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
                    targetModuleMatch.addOpModuleMatchEntity(matchEntity);
                    existSmcInstallPath = false;
                    existSEPBaseDir = false;
                    updatePolicy = true;
                    System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpModuleAccess->OpTargetModule->OptTargetModuleMatch of rule: " + rule.getName());
                }
            }
            if (null == (targetModuleNoMatch = opTargetModule.getOptTargetModuleNoMatch())) continue;
            Vector<OpModuleMatchEntity> listOfOpModuleMatchEntity = targetModuleNoMatch.getOpModuleMatchEntity();
            for (OpModuleMatchEntity opModuleMatchEntity : listOfOpModuleMatchEntity) {
                if (null == opModuleMatchEntity.getOptOpFileNameMatchEntity()) continue;
                keyStringForSep11 = opModuleMatchEntity.getOptOpFileNameMatchEntity().getKeyString();
                if (null != keyStringForSep11 && keyStringForSep11.startsWith(PREFIX_FORSEP11) && keyStringForSep11.indexOf(KEYWORD_FORSEP11) != -1) {
                    existSmcInstallPath = true;
                    sep11OpFileNameMatchEntity = opModuleMatchEntity.getOptOpFileNameMatchEntity();
                }
                if (null == keyStringForSep11 || !keyStringForSep11.startsWith(PREFIX_FORSEP12) || keyStringForSep11.indexOf(KEYWORD_FORSEP12) == -1) continue;
                existSEPBaseDir = true;
            }
            if (!existSmcInstallPath || existSEPBaseDir) continue;
            OpModuleMatchEntity matchEntity = new OpModuleMatchEntity();
            OpFileNameMatchEntity fileNameMatchEntity = SEP12SupportForADCPolicy.createOpFileNameMatchEntity(sep11OpFileNameMatchEntity);
            matchEntity.setOptOpFileNameMatchEntity(fileNameMatchEntity);
            targetModuleNoMatch.addOpModuleMatchEntity(matchEntity);
            existSmcInstallPath = false;
            existSEPBaseDir = false;
            updatePolicy = true;
            System.out.println("fixAppProtectPolicyForSEP11>> Add a match entity into OpPermissionList->OpModuleAccess->OpTargetModule->OptTargetModuleNoMatch of rule: " + rule.getName());
        }
        return updatePolicy;
    }

    private static OpFileNameMatchEntity createOpFileNameMatchEntity(OpFileNameMatchEntity sep11OpFileNameMatchEntity) {
        OpFileNameMatchEntity fileNameMatchentity = new OpFileNameMatchEntity();
        fileNameMatchentity.setKeyString(KEYSTRING_FORSEP12);
        fileNameMatchentity.setOptDriveTypes(sep11OpFileNameMatchEntity.getOptDriveTypes());
        fileNameMatchentity.setOptEnableDriveTypes(sep11OpFileNameMatchEntity.getOptEnableDriveTypes());
        fileNameMatchentity.setOptEnableDeviceClassTypes(sep11OpFileNameMatchEntity.getOptEnableDeviceClassTypes());
        fileNameMatchentity.setOptDeviceClassTypes(sep11OpFileNameMatchEntity.getOptDeviceClassTypes());
        fileNameMatchentity.setOptDeviceInstanceTypes(sep11OpFileNameMatchEntity.getOptDeviceInstanceTypes());
        fileNameMatchentity.setOptEnableDeviceInstanceTypes(sep11OpFileNameMatchEntity.getOptEnableDeviceInstanceTypes());
        fileNameMatchentity.setOptEnable(sep11OpFileNameMatchEntity.getOptEnable());
        fileNameMatchentity.setOptMethod(sep11OpFileNameMatchEntity.getOptMethod());
        fileNameMatchentity.setOptSearchSubdirectory(sep11OpFileNameMatchEntity.getOptSearchSubdirectory());
        try {
            fileNameMatchentity.setOptMethodValue(sep11OpFileNameMatchEntity.getOptMethodValue());
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
        return fileNameMatchentity;
    }
}

