/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.monitor;

import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorAgent {
    private static Logger logger = Logger.getLogger(MonitorAgent.class.getName());
    public static final String START_APPLICATION = "StartApplication";
    public static final String STOP_APPLICATION = "StopApplication";
    public static final String START_SCENARIO = "StartScenario";
    public static final String STOP_SCENARIO = "StopScenario";
    public static final String START_EVENT = "StartEvent";
    public static final String STOP_EVENT = "StopEvent";
    public static final String GENERATE_REPORT = "GenerateReport";
    public static final String SEPM_JAVA = "SEPM_Java";
    public static final String SEPM_PHP = "SEPM_Php";
    public static final String UI_REQUEST = "UIRequest";
    public static final String REQUEST_TO_SERVER = "RequestToServer";
    public static final String REQUEST_FROM_CLIENT = "RequestFromClient";
    public static final String DB_CONNECTION = "DBConnection";
    public static final String EXECUTE_QUERY = "ExecuteQuery";
    private static MonitorAgent thisInstance = null;
    private PrintWriter writer = null;
    private String machineName = null;
    private String component = null;
    boolean enableMonitor = false;
    private boolean initialize = false;
    private boolean ouImport = false;

    private MonitorAgent() {
    }

    public void initialize(boolean enableMonitor, String monitorServer, int monitorPort) {
        this.enableMonitor = enableMonitor;
        if (this.enableMonitor) {
            Socket socket = null;
            try {
                socket = new Socket(monitorServer, monitorPort);
                this.writer = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), true);
            }
            catch (UnknownHostException e) {
                LoggerUtilities.logException(e);
                this.enableMonitor = false;
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
                this.enableMonitor = false;
            }
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
                this.machineName = addr.getHostName();
            }
            catch (UnknownHostException e) {
                LoggerUtilities.logException(e);
            }
        }
        this.initialize = true;
    }

    public static synchronized MonitorAgent getInstance() {
        if (thisInstance == null) {
            thisInstance = new MonitorAgent();
        }
        return thisInstance;
    }

    public synchronized void startApplication(String application) {
        if (this.enableMonitor) {
            StringBuffer buf = new StringBuffer();
            buf.append(START_APPLICATION);
            buf.append(';');
            buf.append(application);
            buf.append(';');
            buf.append(System.nanoTime());
            buf.append(';');
            this.sendCommand(buf.toString());
        }
    }

    public synchronized void stopApplication(String application) {
        logger.log(Level.INFO, "stopApplication >> enableMonitor: {0}", this.enableMonitor);
        if (this.enableMonitor) {
            StringBuffer buf = new StringBuffer();
            buf.append(STOP_APPLICATION);
            buf.append(';');
            buf.append(application);
            buf.append(';');
            buf.append(System.nanoTime());
            buf.append(';');
            logger.log(Level.INFO, "stopApplication, command: {0}!", buf);
            this.sendCommand(buf.toString());
        }
        logger.log(Level.INFO, "stopApplication finished!");
    }

    public synchronized void startScenario(String scenario, String category) {
        if (this.enableMonitor) {
            StringBuffer buf = new StringBuffer();
            buf.append(START_SCENARIO);
            buf.append(';');
            buf.append(scenario);
            buf.append(';');
            buf.append(System.nanoTime());
            buf.append(';');
            buf.append(category);
            buf.append(';');
            this.sendCommand(buf.toString());
        }
    }

    public synchronized void stopScenario(String scenario) {
        if (this.enableMonitor) {
            StringBuffer buf = new StringBuffer();
            buf.append(STOP_SCENARIO);
            buf.append(';');
            buf.append(scenario);
            buf.append(';');
            buf.append(System.nanoTime());
            buf.append(';');
            this.sendCommand(buf.toString());
        }
    }

    public synchronized String startEvent(String eventName, String metadata) {
        String eventId = null;
        String thisThread = Thread.currentThread().getName() + "_" + Thread.currentThread().getId();
        if (this.enableMonitor) {
            eventId = Long.valueOf(System.nanoTime()).toString();
            StringBuffer cmdBuf = new StringBuffer();
            cmdBuf.append(START_EVENT);
            cmdBuf.append(';');
            cmdBuf.append(eventName);
            cmdBuf.append(';');
            cmdBuf.append(eventId);
            cmdBuf.append(';');
            cmdBuf.append(System.nanoTime());
            cmdBuf.append(';');
            cmdBuf.append(this.machineName);
            cmdBuf.append(';');
            cmdBuf.append(this.component);
            cmdBuf.append(';');
            cmdBuf.append(thisThread);
            cmdBuf.append(';');
            cmdBuf.append(this.getStackTrace());
            cmdBuf.append(';');
            if (metadata != null) {
                cmdBuf.append(metadata);
                cmdBuf.append(';');
            }
            this.sendCommand(cmdBuf.toString());
        }
        return eventId;
    }

    public synchronized void stopEvent(String eventId) {
        if (this.enableMonitor) {
            StringBuffer cmdBuf = new StringBuffer();
            cmdBuf.append(STOP_EVENT);
            cmdBuf.append(';');
            cmdBuf.append(eventId);
            cmdBuf.append(';');
            cmdBuf.append(System.nanoTime());
            cmdBuf.append(';');
            this.sendCommand(cmdBuf.toString());
        }
    }

    void sendCommand(String cmd) {
        try {
            try {
                if (this.writer != null) {
                    this.writer.println(cmd);
                    this.writer.flush();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOuImport() {
        return this.ouImport;
    }

    public void setOuImport(boolean ouImport) {
        this.ouImport = ouImport;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        if (this.component == null) {
            this.component = component;
        }
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getStackTrace() {
        StringBuffer stackTrace = new StringBuffer();
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elems = e.getStackTrace();
            for (int i = 0; i < elems.length; ++i) {
                stackTrace.append(elems[i]);
                stackTrace.append("<-");
            }
            return stackTrace.toString();
        }
    }
}

