/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.logicalobject;

import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.util.AutoUpgradeUtils;

public class AutoUpgradePFL {
    String productType;
    String platform;
    String language;

    public static AutoUpgradePFL getPFL(SoftwarePackage sp) {
        String productType = AutoUpgradeUtils.getPackageClientTypeValue(sp);
        String platform = sp.getPackageInfo().getOptPlatformType();
        String language = sp.getPackageInfo().getOptPackageLuInfo().getServerLanguage();
        return new AutoUpgradePFL(productType, platform, language);
    }

    public AutoUpgradePFL(String productType, String platform, String language) {
        this.productType = productType;
        this.platform = platform;
        this.language = language;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AutoUpgradePFL)) {
            return false;
        }
        AutoUpgradePFL spt = (AutoUpgradePFL)obj;
        return this.getUniqueSeed().equalsIgnoreCase(spt.getUniqueSeed());
    }

    public int hashCode() {
        return this.getUniqueSeed().hashCode();
    }

    public String toString() {
        return "PFL[" + this.productType + "," + this.platform + "," + this.language + "]";
    }

    public String getProductType() {
        return this.productType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getLanguage() {
        return this.language;
    }

    private String getUniqueSeed() {
        return this.productType + "_" + this.platform + "_" + this.language;
    }
}

