/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.log;

import com.sygate.scm.common.i18n.MessageResources;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;

public class LogSeverityDescription {
    private static final HashMap<Integer, String> agentSecurityMap = new HashMap();
    private static final HashMap<Integer, String> agentSystemMap = new HashMap();
    private static final HashMap<Integer, String> agentTrafficMap = new HashMap();
    private static final HashMap<Integer, String> agentBehaviorMap = new HashMap();
    private static final HashMap<Integer, String> serverMap = new HashMap();
    private static final HashMap<Integer, String> enforcerSystemMap = new HashMap();

    public static synchronized void setLocale(Locale l) {
        LogSeverityDescription.newAgentSecurityInstance(l);
        LogSeverityDescription.newAgentSystemInstance(l);
        LogSeverityDescription.newAgentTrafficInstance(l);
        LogSeverityDescription.newAgentBehaviorInstance(l);
        LogSeverityDescription.newServerInstance(l);
        LogSeverityDescription.newEnforcerSystemInstance(l);
    }

    public static synchronized String getDescription(String logType, Integer id) {
        if (logType == null || id == null) {
            return null;
        }
        String desc = null;
        if (logType.equals("AgentSecurityLog")) {
            desc = agentSecurityMap.get(id);
        } else if (logType.equals("AgentSystemLog")) {
            desc = agentSystemMap.get(id);
        } else if (logType.equals("AgentTrafficLog")) {
            desc = agentTrafficMap.get(id);
        } else if (logType.equals("AgentBehaviorLog")) {
            desc = agentBehaviorMap.get(id);
        }
        if (logType.equals("ServerAdminLog") || logType.equals("ServerSystemLog")) {
            desc = serverMap.get(id);
        }
        if (logType.equals("EnforcerSystemLog")) {
            desc = enforcerSystemMap.get(id);
        }
        if (desc == null) {
            desc = id.toString();
        }
        return desc;
    }

    private static synchronized void newAgentSecurityInstance(Locale l) {
        agentSecurityMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Critical"));
        agentSecurityMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Critical"));
        agentSecurityMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Critical"));
        agentSecurityMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Critical"));
        agentSecurityMap.put(4, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Major"));
        agentSecurityMap.put(5, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Major"));
        agentSecurityMap.put(6, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Major"));
        agentSecurityMap.put(7, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Major"));
        agentSecurityMap.put(8, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Minor"));
        agentSecurityMap.put(9, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Minor"));
        agentSecurityMap.put(10, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Minor"));
        agentSecurityMap.put(11, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Minor"));
        agentSecurityMap.put(12, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Info"));
        agentSecurityMap.put(13, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Info"));
        agentSecurityMap.put(14, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Info"));
        agentSecurityMap.put(15, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSecuritySeverityDescription_en_US.Info"));
    }

    private static synchronized void newAgentSystemInstance(Locale l) {
        agentSystemMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSystemSeverityDescription_en_US.Info"));
        agentSystemMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSystemSeverityDescription_en_US.Warning"));
        agentSystemMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSystemSeverityDescription_en_US.Error"));
        agentSystemMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentSystemSeverityDescription_en_US.Fatal"));
    }

    private static synchronized void newAgentTrafficInstance(Locale l) {
        agentTrafficMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Critical"));
        agentTrafficMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Critical"));
        agentTrafficMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Critical"));
        agentTrafficMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Critical"));
        agentTrafficMap.put(4, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Major"));
        agentTrafficMap.put(5, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Major"));
        agentTrafficMap.put(6, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Major"));
        agentTrafficMap.put(7, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Major"));
        agentTrafficMap.put(8, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Minor"));
        agentTrafficMap.put(9, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Minor"));
        agentTrafficMap.put(10, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Minor"));
        agentTrafficMap.put(11, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Minor"));
        agentTrafficMap.put(12, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Info"));
        agentTrafficMap.put(13, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Info"));
        agentTrafficMap.put(14, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Info"));
        agentTrafficMap.put(15, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentTrafficSeverityDescription_en_US.Info"));
    }

    private static synchronized void newAgentBehaviorInstance(Locale l) {
        agentBehaviorMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Critical"));
        agentBehaviorMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Critical"));
        agentBehaviorMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Critical"));
        agentBehaviorMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Critical"));
        agentBehaviorMap.put(4, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Major"));
        agentBehaviorMap.put(5, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Major"));
        agentBehaviorMap.put(6, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Major"));
        agentBehaviorMap.put(7, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Major"));
        agentBehaviorMap.put(8, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Minor"));
        agentBehaviorMap.put(9, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Minor"));
        agentBehaviorMap.put(10, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Minor"));
        agentBehaviorMap.put(11, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Minor"));
        agentBehaviorMap.put(12, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Info"));
        agentBehaviorMap.put(13, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Info"));
        agentBehaviorMap.put(14, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Info"));
        agentBehaviorMap.put(15, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentBehaviorSeverityDescription_en_US.Info"));
    }

    private static synchronized void newServerInstance(Locale l) {
        serverMap.put(Level.SEVERE.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Error"));
        serverMap.put(Level.WARNING.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Warning"));
        serverMap.put(Level.INFO.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Info"));
        serverMap.put(Level.CONFIG.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Info"));
        serverMap.put(Level.FINE.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Info"));
        serverMap.put(Level.FINER.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Info"));
        serverMap.put(Level.FINEST.intValue(), MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "ServerSeverityDescription_en_US.Info"));
    }

    private static synchronized void newEnforcerSystemInstance(Locale l) {
        enforcerSystemMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerSystemSeverityDescription_en_US.Info"));
        enforcerSystemMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerSystemSeverityDescription_en_US.Warning"));
        enforcerSystemMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerSystemSeverityDescription_en_US.Error"));
        enforcerSystemMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerSystemSeverityDescription_en_US.Fatal"));
    }

    static {
        LogSeverityDescription.setLocale(Locale.getDefault());
    }
}

