/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.log;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashSet;

public class LogCategoryDescription {
    private static final MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.common.log.log");
    private static final String URL_HID_LEVEL_PREF = "AgentSecurityCategoryDescription.UrlHidLevel";
    private static final String URL_RISK_SCORE_PREF = "AgentSecurityCategoryDescription.UrlRiskScore";
    private static final String URL_CATEGORY_PREF = "AgentSecurityCategoryDescription.UrlCategory";

    public static String getDescription(String key) {
        String desc = "";
        try {
            if (key != null) {
                desc = res.getString(key.trim());
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return desc;
    }

    public static String getUrlHidLevelDescription(Integer id) {
        return LogCategoryDescription.getDescription(URL_HID_LEVEL_PREF + (id != null ? id : 0));
    }

    public static String getUrlRiskScoreDescription(Integer id) {
        return LogCategoryDescription.getDescription(URL_RISK_SCORE_PREF + (id != null ? id : 0));
    }

    public static String getUrlCategoryDescription(String idList) {
        if (idList == null || idList.isEmpty()) {
            idList = "NotApplicable";
        }
        String[] ids = idList.split(",");
        HashSet<String> values = new HashSet<String>();
        for (String id : ids) {
            String value = LogCategoryDescription.getDescription(URL_CATEGORY_PREF + id.trim());
            if (value == null || value.isEmpty()) continue;
            values.add(value);
        }
        return String.join((CharSequence)", ", values);
    }
}

