/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.log;

import com.sygate.scm.common.i18n.MessageResources;
import java.util.HashMap;
import java.util.Locale;

public class LogActionDescription {
    private static final HashMap<Integer, String> agentActionMap = new HashMap();
    private static final HashMap<Integer, String> enforcerActionMap = new HashMap();

    public static synchronized void setLocale(Locale l) {
        LogActionDescription.newAgentActionInstance(l);
        LogActionDescription.newEnforcerActionInstance(l);
    }

    public static synchronized String getDescription(boolean isAgentEvent, Integer id) {
        if (id == null) {
            return null;
        }
        String desc = null;
        desc = isAgentEvent ? agentActionMap.get(id) : enforcerActionMap.get(id);
        if (desc == null) {
            desc = id.toString();
        }
        return desc;
    }

    private static synchronized void newAgentActionInstance(Locale l) {
        agentActionMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentActionDescription_en_US.Allowed"));
        agentActionMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentActionDescription_en_US.Blocked"));
        agentActionMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentActionDescription_en_US.Ask"));
        agentActionMap.put(3, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentActionDescription_en_US.Continue"));
        agentActionMap.put(4, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "AgentActionDescription_en_US.Terminated"));
    }

    private static synchronized void newEnforcerActionInstance(Locale l) {
        enforcerActionMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerActionDescription_en_US.Blocked"));
        enforcerActionMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "EnforcerActionDescription_en_US.Allowed"));
    }

    static {
        LogActionDescription.setLocale(Locale.getDefault());
    }
}

