/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.license;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.util.CollectionUtils;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class MultiYearLicenseUtils {
    private static MultiYearLicenseUtils singleton = new MultiYearLicenseUtils();

    private MultiYearLicenseUtils() {
    }

    public static MultiYearLicenseUtils getInstance() {
        return singleton;
    }

    public List<LicenseChain> getMultiYearLicenses(Vector<LicenseChain> existedChains, LicenseChain newLicChain) throws Exception {
        return this.extractOrderLiceses(this.getValidChains(existedChains), newLicChain);
    }

    public List<LicenseChain> extractOrderLiceses(Vector<LicenseChain> chains, LicenseChain newLicense) throws Exception {
        ArrayList<LicenseChain> orderLicenses = new ArrayList<LicenseChain>();
        for (LicenseChain tmpChain : this.getSortedChain(chains)) {
            if (!this.isRelated(tmpChain.getElsLicense(0), newLicense.getElsLicense(0))) continue;
            orderLicenses.add(tmpChain);
            LicenseChain matched = this.getMatchedLicenseChain(chains, newLicense);
            orderLicenses.add(matched == null ? newLicense : matched);
            break;
        }
        return this.getSortedChain(orderLicenses);
    }

    public Vector<LicenseChain> getValidChains(Vector<LicenseChain> licenseChains) {
        Vector<LicenseChain> newChains = new Vector<LicenseChain>();
        for (int i = 0; i < licenseChains.size(); ++i) {
            LicenseChain chain = licenseChains.get(i);
            if (chain == null || !(chain.getOptSuspended() != null ? chain.getOptSuspended() == false : chain.getDefSuspended() == false)) continue;
            newChains.add(chain);
        }
        return newChains;
    }

    public boolean isRelated(ElsLicense oldLicense, ElsLicense newLicense) {
        if (oldLicense == null || newLicense == null) {
            return false;
        }
        if (oldLicense == newLicense || StringUtilities.isEqual(oldLicense.getId(), newLicense.getId())) {
            return false;
        }
        if (!MultiYearLicenseUtils.isEqual(oldLicense.getOptStartDateString(), newLicense.getOptStartDateString())) {
            return false;
        }
        if (MultiYearLicenseUtils.isEqual(oldLicense.getOptEndDateString(), newLicense.getOptEndDateString())) {
            return false;
        }
        if (!MultiYearLicenseUtils.isEqual(oldLicense.getOptMeterCount(), newLicense.getOptMeterCount())) {
            return false;
        }
        if (!MultiYearLicenseUtils.isEqual(oldLicense.getOptProductType(), newLicense.getOptProductType())) {
            return false;
        }
        try {
            if (!MultiYearLicenseUtils.isEqual(oldLicense.getOptClientProductTypeValue(), newLicense.getOptClientProductTypeValue())) {
                return false;
            }
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    public Vector<LicenseChain> getMergedChainsByProcessByRow(Vector<LicenseChain> licensesInRoot, List<LicenseChain> newLicenses) {
        List<LicenseChain> sortedNewLicenses = this.getSortedChain(newLicenses);
        Vector<LicenseChain> sortedResultChains = this.getSortedChain(licensesInRoot);
        try {
            for (int i = 0; sortedNewLicenses != null && i < sortedNewLicenses.size(); ++i) {
                List<LicenseChain> relatedChains = this.extractOrderLiceses(sortedResultChains, sortedNewLicenses.get(i));
                if (relatedChains.size() > 1) {
                    sortedResultChains.add(relatedChains.get(1));
                    LicenseChain matchedChain = this.getMatchedLicenseChain(sortedResultChains, relatedChains.get(0));
                    if (matchedChain != null) {
                        sortedResultChains.remove(matchedChain);
                    }
                } else {
                    sortedResultChains.add(sortedNewLicenses.get(i));
                }
                sortedResultChains = this.getSortedChain(sortedResultChains);
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
        return sortedResultChains;
    }

    public int getSEPSeats(List<LicenseChain> licenses) {
        int count = 0;
        for (LicenseChain l : licenses) {
            Boolean suspended = l.getOptSuspended();
            if (suspended == null) {
                suspended = l.getDefSuspended();
            }
            if (suspended.booleanValue() || !MultiYearLicenseUtils.isSEPLicense(l.getElsLicense(0))) continue;
            count += l.getOptMeterCount().intValue();
        }
        return count;
    }

    public int getSNACSeats(List<LicenseChain> licenses) {
        int count = 0;
        for (LicenseChain l : licenses) {
            Boolean suspended = l.getOptSuspended();
            if (suspended == null) {
                suspended = l.getDefSuspended();
            }
            if (suspended.booleanValue() || !MultiYearLicenseUtils.isSNACLicense(l.getElsLicense(0))) continue;
            count += l.getOptMeterCount().intValue();
        }
        return count;
    }

    static boolean isSEPLicense(ElsLicense elsLicense) {
        if (elsLicense == null) {
            return false;
        }
        try {
            return "SEP".equalsIgnoreCase(elsLicense.getOptClientProductTypeValue());
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            return true;
        }
    }

    static boolean isSNACLicense(ElsLicense elsLicense) {
        return !MultiYearLicenseUtils.isSEPLicense(elsLicense);
    }

    static boolean isEqual(String s1, String s2) {
        if (StringUtilities.isEmpty(s1) || StringUtilities.isEmpty(s2)) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean isEqual(Integer s1, Integer s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public void createSerialNumberAssociation(List<LicenseChain> orderLicenses) {
        if (CollectionUtils.isNullOrEmpty(orderLicenses)) {
            return;
        }
        int size = orderLicenses.size();
        LicenseChain longestLicense = orderLicenses.get(size - 1);
        TreeSet<String> associatedLicenseSet = new TreeSet<String>();
        ElsLicense longestEls = longestLicense.getElsLicense(0);
        String longestElsSN = longestEls.getOptSerialNumber();
        if (longestEls.getOptAssociatedLicenses() != null) {
            StringTokenizer tokenizer = new StringTokenizer(longestEls.getOptAssociatedLicenses(), ",");
            while (tokenizer.hasMoreTokens()) {
                associatedLicenseSet.add(tokenizer.nextToken());
            }
        }
        for (int i = 0; i < size - 1; ++i) {
            ElsLicense els = orderLicenses.get(i).getElsLicense(0);
            if (els.getOptAssociatedLicenses() != null) {
                StringTokenizer tokenizer = new StringTokenizer(els.getOptAssociatedLicenses(), ",");
                while (tokenizer.hasMoreTokens()) {
                    associatedLicenseSet.add(tokenizer.nextToken());
                }
            }
            associatedLicenseSet.add(els.getOptSerialNumber());
            els.setOptAssociatedLicenses(null);
        }
        Iterator itr = associatedLicenseSet.iterator();
        StringBuffer associatedLicenseBuffer = new StringBuffer();
        while (itr.hasNext()) {
            String associatedSN = (String)itr.next();
            if (associatedSN.equals(longestElsSN)) continue;
            if (associatedLicenseBuffer.length() > 0) {
                associatedLicenseBuffer.append(",");
            }
            associatedLicenseBuffer.append(associatedSN);
        }
        longestEls.setOptAssociatedLicenses(associatedLicenseBuffer.toString());
    }

    private Comparator<LicenseChain> getLicenseChainComparator() {
        Comparator<LicenseChain> comp = new Comparator<LicenseChain>(){

            @Override
            public int compare(LicenseChain obj1, LicenseChain obj2) {
                if (obj1 != null && obj1.getElsLicense(0) != null && obj1.getElsLicense(0).getOptEndDateString() != null && obj2 != null && obj2.getElsLicense(0) != null && obj2.getElsLicense(0).getOptEndDateString() != null) {
                    return obj1.getElsLicense(0).getOptEndDateString().compareTo(obj2.getElsLicense(0).getOptEndDateString());
                }
                return 0;
            }
        };
        return comp;
    }

    private List<LicenseChain> getSortedChain(List<LicenseChain> chains) {
        ArrayList<LicenseChain> sortedChain = new ArrayList<LicenseChain>();
        sortedChain.addAll(chains);
        Collections.sort(sortedChain, this.getLicenseChainComparator());
        return sortedChain;
    }

    private Vector<LicenseChain> getSortedChain(Vector<LicenseChain> chains) {
        Vector<LicenseChain> sortedChain = new Vector<LicenseChain>();
        sortedChain.addAll(chains);
        Collections.sort(sortedChain, this.getLicenseChainComparator());
        return sortedChain;
    }

    private LicenseChain getMatchedLicenseChain(Vector<LicenseChain> chains, LicenseChain newLicense) {
        LicenseChain matchedChain = null;
        if (chains != null && newLicense != null && newLicense.getElsLicense(0) != null && newLicense.getElsLicense(0).getId() != null) {
            for (int i = 0; i < chains.size(); ++i) {
                if (chains.get(i) == null || chains.get(i).getElsLicense(0) == null || !newLicense.getElsLicense(0).getId().equals(chains.get(i).getElsLicense(0).getId())) continue;
                matchedChain = chains.get(i);
            }
        }
        return matchedChain;
    }
}

