/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.license;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.License;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.OverdeployedLicense;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.TrialwareLicense;
import com.sygate.scm.common.configobject.schema.UpgradeLicense;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.license.LicenseFileHelper;
import com.sygate.scm.common.util.DateTimeManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.symantec.slic.LicenseIterator;
import com.symantec.slic.LicenseManager;
import com.symantec.slic.SlicException;
import com.symantec.slic.ipl.CityError;
import com.symantec.slic.ipl.CompanyInfo;
import com.symantec.slic.ipl.CompanyNameError;
import com.symantec.slic.ipl.ContactName;
import com.symantec.slic.ipl.ContactNameError;
import com.symantec.slic.ipl.CountryError;
import com.symantec.slic.ipl.EmailAddressError;
import com.symantec.slic.ipl.MailingAddress;
import com.symantec.slic.ipl.MailingAddressError;
import com.symantec.slic.ipl.PhoneNumberError;
import com.symantec.slic.ipl.PostalCodeError;
import com.symantec.slic.ipl.SerialNumberError;
import com.symantec.slic.ipl.StateOrProvinceError;
import com.symantec.slic.ipl.StreetAddress;
import com.symantec.slic.ipl.StreetAddressError;
import com.symantec.slic.ipl.TechnicalContactInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class LicenseUtils {
    public static final String SLIC_LICENSE_FEATURE_SEP = "scs_content";
    public static final String SLIC_LICENSE_FEATURE_SNAC = "snac";
    public static final String READABLE_LICENSE_FILE_POSTFIX = "_text";
    public static final String SLIC_START_DATE = "start_date";
    public static final String SLIC_END_DATE = "end_date";
    public static final String SLIC_VERSION = "version";
    public static final String SLIC_NAME = "name";
    public static final String SLIC_KEY = "key";
    public static final String SLIC_LICENSE = "license";
    public static final String SLIC_LICENSES = "licenses";
    public static final String SLIC_TRIAL = "trial";
    public static final String SLIC_OPTION_COUNT = "count";
    public static final String SLIC_OPTION_GRACE_PCT = "grace_count_pct";
    public static final String SLIC_OPTION_GRACE_POLICY = "grace_policy";
    public static final String SLIC_OPTION_WARN_POLICY = "warn_policy";
    public static final String SLIC_OPTION_PRODUCT_CODE = "product_code";
    public static final String SLIC_OPTION_PRODUCT_NAME = "product_name";
    public static final String SLIC_OPTION_SERIAL_ID = "serial_id";
    public static final String SLIC_OPTION_SERIAL_NUMBER = "serial_number";
    public static final String SLIC_OPTION_FULFILLMENT_ID = "fulfillment_id";
    public static final String SLIC_OPTION_VERSION = "version";
    private static final long LICENSE_DATE_ALIGNMENT_SLACK = 432000000L;
    public static final String SLIC_OPTION_LICENSE_CATEGORY = "license_category";
    public static final String SLIC_OPTION_VALID_DAYS = "valid_days";
    public static final String PRODUCT_CODE_PREFIX_SEPSB = "sepsb_";
    public static final String PRODUCT_CODE_PREFIX_SEPE = "sepe_";
    public static final int LICENSE_FILE_COUNT = 2;
    public static final int TRIAL_LICENSE_CATEGORY = 1;
    public static final int UPGRADE_LICENSE_CATEGORY = 2;
    public static final int NE_LICENSE_CATEGORY = 3;
    public static final int OD_LICENSE_CATEGORY = 4;
    public static final int PAID_LICENSE_CATEGORY = 5;
    public static final int PAID_AWS_LICENSE_CATEGORY = 6;
    private static final long MILLI_SEC_PER_DAY = 86400000L;

    public static boolean isLicenseInstallationValid() throws Exception {
        String licensePath = LicenseFileHelper.getLicensePath();
        ArrayList<String> slfFilesList = new ArrayList<String>();
        slfFilesList.add("sep.slf");
        slfFilesList.add("sep_od.slf");
        String productCodePrefix = null;
        boolean odFileFound = false;
        boolean sepFileFound = false;
        try {
            for (int i = 0; i < slfFilesList.size(); ++i) {
                String licenseFile = (String)slfFilesList.get(i);
                String contents = LicenseFileHelper.getFileContents(licensePath + File.separator + licenseFile);
                LicenseIterator itr = new LicenseIterator(contents);
                com.symantec.slic.License lic = itr.next();
                String productCode = lic.getNamedOption(SLIC_OPTION_PRODUCT_CODE);
                if (productCodePrefix == null) {
                    productCodePrefix = productCode.substring(0, productCode.indexOf(95));
                } else if (!productCode.toUpperCase().startsWith(productCodePrefix.toUpperCase())) {
                    System.out.println("LicenseUtils> isLicenseInstallationValid>> Product code in " + licenseFile + " is " + productCode + ". Expected to start with " + productCodePrefix);
                    break;
                }
                if (licenseFile.equalsIgnoreCase("sep.slf")) {
                    if (lic.isTrialware() || LicenseUtils.isUpgradeLicense(contents)) {
                        sepFileFound = true;
                        continue;
                    }
                    System.out.println("LicenseUtils> isLicenseInstallationValid>> Invalid Trial license or Upgrade License.");
                    continue;
                }
                if (!licenseFile.equalsIgnoreCase("sep_od.slf")) continue;
                if (LicenseUtils.isODLicense(contents)) {
                    odFileFound = true;
                    continue;
                }
                System.out.println("LicenseUtils> isLicenseInstallationValid>> Invalid OD license.");
            }
        }
        catch (Exception se) {
            System.err.println("LicenseUtils> isLicenseInstallationValid>> Exception: " + se.getMessage());
            LoggerUtilities.logException(se);
        }
        System.out.println("LicenseUtils> isLicenseInstallationValid>> sep.slf =" + String.valueOf(sepFileFound) + "  OD file=" + String.valueOf(odFileFound));
        return sepFileFound && odFileFound;
    }

    private static String getProductCode() {
        try {
            String contents;
            String trialWareFile;
            if (LicenseUtils.isLicenseInstallationValid() && (trialWareFile = LicenseFileHelper.getTrialwareFileName()) != null && (contents = LicenseFileHelper.getFileContents(trialWareFile)) != null) {
                LicenseIterator itr = new LicenseIterator(contents);
                com.symantec.slic.License lic = itr.next();
                return lic.getNamedOption(SLIC_OPTION_PRODUCT_CODE);
            }
        }
        catch (Exception se) {
            LoggerUtilities.logException(se);
        }
        return "UNKNOWN";
    }

    public static String getProductType() {
        try {
            String productCode = LicenseUtils.getProductCode();
            if (!productCode.equals("UNKNOWN")) {
                return LicenseUtils.getProductType(productCode);
            }
        }
        catch (Exception se) {
            System.err.println("LicenseUtils> getProductType>> Exception: " + se.getMessage());
            LoggerUtilities.logException(se);
        }
        return "UNKNOWN";
    }

    public static String activateTrialwareLicense() throws Exception {
        String trialWareFile = LicenseFileHelper.getTrialwareFileName();
        if (!LicenseUtils.isLicenseActivated(trialWareFile)) {
            String contents = LicenseFileHelper.getFileContents(trialWareFile);
            if (contents == null) {
                throw new Exception("file " + trialWareFile + " contents is null");
            }
            if (!LicenseUtils.isTrialwareLicense(contents)) {
                throw new Exception("file " + trialWareFile + " is not a trialware file");
            }
            String activatedLicense = LicenseUtils.activateFlexStartLicense(contents);
            if (activatedLicense == null) {
                throw new Exception("activatedLicense file contents is null");
            }
            LicenseFileHelper.writeFileContents(trialWareFile, activatedLicense);
            System.out.println("Activated Trialware");
            return activatedLicense;
        }
        System.out.println("Trialware already activated. Returning");
        return null;
    }

    public static void cleanPulblishedLocalLicenseFile(Connection conn, String outputLicenseFolder) {
        System.out.println("Starting clean pulblished local license files");
        if (outputLicenseFolder == null) {
            System.out.println("Starting pulblished path is null");
            return;
        }
        try {
            SemConfigRoot root = LicenseUtils.querySemConfigRoot(conn);
            if (root != null) {
                File[] fileList;
                ArrayList<String> usingLicenseFileNamesList = LicenseUtils.retriveUsingLicensesNames(root);
                File licenseFolder = new File(outputLicenseFolder);
                if (licenseFolder.exists() && (fileList = licenseFolder.listFiles()) != null) {
                    int fileListSize = fileList.length;
                    for (int i = 0; i < fileListSize; ++i) {
                        String fileName = fileList[i].getName();
                        if (!fileName.endsWith(".slf") || LicenseUtils.isLicenseFileNameInUsing(usingLicenseFileNamesList, fileName) || !fileList[i].delete()) continue;
                        System.out.println(" cleanLocalSEPFile: " + fileList[i].getAbsolutePath() + " deleted");
                    }
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        System.out.println("Finished clean pulblished local  license files");
    }

    private static boolean isLicenseFileNameInUsing(ArrayList<String> usingLicenseFileNamesList, String targetFileName) {
        for (int i = 0; i < usingLicenseFileNamesList.size(); ++i) {
            String name = usingLicenseFileNamesList.get(i);
            if (!name.equalsIgnoreCase(targetFileName)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<String> retriveUsingLicensesNames(SemConfigRoot root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root != null) {
            License lic = root.getLicense();
            if (lic.getOptOverdeployedLicense() != null) {
                list.add(lic.getOptOverdeployedLicense().getId());
            }
            if (lic.getOptTrialwareLicense() != null) {
                list.add(lic.getOptTrialwareLicense().getId());
                list.add(lic.getOptTrialwareLicense().getId() + READABLE_LICENSE_FILE_POSTFIX);
            }
            if (lic.getOptUpgradeLicense() != null) {
                list.add(lic.getOptUpgradeLicense().getId());
                list.add(lic.getOptUpgradeLicense().getId() + READABLE_LICENSE_FILE_POSTFIX);
            }
            for (LicenseChain chain : lic.getLicenseChain()) {
                if (chain == null) continue;
                list.add(chain.getId());
            }
            ArrayList<LicenseChain> deltedChains = LicenseUtils.getDeletedLicenseChains(root);
            for (LicenseChain chain : deltedChains) {
                if (!list.contains(chain.getId())) continue;
                list.remove(chain.getId());
            }
        }
        ArrayList<String> usingLicenseName = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            usingLicenseName.add((String)list.get(i) + ".slf");
        }
        usingLicenseName.add("sep.slf");
        usingLicenseName.add("snac.slf");
        return usingLicenseName;
    }

    public static boolean updateLocalSEPFile(Connection conn) {
        System.out.println("Starting update sep.slf in local file system when replication configurated or add additional server");
        boolean localLicenseFileUpdated = false;
        try {
            SemConfigRoot root = LicenseUtils.querySemConfigRoot(conn);
            if (root != null) {
                License lic = root.getLicense();
                if (License.SEPE_UPGRADE.equals(lic.getOptLicenseState())) {
                    System.out.println("the license value in SemConfigRoot.license is " + lic.getOptLicenseStateValue());
                    UpgradeLicense updLic = lic.getOptUpgradeLicense();
                    if (updLic != null && updLic.getOptSuspended() != null && !updLic.getOptSuspended().booleanValue()) {
                        System.out.println("Writing upgrade license");
                        LicenseFileHelper.writeFileContents(LicenseFileHelper.getLicensePath() + File.separator + "sep.slf", updLic.getContent());
                        localLicenseFileUpdated = true;
                        System.out.println("Writing update license done!");
                    }
                }
                if (!localLicenseFileUpdated) {
                    System.out.println("start write trial license");
                    TrialwareLicense trialLic = lic.getOptTrialwareLicense();
                    if (trialLic != null && (trialLic.getOptSuspended() != null ? trialLic.getOptSuspended() == false : trialLic.getDefSuspended() == false)) {
                        System.out.println("Writing trial license");
                        LicenseFileHelper.writeFileContents(LicenseFileHelper.getLicensePath() + File.separator + "sep.slf", trialLic.getContent());
                        localLicenseFileUpdated = true;
                        System.out.println("Writing trial license done!");
                    }
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return localLicenseFileUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SemConfigRoot querySemConfigRoot(Connection conn) throws SQLException, SAXException, IOException, ValidationException {
        SemConfigRoot configRoot;
        PreparedStatement stmt = null;
        InputStream is = null;
        ResultSet rs = null;
        try {
            String sqlStr = "SELECT CONTENT FROM BASIC_METADATA WHERE ID =?";
            stmt = conn.prepareStatement(sqlStr);
            stmt.setString(1, "B655E64D0A320801000000E164041B79");
            rs = stmt.executeQuery();
            rs.next();
            is = rs.getBinaryStream(1);
            configRoot = (SemConfigRoot)AbstractSchema.readXML(is);
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(is);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LoggerUtilities.logException(e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LoggerUtilities.logException(e);
                }
            }
            throw throwable;
        }
        IOUtilities.closeInputStream(is);
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LoggerUtilities.logException(e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LoggerUtilities.logException(e);
            }
        }
        return configRoot;
    }

    public static String activateUpgradeLicense() throws Exception {
        String upgradeFile = LicenseFileHelper.getUpgradeLicenseFileName();
        if (!LicenseUtils.isLicenseActivated(upgradeFile)) {
            String xml = LicenseFileHelper.getFileContents(upgradeFile);
            if (xml == null) {
                throw new Exception("upgrade file contents is null");
            }
            if (!LicenseUtils.isUpgradeLicense(xml)) {
                throw new Exception("sep.slf is not an upgrade file");
            }
            String activatedLicense = LicenseUtils.activateFlexStartLicense(xml);
            if (activatedLicense == null) {
                throw new Exception("activated file contents is null");
            }
            LicenseFileHelper.writeFileContents(LicenseFileHelper.getUpgradeLicenseFileName(), activatedLicense);
            return activatedLicense;
        }
        return null;
    }

    public static ArrayList<String> parseLicensesXML(String licenses, boolean allowFlex) throws LicenseException {
        Pattern regex = Pattern.compile("<license\\s+.+?</license>", 42);
        Matcher matcher = regex.matcher(licenses);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (allowFlex) {
            regex = Pattern.compile("<flex_sls_license\\s+.+?/\\s*>", 42);
            matcher = regex.matcher(licenses);
            while (matcher.find()) {
                matches.add(matcher.group());
            }
        }
        if (matches.size() == 0) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importLicenseNotFound");
            System.err.println(msg);
            throw new LicenseException(256, msg);
        }
        return matches;
    }

    public static int parseCount(String value) {
        try {
            if (value == null || value.trim().length() == 0) {
                return 0;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException(ex);
            return 0;
        }
    }

    public static long parsePolicy(String value) {
        try {
            if (value == null || value.trim().length() == 0) {
                return 0L;
            }
            String val = value;
            if (val.contains(",")) {
                val = val.substring(val.indexOf(",") + 1);
            }
            long days = Long.parseLong(val);
            return days * 24L * 60L * 60L * 1000L;
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException(ex);
            return 0L;
        }
    }

    public static boolean isCompatibleProductType(String type1, String type2) {
        if (type1 == null || type2 == null) {
            return true;
        }
        return type1.equals(type2);
    }

    public static ArrayList<ElsLicense> parseLicense(String xml) throws LicenseException {
        ArrayList<ElsLicense> licenses = new ArrayList<ElsLicense>();
        boolean foundLicense = false;
        try {
            LicenseIterator lit = new LicenseIterator(xml);
            while (lit.hasNext()) {
                ElsLicense license = new ElsLicense();
                license.setId(new GUIDGenerator().getGUIDString());
                license.setContent(xml);
                com.symantec.slic.License slicLicense = lit.next();
                if (slicLicense == null) {
                    LicenseException ex = new LicenseException();
                    ex.setErrorType(2);
                    throw ex;
                }
                if (SLIC_LICENSE_FEATURE_SNAC.equalsIgnoreCase(slicLicense.getFeatureName())) {
                    license.setOptClientProductType(ElsLicense.SNAC);
                } else if (SLIC_LICENSE_FEATURE_SEP.equalsIgnoreCase(slicLicense.getFeatureName())) {
                    license.setOptClientProductType(ElsLicense.SEP);
                } else {
                    System.out.println("Encountered unknown feature : " + slicLicense.getFeatureName());
                    continue;
                }
                if (LicenseUtils.isFeatureValid(slicLicense.getFeatureName()) && slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_CODE) != null) {
                    foundLicense = true;
                    if (slicLicense.getStartDate() == null) {
                        throw new LicenseException(2, "License is missing start date.");
                    }
                    license.setOptStartDate(slicLicense.getStartDate().getTime());
                    license.setOptStartDateString(slicLicense.getNamedOption(SLIC_START_DATE));
                    if (slicLicense.getEndDate() == null) {
                        throw new LicenseException(2, "License is missing end date.");
                    }
                    license.setOptEndDate(slicLicense.getEndDate().getTime());
                    license.setOptEndDateString(slicLicense.getNamedOption(SLIC_END_DATE));
                    license.setOptGraceCountPct(LicenseUtils.parseCount(slicLicense.getNamedOption(SLIC_OPTION_GRACE_PCT)));
                    license.setOptGracePoicy(LicenseUtils.parsePolicy(slicLicense.getNamedOption(SLIC_OPTION_GRACE_POLICY)));
                    license.setOptMeterCount(LicenseUtils.parseCount(slicLicense.getNamedOption(SLIC_OPTION_COUNT)));
                    if (slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_CODE) == null) {
                        throw new LicenseException(2, "License is missing product ID.");
                    }
                    license.setOptProductID(slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_CODE));
                    if (slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_NAME) == null) {
                        throw new LicenseException(2, "License is missing product name.");
                    }
                    license.setOptProductName(slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_NAME));
                    license.setOptProductType(LicenseUtils.getProductType(license.getOptProductID()));
                    if (slicLicense.getNamedOption(SLIC_OPTION_FULFILLMENT_ID) == null) {
                        throw new LicenseException(2, "License is missing fulfillment ID.");
                    }
                    license.setOptFulfillmentID(slicLicense.getNamedOption(SLIC_OPTION_FULFILLMENT_ID));
                    if (slicLicense.getNamedOption(SLIC_OPTION_SERIAL_ID) == null) {
                        throw new LicenseException(2, "License is missing serial ID.");
                    }
                    license.setOptSerialID(slicLicense.getNamedOption(SLIC_OPTION_SERIAL_ID));
                    if (slicLicense.getNamedOption(SLIC_OPTION_SERIAL_NUMBER) == null) {
                        throw new LicenseException(2, "License is missing serial number.");
                    }
                    license.setOptSerialNumber(slicLicense.getNamedOption(SLIC_OPTION_SERIAL_NUMBER));
                    license.setOptWarmPolicy(LicenseUtils.parsePolicy(slicLicense.getNamedOption(SLIC_OPTION_WARN_POLICY)));
                    license.setOptVersion(slicLicense.getNamedOption("version"));
                    licenses.add(license);
                    license.setOptLicenseCategory(LicenseUtils.getLicenseCategory(xml));
                    continue;
                }
                if (!LicenseUtils.isFeatureValid(slicLicense.getFeatureName())) continue;
                foundLicense = true;
                if (slicLicense.getStartDate() == null) {
                    throw new LicenseException(2, "License is missing start date.");
                }
                license.setOptStartDate(slicLicense.getStartDate().getTime());
                license.setOptStartDateString(slicLicense.getNamedOption(SLIC_START_DATE));
                if (slicLicense.getEndDate() == null) {
                    throw new LicenseException(2, "License is missing end date.");
                }
                license.setOptEndDate(slicLicense.getEndDate().getTime());
                license.setOptEndDateString(slicLicense.getNamedOption(SLIC_END_DATE));
                license.setOptGraceCountPct(LicenseUtils.parseCount(slicLicense.getNamedOption(SLIC_OPTION_GRACE_PCT)));
                license.setOptGracePoicy(LicenseUtils.parsePolicy(slicLicense.getNamedOption(SLIC_OPTION_GRACE_POLICY)));
                license.setOptMeterCount(LicenseUtils.parseCount(slicLicense.getNamedOption(SLIC_OPTION_COUNT)));
                license.setOptProductID("");
                if (slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_NAME) == null) {
                    license.setOptProductName("");
                }
                license.setOptProductName(slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_NAME));
                license.setOptProductType("UNKNOWN");
                if (slicLicense.getNamedOption(SLIC_OPTION_FULFILLMENT_ID) == null) {
                    license.setOptFulfillmentID("");
                }
                license.setOptFulfillmentID(slicLicense.getNamedOption(SLIC_OPTION_FULFILLMENT_ID));
                if (slicLicense.getNamedOption(SLIC_OPTION_SERIAL_ID) == null) {
                    license.setOptSerialID("");
                }
                license.setOptSerialID(slicLicense.getNamedOption(SLIC_OPTION_SERIAL_ID));
                if (slicLicense.getNamedOption(SLIC_OPTION_SERIAL_NUMBER) == null) {
                    license.setOptSerialNumber("");
                }
                license.setOptSerialNumber(slicLicense.getNamedOption(SLIC_OPTION_SERIAL_NUMBER));
                license.setOptWarmPolicy(LicenseUtils.parsePolicy(slicLicense.getNamedOption(SLIC_OPTION_WARN_POLICY)));
                license.setOptClientProductType(ElsLicense.SEP);
                license.setOptVersion(slicLicense.getNamedOption("version"));
                licenses.add(license);
            }
        }
        catch (SlicException slice) {
            LicenseException ex = new LicenseException();
            ex.initCause(slice);
            if (slice.getStatus() == -2147483627 || slice.getStatus() == -2147483626) {
                ex.setErrorType(2);
            } else {
                ex.setErrorType(1);
            }
            throw ex;
        }
        if (!foundLicense) {
            return null;
        }
        return licenses;
    }

    public static boolean isTrialwareLicense(ElsLicense license) throws SlicException {
        if (license == null) {
            return false;
        }
        LicenseIterator lit = new LicenseIterator(license.getContent());
        if (!lit.hasNext()) {
            return false;
        }
        com.symantec.slic.License slicLicense = lit.next();
        return slicLicense.isTrialware();
    }

    public static boolean isTrialwareLicense(String contents) throws SlicException {
        if (contents == null) {
            return false;
        }
        LicenseIterator lit = new LicenseIterator(contents);
        if (!lit.hasNext()) {
            return false;
        }
        com.symantec.slic.License slicLicense = lit.next();
        return slicLicense.isTrialware();
    }

    public static TrialwareLicense parseTrialwareLicense(String xml) throws LicenseException {
        ArrayList<ElsLicense> licenses = LicenseUtils.parseLicense(xml);
        if (licenses == null) {
            return null;
        }
        if (licenses.size() == 0) {
            return null;
        }
        ElsLicense license = licenses.get(0);
        return LicenseUtils.getTrialwareLicense(license);
    }

    public static TrialwareLicense getTrialwareLicense(ElsLicense license) {
        TrialwareLicense twLicense = new TrialwareLicense();
        twLicense.setId(license.getId());
        twLicense.setContent(license.getContent());
        twLicense.setOptEndDate(license.getOptEndDate());
        twLicense.setOptFulfillmentID(license.getOptFulfillmentID());
        twLicense.setOptGraceCountPct(license.getOptGraceCountPct());
        twLicense.setOptGracePoicy(license.getOptGracePoicy());
        twLicense.setOptMeterCount(license.getOptMeterCount());
        twLicense.setOptProductID(license.getOptProductID());
        twLicense.setOptProductName(license.getOptProductName());
        twLicense.setOptProductType(license.getOptProductType());
        twLicense.setOptSerialID(license.getOptSerialID());
        twLicense.setOptSerialNumber(license.getOptSerialNumber());
        twLicense.setOptStartDate(license.getOptStartDate());
        twLicense.setOptWarmPolicy(license.getOptWarmPolicy());
        twLicense.setOptVersion(license.getOptVersion());
        return twLicense;
    }

    public static void updateChainProperties(LicenseChain chain) {
        ElsLicense license = chain.getElsLicense(chain.getElsLicenseCount() - 1);
        chain.setOptEndDate(license.getOptEndDate());
        chain.setOptExpireDate(LicenseUtils.getExpireDate(license));
        chain.setOptGraceCount(LicenseUtils.getGraceCount(license));
        chain.setOptMeterCount(license.getOptMeterCount());
        chain.setOptWarnDate(LicenseUtils.getWarnDate(license));
        chain.setDirty();
    }

    public static boolean licenseFitsChain(ElsLicense license, LicenseChain chain) {
        if (chain.getElsLicenseCount() <= 0) {
            return true;
        }
        if (chain.getOptMeterCount().compareTo(license.getOptMeterCount()) != 0) {
            return false;
        }
        if (!license.getOptClientProductType().equals(chain.getOptClientProductType())) {
            return false;
        }
        Vector<ElsLicense> chainLicenses = chain.getElsLicense();
        String chainID = chainLicenses.get(chainLicenses.size() - 1).getOptProductID();
        if (chainID != null && chainID.length() > 0 && !license.getOptProductID().equalsIgnoreCase(chainID)) {
            return false;
        }
        return LicenseUtils.licenseDatesAlign(license, chainLicenses.get(chainLicenses.size() - 1));
    }

    public static boolean licenseDatesAlign(ElsLicense license1, ElsLicense license2) {
        long start1 = license1.getOptStartDate();
        long start2 = license2.getOptStartDate();
        long expire1 = LicenseUtils.getExpireDate(license1);
        long expire2 = LicenseUtils.getExpireDate(license2);
        if (start1 > expire2 - 432000000L && start1 < expire2 + 432000000L) {
            return true;
        }
        if (start2 > expire1 - 432000000L && start2 < expire1 + 432000000L) {
            return true;
        }
        return start1 > start2 - 432000000L && start1 < start2 + 432000000L && (expire1 < expire2 - 432000000L || expire1 > expire2 + 432000000L);
    }

    public static boolean licensesIdentical(ElsLicense srcLicense, ElsLicense targetLicense) {
        try {
            if (!srcLicense.getOptProductID().equalsIgnoreCase(targetLicense.getOptProductID())) {
                return false;
            }
            if (!srcLicense.getOptMeterCount().equals(targetLicense.getOptMeterCount())) {
                return false;
            }
            if (srcLicense.getOptEndDateString() != null && targetLicense.getOptEndDateString() != null && !srcLicense.getOptEndDateString().equals(targetLicense.getOptEndDateString())) {
                return false;
            }
            if (!srcLicense.getOptSerialNumber().equalsIgnoreCase(targetLicense.getOptSerialNumber())) {
                return false;
            }
            if (!srcLicense.getOptSerialID().equalsIgnoreCase(targetLicense.getOptSerialID())) {
                return false;
            }
            if (!srcLicense.getOptProductType().equalsIgnoreCase(targetLicense.getOptProductType())) {
                return false;
            }
            return srcLicense.getOptClientProductTypeValue().equalsIgnoreCase(targetLicense.getOptClientProductTypeValue());
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return false;
        }
    }

    public static int getGraceCount(ElsLicense license) {
        return (int)Math.ceil((double)license.getOptGraceCountPct().intValue() * (double)license.getOptMeterCount().intValue() / 100.0);
    }

    public static long getExpireDate(ElsLicense license) {
        return license.getOptEndDate() - license.getOptGracePoicy();
    }

    public static long getWarnDate(ElsLicense license) {
        return license.getOptEndDate() - license.getOptWarmPolicy();
    }

    public static int getGraceCount(TrialwareLicense license) {
        return (int)Math.ceil((double)license.getOptGraceCountPct().intValue() * (double)license.getOptMeterCount().intValue() / 100.0);
    }

    public static long getExpireDate(TrialwareLicense license) {
        return license.getOptEndDate() - license.getOptGracePoicy();
    }

    public static long getWarnDate(TrialwareLicense license) {
        return license.getOptEndDate() - license.getOptWarmPolicy();
    }

    public static int getGraceCount(UpgradeLicense license) {
        return (int)Math.ceil((double)license.getOptGraceCountPct().intValue() * (double)license.getOptMeterCount().intValue() / 100.0);
    }

    public static long getExpireDate(UpgradeLicense license) {
        return license.getOptEndDate() - license.getOptGracePolicy();
    }

    public static long getWarnDate(UpgradeLicense license) {
        return license.getOptEndDate() - license.getOptWarnPolicy();
    }

    public static ArrayList<LicenseChain> getLicenseChains(SemConfigRoot root) {
        ArrayList<LicenseChain> chains = new ArrayList<LicenseChain>();
        License lic = root.getLicense();
        if (lic == null) {
            return chains;
        }
        Vector<LicenseChain> licenseChain = lic.getLicenseChain();
        for (int i = 0; i < licenseChain.size(); ++i) {
            LicenseChain chain = licenseChain.get(i);
            if (chain == null) continue;
            Boolean suspended = chain.getOptSuspended();
            if (suspended == null) {
                suspended = chain.getDefSuspended();
            }
            if (suspended == null || suspended.booleanValue()) continue;
            chains.add(chain);
        }
        return chains;
    }

    public static ArrayList<LicenseChain> getDeletedLicenseChains(SemConfigRoot root) {
        ArrayList<LicenseChain> chains = new ArrayList<LicenseChain>();
        License lic = root.getLicense();
        if (lic == null) {
            return chains;
        }
        Vector<LicenseChain> liceseChain = lic.getLicenseChain();
        for (int i = 0; i < liceseChain.size(); ++i) {
            LicenseChain chain = liceseChain.get(i);
            if (chain == null) continue;
            Boolean suspended = chain.getOptSuspended();
            if (suspended == null) {
                suspended = chain.getDefSuspended();
            }
            if (suspended == null || !suspended.booleanValue()) continue;
            chains.add(chain);
        }
        return chains;
    }

    public static TrialwareLicense getTrialwareLicense(SemConfigRoot root) {
        License lic = root.getLicense();
        TrialwareLicense twl = null;
        if (lic == null) {
            return twl;
        }
        if (lic.getOptTrialwareLicense() != null) {
            Boolean suspended = lic.getOptTrialwareLicense().getOptSuspended();
            if (suspended != null) {
                if (!lic.getOptTrialwareLicense().getOptSuspended().booleanValue()) {
                    twl = lic.getOptTrialwareLicense();
                }
            } else if (!lic.getOptTrialwareLicense().getDefSuspended().booleanValue()) {
                twl = lic.getOptTrialwareLicense();
            }
        }
        return twl;
    }

    public static UpgradeLicense getUpgradeLicense(SemConfigRoot root) {
        License lic = root.getLicense();
        if (lic == null) {
            return null;
        }
        if (lic.getOptUpgradeLicense() != null && lic.getOptUpgradeLicense().getOptSuspended() != null && !lic.getOptUpgradeLicense().getOptSuspended().booleanValue()) {
            return lic.getOptUpgradeLicense();
        }
        return null;
    }

    public static OverdeployedLicense getODLicense(SemConfigRoot root) {
        License lic = root.getLicense();
        OverdeployedLicense odl = null;
        if (lic == null) {
            return odl;
        }
        if (lic.getOptOverdeployedLicense() != null) {
            Boolean suspended = lic.getOptOverdeployedLicense().getOptSuspended();
            if (suspended != null) {
                if (!lic.getOptOverdeployedLicense().getOptSuspended().booleanValue()) {
                    odl = lic.getOptOverdeployedLicense();
                }
            } else {
                odl = lic.getOptOverdeployedLicense();
            }
        }
        return odl;
    }

    private static String getProductTypeFromODLicense(OverdeployedLicense odl) {
        if (odl == null) {
            return "UNKNOWN";
        }
        String type = odl.getOptProductType();
        if (type == null) {
            try {
                LicenseIterator lit = new LicenseIterator(odl.getContent());
                if (lit.hasNext()) {
                    com.symantec.slic.License slicLicense = lit.next();
                    type = slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_CODE);
                }
            }
            catch (SlicException se) {
                LoggerUtilities.logException(se);
            }
        }
        if (type != null) {
            if (type.trim().toUpperCase().startsWith("SEPE")) {
                return "SEPE";
            }
            if (type.trim().toUpperCase().startsWith("SEPSB")) {
                return "SEPSB";
            }
        }
        return "UNKNOWN";
    }

    private static String getProductTypeFromLicenseRoot(SemConfigRoot root) {
        if (root == null) {
            return "UNKNOWN";
        }
        License license = root.getLicense();
        if (license != null) {
            try {
                String type = license.getOptLicenseStateValue();
                if (type != null) {
                    if (type.trim().toUpperCase().startsWith("SEPE")) {
                        return "SEPE";
                    }
                    if (type.trim().toUpperCase().startsWith("SEPSB")) {
                        return "SEPSB";
                    }
                } else {
                    System.out.println("info: No value from getOptLicenseStateValue, the database should be upgraded from DietCoke");
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException(ex);
            }
        }
        return "UNKNOWN";
    }

    public static String getProductType(SemConfigRoot root, boolean onlyFromODLicense) {
        String typeFromOD = LicenseUtils.getProductTypeFromODLicense(LicenseUtils.getODLicense(root));
        System.out.println("info : LicenseUtils.getProductType typeFromOD=" + typeFromOD + " onlyFromODLicense=" + String.valueOf(onlyFromODLicense));
        if (onlyFromODLicense) {
            return typeFromOD;
        }
        String typeFromLicenseRoot = LicenseUtils.getProductTypeFromLicenseRoot(root);
        System.out.println("info : LicenseUtils.getProductType typeFromOD=" + typeFromOD + " typeFromLicenseRoot=" + typeFromLicenseRoot);
        if (!StringUtilities.isEmpty(typeFromOD) && !StringUtilities.isEmpty(typeFromLicenseRoot) && typeFromOD.equalsIgnoreCase(typeFromLicenseRoot)) {
            return typeFromOD;
        }
        return "UNKNOWN";
    }

    public static boolean isLicenseActivated(String fileName) {
        boolean retVal = false;
        try {
            String xml = LicenseFileHelper.getFileContents(fileName);
            LicenseIterator lit = new LicenseIterator(xml);
            while (lit.hasNext()) {
                com.symantec.slic.License slicLicense = lit.next();
                if (slicLicense == null || !SLIC_LICENSE_FEATURE_SEP.equalsIgnoreCase(slicLicense.getFeatureName())) continue;
                if (slicLicense.isTrialware()) {
                    Pattern regex = Pattern.compile("<flex_sls_license\\s+.+?/\\s*>", 42);
                    Matcher matcher = regex.matcher(xml);
                    if (!matcher.find()) continue;
                    retVal = true;
                    continue;
                }
                if (slicLicense.getEndDays() == Integer.MAX_VALUE) continue;
                retVal = true;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return retVal;
    }

    public static UpgradeLicense parseUpgradeLicense(String xml) throws LicenseException {
        ArrayList<ElsLicense> licenses = LicenseUtils.parseLicense(xml);
        if (licenses == null) {
            return null;
        }
        if (licenses.size() == 0) {
            return null;
        }
        ElsLicense license = licenses.get(0);
        return LicenseUtils.getUpgradeLicense(license);
    }

    public static UpgradeLicense getUpgradeLicense(ElsLicense license) {
        UpgradeLicense ugLicense = new UpgradeLicense();
        ugLicense.setId(license.getId());
        ugLicense.setContent(license.getContent());
        ugLicense.setOptEndDate(license.getOptEndDate());
        ugLicense.setOptFulfillmentID(license.getOptFulfillmentID());
        ugLicense.setOptGraceCountPct(license.getOptGraceCountPct());
        ugLicense.setOptGracePolicy(license.getOptGracePoicy());
        ugLicense.setOptMeterCount(license.getOptMeterCount());
        ugLicense.setOptProductID(license.getOptProductID());
        ugLicense.setOptProductName(license.getOptProductName());
        ugLicense.setOptProductType(license.getOptProductType());
        ugLicense.setOptSerialID(license.getOptSerialID());
        ugLicense.setOptSerialNumber(license.getOptSerialNumber());
        ugLicense.setOptStartDate(license.getOptStartDate());
        ugLicense.setOptWarnPolicy(license.getOptWarmPolicy());
        ugLicense.setOptVersion(license.getOptVersion());
        return ugLicense;
    }

    public static boolean isUpgradeLicense(String contents) {
        return LicenseUtils.getLicenseCategory(contents) == 2;
    }

    public static boolean isNeverexpireLicense(String contents) {
        return LicenseUtils.getLicenseCategory(contents) == 3;
    }

    public static boolean isODLicense(String contents) {
        int category = LicenseUtils.getLicenseCategory(contents);
        if (category > 0) {
            return LicenseUtils.getLicenseCategory(contents) == 4;
        }
        try {
            LicenseIterator itr = new LicenseIterator(contents);
            com.symantec.slic.License license = itr.next();
            String strProductCode = license.getNamedOption(SLIC_OPTION_PRODUCT_CODE);
            String strProductName = license.getNamedOption(SLIC_OPTION_PRODUCT_NAME);
            if (strProductCode == null || strProductName == null) {
                return false;
            }
            if (strProductCode.toLowerCase().indexOf(PRODUCT_CODE_PREFIX_SEPSB) > -1 && strProductName.toLowerCase().indexOf("over-deployed") > -1) {
                return true;
            }
        }
        catch (Exception ex) {
            System.err.println("Found Error when check if a license is Over-deployed");
            LoggerUtilities.logException(ex);
        }
        return false;
    }

    private static int getLicenseCategory(String contents) {
        int retVal = -1;
        try {
            LicenseIterator itr = new LicenseIterator(contents);
            com.symantec.slic.License license = itr.next();
            String licenseCategory = license.getNamedOption(SLIC_OPTION_LICENSE_CATEGORY);
            if (licenseCategory != null) {
                retVal = Integer.parseInt(licenseCategory);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return retVal;
    }

    private static boolean isFeatureValid(String featureName) {
        boolean retVal = false;
        if (featureName != null && (SLIC_LICENSE_FEATURE_SEP.equalsIgnoreCase(featureName) || SLIC_LICENSE_FEATURE_SNAC.equalsIgnoreCase(featureName))) {
            retVal = true;
        }
        return retVal;
    }

    public static String activateFlexStartLicense(String xml) throws LicenseException {
        String activatedLicense = null;
        try {
            String[] files;
            LicenseManager manager = new LicenseManager();
            String repositoryPath = manager.getLicenseDir();
            File repository = new File(repositoryPath);
            if (repository.exists() && !repository.isDirectory()) {
                throw new LicenseException(3, "License repository is not a directory.");
            }
            HashMap repositoryFiles = new HashMap();
            if (repository.exists() && (files = repository.list()) != null) {
                for (String fileName : files) {
                    repositoryFiles.put(fileName, null);
                }
            }
            String productName = null;
            String productVersion = null;
            LicenseIterator lit = new LicenseIterator(xml);
            while (lit.hasNext()) {
                com.symantec.slic.License slicLicense = lit.next();
                if (slicLicense == null || !SLIC_LICENSE_FEATURE_SEP.equalsIgnoreCase(slicLicense.getFeatureName())) continue;
                productVersion = slicLicense.getVersion();
                productName = slicLicense.getNamedOption(SLIC_OPTION_PRODUCT_NAME);
            }
            if (productName == null) {
                throw new LicenseException(2, "Unable to determine the product name for this license.");
            }
            manager.installLicense(xml);
            manager.startLicenses(productName);
            manager.removeLicense(xml);
            if (!repository.isDirectory()) {
                throw new LicenseException(3, "Unable to read license repository.");
            }
            String[] files2 = repository.list();
            ArrayList<Object> newFiles = new ArrayList<Object>();
            if (files2 != null) {
                for (String file : files2) {
                    if (repositoryFiles.containsKey(file)) continue;
                    newFiles.add(file);
                }
            }
            for (String string : newFiles) {
                StringBuffer fileData = new StringBuffer();
                try (FileInputStream is = new FileInputStream(new File(repositoryPath, string));
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF8"));){
                    char[] buffer = new char[1024];
                    int len = reader.read(buffer);
                    while (len > 0) {
                        fileData.append(buffer, 0, len);
                        len = reader.read(buffer);
                    }
                }
                catch (IOException ex) {
                    LoggerUtilities.logException(ex);
                    continue;
                }
                try {
                    lit = new LicenseIterator(fileData.toString());
                    while (lit.hasNext()) {
                        com.symantec.slic.License license = lit.next();
                        if (!SLIC_LICENSE_FEATURE_SEP.equalsIgnoreCase(license.getFeatureName()) || !productVersion.equalsIgnoreCase(license.getVersion())) continue;
                        activatedLicense = fileData.toString();
                        Utility.delete(new File(repositoryPath, string));
                    }
                }
                catch (SlicException ex) {
                    LoggerUtilities.logException(ex);
                }
            }
        }
        catch (SlicException slicex) {
            LicenseException ex = new LicenseException();
            ex.initCause(slicex);
            if (slicex.getStatus() == -2147483627 || slicex.getStatus() == -2147483626) {
                ex.setErrorType(2);
            } else {
                ex.setErrorType(1);
            }
            throw ex;
        }
        return activatedLicense;
    }

    public static String getProductType(String productCode) {
        if (productCode != null && productCode.toLowerCase().startsWith(PRODUCT_CODE_PREFIX_SEPSB)) {
            return "SEPSB";
        }
        if (productCode != null && productCode.toLowerCase().startsWith(PRODUCT_CODE_PREFIX_SEPE)) {
            return "SEPE";
        }
        return "UNKNOWN";
    }

    public static IPL_FIRST_CONTACTNAME_ERROR_REASON processFirstContactNameError(ContactNameError error) {
        IPL_FIRST_CONTACTNAME_ERROR_REASON reason;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case CONTAINS_DIGITS: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.CONTAINS_DIGITS;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case INVALID_USE_OF_SPECIAL_CHARS: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.INVALID_USE_OF_SPECIAL_CHARS;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            default: {
                reason = IPL_FIRST_CONTACTNAME_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_LAST_CONTACTNAME_ERROR_REASON processLastContactNameError(ContactNameError error) {
        IPL_LAST_CONTACTNAME_ERROR_REASON reason;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case CONTAINS_DIGITS: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.CONTAINS_DIGITS;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case INVALID_USE_OF_SPECIAL_CHARS: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.INVALID_USE_OF_SPECIAL_CHARS;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            default: {
                reason = IPL_LAST_CONTACTNAME_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_POSTALCODE_ERROR_REASON processPostalCodeError(PostalCodeError error) {
        IPL_POSTALCODE_ERROR_REASON reason;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_POSTALCODE_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_POSTALCODE_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_POSTALCODE_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            case DECLARED_INVALID_BY_SERVER: {
                reason = IPL_POSTALCODE_ERROR_REASON.DECLARED_INVALID_BY_SERVER;
                break;
            }
            case POSTAL_CODE_AND_CITY_REJECTED: {
                reason = IPL_POSTALCODE_ERROR_REASON.POSTAL_CODE_AND_CITY_REJECTED;
                break;
            }
            case DOES_NOT_MATCH_CITY: {
                reason = IPL_POSTALCODE_ERROR_REASON.DOES_NOT_MATCH_CITY;
                break;
            }
            default: {
                reason = IPL_POSTALCODE_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_SERIALNUMBER_ERROR_REASON processSerialNumberError(SerialNumberError error) {
        IPL_SERIALNUMBER_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_SERIALNUMBER_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case INVALID_FORMAT: {
                reason = IPL_SERIALNUMBER_ERROR_REASON.INVALID_FORMAT;
                break;
            }
            default: {
                reason = IPL_SERIALNUMBER_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_CITY_ERROR_REASON processCityError(CityError error) {
        IPL_CITY_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_CITY_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_CITY_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_CITY_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            case DECLARED_INVALID_BY_SERVER: {
                reason = IPL_CITY_ERROR_REASON.DECLARED_INVALID_BY_SERVER;
                break;
            }
            case POSTAL_CODE_AND_CITY_REJECTED: {
                reason = IPL_CITY_ERROR_REASON.POSTAL_CODE_AND_CITY_REJECTED;
                break;
            }
            default: {
                reason = IPL_CITY_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_COUNTRY_ERROR_REASON processCountryError(CountryError error) {
        IPL_COUNTRY_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_COUNTRY_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_COUNTRY_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            case REQUIRES_A_STATE_OR_PROVINCE: {
                reason = IPL_COUNTRY_ERROR_REASON.REQUIRES_A_STATE_OR_PROVINCE;
                break;
            }
            case NON_US_ADDRESS: {
                reason = IPL_COUNTRY_ERROR_REASON.NON_US_ADDRESS;
                break;
            }
            default: {
                reason = IPL_COUNTRY_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_COMPANYNAME_ERROR_REASON processCompanyNameError(CompanyNameError error) {
        IPL_COMPANYNAME_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_COMPANYNAME_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_COMPANYNAME_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_COMPANYNAME_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            case INVALID_USE_OF_SPECIAL_CHARS: {
                reason = IPL_COMPANYNAME_ERROR_REASON.INVALID_USE_OF_SPECIAL_CHARS;
                break;
            }
            case ALL_DIGITS: {
                reason = IPL_COMPANYNAME_ERROR_REASON.ALL_DIGITS;
                break;
            }
            default: {
                reason = IPL_COMPANYNAME_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_STREETADDRESS_ERROR_REASON processStreetAddressError(StreetAddressError error, int lineNo) {
        IPL_STREETADDRESS_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_STREETADDRESS_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_STREETADDRESS_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case DECLARED_INVALID_BY_SERVER: {
                reason = IPL_STREETADDRESS_ERROR_REASON.DECLARED_INVALID_BY_SERVER;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_STREETADDRESS_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            case AMBIGUOUS_STREET_ADDRESS: {
                if (lineNo != 2) {
                    reason = IPL_STREETADDRESS_ERROR_REASON.AMBIGUOUS_STREET_ADDRESS;
                    break;
                }
                reason = IPL_STREETADDRESS_ERROR_REASON.AMBIGUOUS_STREET_ADDRESS_LINE2;
                break;
            }
            case AMBIGUOUS_STREET_NAME: {
                reason = IPL_STREETADDRESS_ERROR_REASON.AMBIGUOUS_STREET_NAME;
                break;
            }
            case INVALID_STREET_NAME: {
                reason = IPL_STREETADDRESS_ERROR_REASON.INVALID_STREET_NAME;
                break;
            }
            case STREET_NAME_REQUIRES_DIRECTIONAL_SUFFIX: {
                reason = IPL_STREETADDRESS_ERROR_REASON.STREET_NAME_REQUIRES_DIRECTIONAL_SUFFIX;
                break;
            }
            case STREET_NAME_REQUIRES_PREFIX: {
                reason = IPL_STREETADDRESS_ERROR_REASON.STREET_NAME_REQUIRES_PREFIX;
                break;
            }
            case STREET_NAME_REQUIRES_PREFIX_AND_TYPE_SUFFIX: {
                reason = IPL_STREETADDRESS_ERROR_REASON.STREET_NAME_REQUIRES_PREFIX_AND_TYPE_SUFFIX;
                break;
            }
            case STREET_NAME_REQUIRES_TYPE_SUFFIX: {
                reason = IPL_STREETADDRESS_ERROR_REASON.STREET_NAME_REQUIRES_TYPE_SUFFIX;
                break;
            }
            case STREET_NUMBER_NOT_RECOGNIZED: {
                reason = IPL_STREETADDRESS_ERROR_REASON.STREET_NUMBER_NOT_RECOGNIZED;
                break;
            }
            default: {
                reason = IPL_STREETADDRESS_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_EMAILADDRESS_ERROR_REASON processEmailAddressError(EmailAddressError error) {
        IPL_EMAILADDRESS_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_EMAILADDRESS_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_EMAILADDRESS_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case INVALID_FORMAT: {
                reason = IPL_EMAILADDRESS_ERROR_REASON.INVALID_FORMAT;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_EMAILADDRESS_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            default: {
                reason = IPL_EMAILADDRESS_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_PHONENUMBER_ERROR_REASON processPhoneNumberError(PhoneNumberError error) {
        IPL_PHONENUMBER_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_PHONENUMBER_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_PHONENUMBER_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case INVALID_FORMAT: {
                reason = IPL_PHONENUMBER_ERROR_REASON.INVALID_FORMAT;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_PHONENUMBER_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            default: {
                reason = IPL_PHONENUMBER_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_STATEORPROVINCE_ERROR_REASON processStateOrProvinceError(StateOrProvinceError error) {
        IPL_STATEORPROVINCE_ERROR_REASON reason = null;
        switch (error.getReason()) {
            case FIELD_IS_MANDATORY: {
                reason = IPL_STATEORPROVINCE_ERROR_REASON.FIELD_IS_MANDATORY;
                break;
            }
            case DOUBLE_BYTE_CHAR: {
                reason = IPL_STATEORPROVINCE_ERROR_REASON.DOUBLE_BYTE_CHAR;
                break;
            }
            case MAX_SIZE_EXCEEDED: {
                reason = IPL_STATEORPROVINCE_ERROR_REASON.MAX_SIZE_EXCEEDED;
                break;
            }
            default: {
                reason = IPL_STATEORPROVINCE_ERROR_REASON.UNKNOWN;
            }
        }
        return reason;
    }

    public static IPL_MAILINGADDRESS_ERROR_REASON processMailingAddressError(MailingAddressError error) {
        return IPL_MAILINGADDRESS_ERROR_REASON.UNKNOWN;
    }

    public static TechnicalContactInfo createTechnicalContactInfo(String techFirstName, String techLastName, String techContactEmailAddress, String techTelephoneNumber) {
        ContactName techContactName = null;
        if (techFirstName != null && techLastName != null) {
            techContactName = new ContactName(techFirstName, techLastName);
        }
        if (techContactEmailAddress != null && techTelephoneNumber != null) {
            return new TechnicalContactInfo(techContactName, techContactEmailAddress, techTelephoneNumber);
        }
        return null;
    }

    public static CompanyInfo createCompanyInfo(String primaryContactFirstName, String primaryContactLastName, String firstLine, String secondLine, String thirdLine, String city, String countryCode, String postalCode, String stateOrProvince, String companyName, String companyTelephoneNumber, String companyContactEmailAddress) {
        StreetAddress streetAddress = null;
        MailingAddress mailingAddress = null;
        ContactName primaryContactName = null;
        if (primaryContactFirstName != null && primaryContactLastName != null) {
            primaryContactName = new ContactName(primaryContactFirstName, primaryContactLastName);
        }
        if (firstLine != null) {
            streetAddress = new StreetAddress(firstLine, secondLine, thirdLine);
        }
        if (streetAddress != null && city != null && postalCode != null && stateOrProvince != null) {
            mailingAddress = new MailingAddress(streetAddress, city, countryCode, postalCode, stateOrProvince);
        }
        if (companyName != null && primaryContactName != null && companyTelephoneNumber != null && mailingAddress != null && companyContactEmailAddress != null) {
            return new CompanyInfo(companyName, primaryContactName, companyTelephoneNumber, mailingAddress, companyContactEmailAddress);
        }
        return null;
    }

    public static String getDateStrInyyyy(long date) {
        return DateTimeManager.getYYYYDigitalDate(date);
    }

    public static String getDateStrInyyyy(long date, TimeZone timeZone) {
        return DateTimeManager.getYYYYDigitalDate(date, timeZone);
    }

    public static Long extractValidDays(String contents) {
        Long retVal = null;
        try {
            LicenseIterator lit = new LicenseIterator(contents);
            while (lit.hasNext()) {
                com.symantec.slic.License slicLicense = lit.next();
                String validDays = slicLicense.getNamedOption(SLIC_OPTION_VALID_DAYS);
                if (validDays != null) {
                    retVal = Long.valueOf(validDays);
                    continue;
                }
                retVal = slicLicense.getEndDays() - slicLicense.getStartDays();
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return retVal;
    }

    public static long calcTotalValidDays(ElsLicense lic) {
        long retVal = -1L;
        try {
            Long validDays = LicenseUtils.extractValidDays(lic.getContent());
            retVal = validDays != null ? validDays : (lic.getOptEndDate() - lic.getOptStartDate()) / 86400000L;
            if (lic.getOptGracePoicy() > 0L) {
                retVal -= lic.getOptGracePoicy() / 86400000L;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return retVal;
    }

    public static String getGenericPurchaseURL(String productType) throws Exception {
        return "https://ced.broadcom.com/sep/14/partnerlocator";
    }

    public static enum ERROR_MESSAGE {
        ERROR_MESSAGE_DOBOULE_BYTE_CHARS("LicenseActivationWizardDialog.doboulebytechars"),
        ERROR_MESSAGE_TOO_LONG_240_CHAR("LicenseActivationWizardDialog.tooLong240Char"),
        ERROR_MESSAGE_TOO_LONG_40_CHAR("LicenseActivationWizardDialog.tooLong40Char"),
        ERROR_MESSAGE_TOO_LONG_50_CHAR("LicenseActivationWizardDialog.tooLong50Char"),
        ERROR_MESSAGE_TOO_LONG_60_CHAR("LicenseActivationWizardDialog.tooLong60Char"),
        ERROR_MESSAGE_NO_MESSAGE("LicenseActivationWizardDialog.noMessage"),
        ERROR_MESSAGE_SERIAL_NUMBER_FIELD_INVALID_FORMAT("LicenseActivationWizardDialog.serialnumberfieldinvalidformat"),
        ERROR_MESSAGE_SERIAL_NUMBER_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.serialnumberfieldismandatory"),
        ERROR_MESSAGE_CITY_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.cityfieldismandatory"),
        ERROR_MESSAGE_CITY_FIELD_DECLARED_INVALID_BY_SERVER("LicenseActivationWizardDialog.cityfileddeclaredinvalidbyserver"),
        ERROR_MESSAGE_POSTAL_CODE_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.postalcodefieldismandatory"),
        ERROR_MESSAGE_POSTAL_CODE_FIELD_DECLARED_INVALID_BY_SERVER("LicenseActivationWizardDialog.postalcodefielddeclaredinvalidbyserver"),
        ERROR_MESSAGE_POSTAL_CODE_FIELD_DOES_NOT_MATCH_CITY("LicenseActivationWizardDialog.postalcodefileddoesnotmatchcity"),
        ERROR_MESSAGE_POSTAL_CODE_AND_CITY_REJECTED("LicenseActivationWizardDialog.postalcodeandcityrejected"),
        ERROR_MESSAGE_STATE_PROVINCE_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.stateprovincefieldismandatory"),
        ERROR_MESSAGE_COUNTRY_FIELD_NON_US_ADDRESS("LicenseActivationWizardDialog.countrynonusaddress"),
        ERROR_MESSAGE_COUNTRY_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.countryfiledismandatory"),
        ERROR_MESSAGE_COMPANY_NAME_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.companynamefieldismandatory"),
        ERROR_MESSAGE_COMPANY_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS("LicenseActivationWizardDialog.companynameinvaliduseofspecialchars"),
        ERROR_MESSAGE_COMPANY_NAME_FIELD_ALL_DIGITS("LicenseActivationWizardDialog.companynamealldigits"),
        ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.firstnamefieldismandatory"),
        ERROR_MESSAGE_FIRST_NAME_FIELD_CONTAINS_DIGITS("LicenseActivationWizardDialog.firstnamefieldcontainsdigits"),
        ERROR_MESSAGE_FIRST_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS("LicenseActivationWizardDialog.firstnamefieldinvaliduseofspecialchars"),
        ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.lastnamefieldismandatory"),
        ERROR_MESSAGE_LAST_NAME_FIELD_CONTAINS_DIGITS("LicenseActivationWizardDialog.lastnamefieldcontainsdigits"),
        ERROR_MESSAGE_LAST_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS("LicenseActivationWizardDialog.lastnamefieldinvaliduseofspecialchars"),
        ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.emailfieldismandatory"),
        ERROR_MESSAGE_EMAIL_FIELD_INVALID_FORMAT("LicenseActivationWizardDialog.emailfieldinvalidformat"),
        ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.phonenumberfieldismandatory"),
        ERROR_MESSAGE_PHONE_NUMBER_FIELD_INVALID_FORMAT("LicenseActivationWizardDialog.phonenumberfieldinvalidformat"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_IS_MANDATORY("LicenseActivationWizardDialog.streetaddressfieldismandatory"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_INVALID_STREET_NAME("LicenseActivationWizardDialog.streetaddressfieldinvalidstreetname"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_STREET_NUMBER_NOT_RECOGNIZED("LicenseActivationWizardDialog.streetaddressfieldstreetnumbernotrecognized"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_ADDRESS("LicenseActivationWizardDialog.streetaddressfieldambiguousstreetaddress"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_NAME("LicenseActivationWizardDialog.streetaddressfieldambiguousstreetname"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_DIRECTIONAL_SUFFIX("LicenseActivationWizardDialog.streetaddressfieldrequiresdirectionalsuffix"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_PREFIX("LicenseActivationWizardDialog.streetaddressfieldrequiresprefix"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_STREET_NAME_REQUIRES_TYPE_SUFFIX("LicenseActivationWizardDialog.streetaddressfieldstreetnamerequirestypesuffix"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_PREFIX_AND_TYPE_SUFFIX("LicenseActivationWizardDialog.streetaddressfieldrequiresprefixandtypesuffix"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_DECLARED_INVALID_BY_SERVER("LicenseActivationWizardDialog.streetaddressfielddeclaredinvalidbyserver"),
        ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_ADDRESS_LINE2("LicenseActivationWizardDialog.streetaddressfieldambiguousstreetaddressline2"),
        ERROR_MESSAGE_MAILING_ADDRESS_FIELD_UNKNOWN("LicenseActivationWizardDialog.mailingaddressfieldUnknown"),
        ERROR_MESSAGE_INTERNAL_ERROR("LicenseActivationWizardDialog.internalError"),
        ERROR_MESSAGE_TRADE_COMPLIANCE_IP_CHECK_FAILED("LicenseActivationWizardDialog.tradeComplianceCheckFailed"),
        ERROR_MESSAGE_SERIAL_NUMBER_NOT_RECOGNIZED("LicenseActivationWizardDialog.serialnumbernotrecognized"),
        ERROR_MESSAGE_WRONG_PRODUCT_ID("LicenseActivationWizardDialog.wrongproductid"),
        ERROR_MESSAGE_INACTIVE_SERIAL_NUMBER("LicenseActivationWizardDialog.inactiveserialnumber"),
        ERROR_MESSAGE_REG_COUNT_EXCEEDED("LicenseActivationWizardDialog.regcountexceeded"),
        ERROR_MESSAGE_SERIAL_NUMBER_IS_NON_IPL("LicenseActivationWizardDialog.serialnumberisnonipl"),
        ERROR_MESSAGE_SERIAL_NUMBER_BLOCKED_BY_TRADE_COMPLIANCE("LicenseActivationWizardDialog.serialnumberblockedbytradecompliance"),
        ERROR_MESSAGE_IPL_SPECIFIC_SERVER_INTERNAL_ERROR("LicenseActivationWizardDialog.iplspecificserverinternalerror"),
        ERROR_MESSAGE_TEMPORARY_SERVER_INTERNAL_ERROR("LicenseActivationWizardDialog.temporaryserverinternalerror"),
        ERROR_MESSAGE_COMPANY_INFO_REQUIRED("LicenseActivationWizardDialog.companyInfoRequired"),
        ERROR_MESSAGE_TECHNICAL_CONTACT_INFO_REQUIRED("LicenseActivationWizardDialog.technicalContactInfoRequired");

        private final String errorMessage;

        private ERROR_MESSAGE(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String toString() {
            return this.errorMessage;
        }

        public String toErrorMessage() {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", this.errorMessage);
        }
    }

    public static enum IPL_MAILINGADDRESS_ERROR_REASON {
        UNKNOWN(0, ERROR_MESSAGE.ERROR_MESSAGE_MAILING_ADDRESS_FIELD_UNKNOWN);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_MAILINGADDRESS_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_STATEORPROVINCE_ERROR_REASON {
        DOUBLE_BYTE_CHAR(0, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(1, ERROR_MESSAGE.ERROR_MESSAGE_STATE_PROVINCE_FIELD_IS_MANDATORY),
        MAX_SIZE_EXCEEDED(2, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_60_CHAR),
        UNKNOWN(3, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_STATEORPROVINCE_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_PHONENUMBER_ERROR_REASON {
        DOUBLE_BYTE_CHAR(0, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(1, ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY),
        INVALID_FORMAT(2, ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_INVALID_FORMAT),
        MAX_SIZE_EXCEEDED(3, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_40_CHAR),
        UNKNOWN(4, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_PHONENUMBER_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_EMAILADDRESS_ERROR_REASON {
        DOUBLE_BYTE_CHAR(0, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(1, ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY),
        INVALID_FORMAT(2, ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_INVALID_FORMAT),
        MAX_SIZE_EXCEEDED(3, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_50_CHAR),
        UNKNOWN(4, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_EMAILADDRESS_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_STREETADDRESS_ERROR_REASON {
        AMBIGUOUS_STREET_ADDRESS(0, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_ADDRESS),
        AMBIGUOUS_STREET_NAME(1, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_NAME),
        DECLARED_INVALID_BY_SERVER(2, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_DECLARED_INVALID_BY_SERVER),
        DOUBLE_BYTE_CHAR(3, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(4, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_IS_MANDATORY),
        INVALID_STREET_NAME(5, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_INVALID_STREET_NAME),
        MAX_SIZE_EXCEEDED(6, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_240_CHAR),
        STREET_NAME_REQUIRES_DIRECTIONAL_SUFFIX(7, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_DIRECTIONAL_SUFFIX),
        STREET_NAME_REQUIRES_PREFIX(8, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_PREFIX),
        STREET_NAME_REQUIRES_PREFIX_AND_TYPE_SUFFIX(9, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_REQUIRES_PREFIX_AND_TYPE_SUFFIX),
        STREET_NAME_REQUIRES_TYPE_SUFFIX(10, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_STREET_NAME_REQUIRES_TYPE_SUFFIX),
        STREET_NUMBER_NOT_RECOGNIZED(11, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_STREET_NUMBER_NOT_RECOGNIZED),
        UNKNOWN(12, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE),
        AMBIGUOUS_STREET_ADDRESS_LINE2(13, ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_AMBIGUOUS_STREET_ADDRESS_LINE2);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_STREETADDRESS_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_COMPANYNAME_ERROR_REASON {
        ALL_DIGITS(0, ERROR_MESSAGE.ERROR_MESSAGE_COMPANY_NAME_FIELD_ALL_DIGITS),
        DOUBLE_BYTE_CHAR(1, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(2, ERROR_MESSAGE.ERROR_MESSAGE_COMPANY_NAME_FIELD_IS_MANDATORY),
        INVALID_USE_OF_SPECIAL_CHARS(3, ERROR_MESSAGE.ERROR_MESSAGE_COMPANY_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS),
        MAX_SIZE_EXCEEDED(4, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_50_CHAR),
        UNKNOWN(5, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_COMPANYNAME_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_COUNTRY_ERROR_REASON {
        FIELD_IS_MANDATORY(0, ERROR_MESSAGE.ERROR_MESSAGE_COUNTRY_FIELD_IS_MANDATORY),
        INVALID_FORMAT(1, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE),
        MAX_SIZE_EXCEEDED(2, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_60_CHAR),
        NON_US_ADDRESS(3, ERROR_MESSAGE.ERROR_MESSAGE_COUNTRY_FIELD_NON_US_ADDRESS),
        REQUIRES_A_STATE_OR_PROVINCE(4, ERROR_MESSAGE.ERROR_MESSAGE_STATE_PROVINCE_FIELD_IS_MANDATORY),
        UNKNOWN(5, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_COUNTRY_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_POSTALCODE_ERROR_REASON {
        DECLARED_INVALID_BY_SERVER(0, ERROR_MESSAGE.ERROR_MESSAGE_POSTAL_CODE_FIELD_DECLARED_INVALID_BY_SERVER),
        DOES_NOT_MATCH_CITY(1, ERROR_MESSAGE.ERROR_MESSAGE_POSTAL_CODE_FIELD_DOES_NOT_MATCH_CITY),
        DOUBLE_BYTE_CHAR(2, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(3, ERROR_MESSAGE.ERROR_MESSAGE_POSTAL_CODE_FIELD_IS_MANDATORY),
        POSTAL_CODE_AND_CITY_REJECTED(4, ERROR_MESSAGE.ERROR_MESSAGE_POSTAL_CODE_AND_CITY_REJECTED),
        MAX_SIZE_EXCEEDED(5, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_60_CHAR),
        UNKNOWN(6, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_POSTALCODE_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_CITY_ERROR_REASON {
        DECLARED_INVALID_BY_SERVER(0, ERROR_MESSAGE.ERROR_MESSAGE_CITY_FIELD_DECLARED_INVALID_BY_SERVER),
        DOUBLE_BYTE_CHAR(1, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(2, ERROR_MESSAGE.ERROR_MESSAGE_CITY_FIELD_IS_MANDATORY),
        MAX_SIZE_EXCEEDED(3, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_60_CHAR),
        POSTAL_CODE_AND_CITY_REJECTED(4, ERROR_MESSAGE.ERROR_MESSAGE_POSTAL_CODE_AND_CITY_REJECTED),
        UNKNOWN(5, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_CITY_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_NAME_TYPE {
        FIRST(0),
        LAST(1),
        UNKNOWN(2);

        private final int value;

        private IPL_NAME_TYPE(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IPL_INFO_TYPE {
        COMPANY(0),
        TECHNICAL_CONTACT(1),
        UNKNOWN(2);

        private final int value;

        private IPL_INFO_TYPE(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IPL_LAST_CONTACTNAME_ERROR_REASON {
        CONTAINS_DIGITS(0, ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_CONTAINS_DIGITS),
        DOUBLE_BYTE_CHAR(1, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(2, ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY),
        INVALID_USE_OF_SPECIAL_CHARS(3, ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS),
        MAX_SIZE_EXCEEDED(4, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_50_CHAR),
        UNKNOWN(5, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_LAST_CONTACTNAME_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_FIRST_CONTACTNAME_ERROR_REASON {
        CONTAINS_DIGITS(0, ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_CONTAINS_DIGITS),
        DOUBLE_BYTE_CHAR(1, ERROR_MESSAGE.ERROR_MESSAGE_DOBOULE_BYTE_CHARS),
        FIELD_IS_MANDATORY(2, ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY),
        INVALID_USE_OF_SPECIAL_CHARS(3, ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_INVALID_USE_OF_SPECIAL_CHARS),
        MAX_SIZE_EXCEEDED(4, ERROR_MESSAGE.ERROR_MESSAGE_TOO_LONG_50_CHAR),
        UNKNOWN(5, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_FIRST_CONTACTNAME_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_FULFILLMENT_ERROR_REASON {
        BLOCKED_BY_TRADE_COMPLIANCE(0),
        COMPANY_INFO_REQUIRED(1),
        INACTIVE_SERIAL_NUMBER(2),
        INPUT_VALIDATION_ERROR(3),
        REG_COUNT_EXCEEDED(4),
        SERIAL_NUMBER_IS_NON_IPL(5),
        SERIAL_NUMBER_NOT_RECOGNIZED(6),
        SERVER_INTERNAL_ERROR(7),
        TECHNICAL_CONTACT_INFO_REQUIRED(8),
        UNKNOWN(9),
        WRONG_PRODUCT_ID(10),
        IPL_SPECIFIC_SERVER_INTERNAL_ERROR(11),
        TEMPORARY_SERVER_INTERNAL_ERROR(12);

        private final int value;

        private IPL_FULFILLMENT_ERROR_REASON(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }

        public static IPL_FULFILLMENT_ERROR_REASON fromValue(int inValue) {
            for (IPL_FULFILLMENT_ERROR_REASON e : IPL_FULFILLMENT_ERROR_REASON.values()) {
                if (e.value != inValue) continue;
                return e;
            }
            return null;
        }
    }

    public static enum IPL_GENERAL_ERROR_REASON {
        INTERNAL_ERROR(0),
        SERVER_COMMUNICATION_FAILURE(1),
        SERVER_CONNECTION_FAILURE(2),
        SERVER_DECLARED_REQUEST_INVALID(3),
        SERVER_DETECTED_TAMPERING(4),
        SERVER_RESPONSE_INVALID(5),
        TOO_MANY_REQUESTS_FROM_IP(6),
        TRADE_COMPLIANCE_IP_CHECK_FAILED(7),
        INVALID_REQUEST(8),
        UNKNOWN(9);

        private final int value;

        private IPL_GENERAL_ERROR_REASON(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }

        public static IPL_GENERAL_ERROR_REASON fromValue(int inValue) {
            for (IPL_GENERAL_ERROR_REASON e : IPL_GENERAL_ERROR_REASON.values()) {
                if (e.value != inValue) continue;
                return e;
            }
            return null;
        }
    }

    public static enum IPL_SERIALNUMBER_ERROR_REASON {
        FIELD_IS_MANDATORY(0, ERROR_MESSAGE.ERROR_MESSAGE_SERIAL_NUMBER_FIELD_IS_MANDATORY),
        INVALID_FORMAT(1, ERROR_MESSAGE.ERROR_MESSAGE_SERIAL_NUMBER_FIELD_INVALID_FORMAT),
        UNKNOWN(2, ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE);

        private final int value;
        private final ERROR_MESSAGE errorMessage;

        private IPL_SERIALNUMBER_ERROR_REASON(int inValue, ERROR_MESSAGE inErrorMessage) {
            this.value = inValue;
            this.errorMessage = inErrorMessage;
        }

        public int getValue() {
            return this.value;
        }

        public ERROR_MESSAGE getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum IPL_USERINPUTERROR_TYPE {
        CITY_ERROR(0),
        COMPANY_NAME_ERROR(1),
        CONTACT_NAME_ERROR(2),
        COUNTRY_ERROR(3),
        EMAIL_ADDRESS_ERROR(4),
        MULTIINFOTYPE_ERROR(5),
        PHONE_NUMBER_ERROR(6),
        POSTAL_CODE_ERROR(7),
        SERIALNUMBER_ERROR(8),
        STATEORPROVINCE_ERROR(9),
        STREET_ADDRESS_ERROR(10),
        MAILING_ADDRESS_ERROR(11);

        private final int value;

        private IPL_USERINPUTERROR_TYPE(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }

        public static IPL_USERINPUTERROR_TYPE fromValue(int inValue) {
            for (IPL_USERINPUTERROR_TYPE e : IPL_USERINPUTERROR_TYPE.values()) {
                if (e.value != inValue) continue;
                return e;
            }
            return null;
        }
    }

    public static enum IPL_RESPONSE_TYPE {
        IPL_ENTITLEMENT(0),
        IPL_FULFILLMENTERROR(1),
        IPL_GENERALERROR(2),
        IPL_USERINPUTERROR(3);

        private final int value;

        private IPL_RESPONSE_TYPE(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum INFO_REQUIRED {
        NO_INFO_REQUIRED(0),
        COMPANY_INFO_REQUIRED(1),
        TECHNICAL_CONTACT_INFO_REQUIRED(2),
        BOTH_INFO_REQUIRED(3);

        private final int value;

        private INFO_REQUIRED(int inValue) {
            this.value = inValue;
        }

        public int getValue() {
            return this.value;
        }

        public static INFO_REQUIRED fromValue(int inValue) {
            for (INFO_REQUIRED e : INFO_REQUIRED.values()) {
                if (e.value != inValue) continue;
                return e;
            }
            return null;
        }
    }
}

