/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.license;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class LicenseFileHelper {
    public static final String TRIAL_LICENSE_FILE = "sep.slf";
    public static final String UPGRADE_LICENSE_FILE = "sep.slf";
    public static final String OD_LICENSE_FILE = "sep_od.slf";
    private static String licenseFileExtension = ".slf";

    private static String getPath() {
        String retVal = null;
        String rootPath = System.getProperty("catalina.home", "");
        if (rootPath != null && !rootPath.trim().equals("")) {
            retVal = rootPath + File.separator + "etc" + File.separator + "license" + File.separator;
        }
        return retVal;
    }

    public static String getTrialwareFileName() throws Exception {
        String licensePath = LicenseFileHelper.getPath();
        if (licensePath == null) {
            throw new Exception("null license path");
        }
        return licensePath + File.separator + "sep.slf";
    }

    public static String getUpgradeLicenseFileName() throws Exception {
        String licensePath = LicenseFileHelper.getPath();
        if (licensePath == null) {
            throw new Exception("null license path");
        }
        return licensePath + File.separator + "sep.slf";
    }

    public static String getODLicenseFileName() throws Exception {
        String licensePath = LicenseFileHelper.getPath();
        if (licensePath == null) {
            throw new Exception("null license path");
        }
        return licensePath + File.separator + OD_LICENSE_FILE;
    }

    public static String getLicensePath() {
        return LicenseFileHelper.getPath();
    }

    public static String getLicenseFileExtension() {
        return licenseFileExtension;
    }

    public static String getFileContents(String fileName) throws Exception {
        String retVal = null;
        if (fileName == null) {
            throw new Exception("Invalid input");
        }
        try (FileInputStream is = new FileInputStream(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
            char[] buffer = new char[1024];
            int len = reader.read(buffer);
            if (len > 0) {
                StringBuffer fileData = new StringBuffer();
                while (len > 0) {
                    fileData.append(buffer, 0, len);
                    len = reader.read(buffer);
                }
                retVal = fileData.toString();
            }
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
            throw e;
        }
        return retVal;
    }

    public static void writeFileContents(String fileName, String contents) throws Exception {
        if (fileName == null || contents == null) {
            throw new Exception("Invalid inputs");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception(fileName + " does not exist");
        }
        if (!file.canWrite()) {
            Utility.delete(file);
            if (!file.createNewFile()) {
                throw new Exception(fileName + " fails to be created.");
            }
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));){
            ((OutputStream)os).write(contents.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)os).flush();
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            throw e;
        }
    }
}

