/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.i18n;

import com.sygate.scm.common.i18n.MessageResources;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ImageResource {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static HashMap<ResourceCacheKey, String> cache = new HashMap();

    public static URL getLocalResource(String key) {
        return ImageResource.getLocalResource(key, Locale.getDefault());
    }

    public static URL getLocalResource(String key, Locale locale) {
        return MessageResources.getClassLoader().getResource(ImageResource.getLocalFileName(key, locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalFileName(String key, Locale locale) {
        if (key == null) {
            return null;
        }
        HashMap<ResourceCacheKey, String> hashMap = cache;
        synchronized (hashMap) {
            Object lookup;
            String resourceName;
            String baseName;
            cacheKey.setKeyValues(key, locale);
            String result = cache.get(cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            String suffix = "";
            int i = key.lastIndexOf(46);
            if (i != -1) {
                baseName = key.substring(0, i);
                suffix = key.substring(i);
            } else {
                baseName = key;
            }
            List<String> names = ImageResource.calculateBundleNames(baseName, locale);
            for (int j = names.size() - 1; j >= 0; --j) {
                resourceName = names.get(j);
                lookup = ImageResource.findResource(resourceName + suffix);
                if (lookup == null) continue;
                String value = resourceName + suffix;
                ImageResource.putResourceNameIntoCache(key, locale, value);
                return value;
            }
            List<String> defaultNames = ImageResource.calculateBundleNames(baseName, Locale.getDefault());
            for (int j = defaultNames.size() - 1; j >= 0 && !names.contains(resourceName = defaultNames.get(j)); --j) {
                lookup = ImageResource.findResource(resourceName + suffix);
                if (lookup == null) continue;
                String value = resourceName + suffix;
                ImageResource.putResourceNameIntoCache(key, locale, value);
                return value;
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putResourceNameIntoCache(String key, Locale locale, String value) {
        HashMap<ResourceCacheKey, String> hashMap = cache;
        synchronized (hashMap) {
            cacheKey.setKeyValues(key, locale);
            cache.put((ResourceCacheKey)cacheKey.clone(), value);
            cacheKey.clear();
            cache.notifyAll();
        }
    }

    private static Object findResource(String resourceName) {
        return MessageResources.getClassLoader().getResource(resourceName);
    }

    private static List<String> calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(temp.toString());
        return result;
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                return !(this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                ResourceCacheKey clone = (ResourceCacheKey)super.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(String searchName, Locale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues("", null);
        }
    }
}

