/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.i18n;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.LocalizedStrings;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.template.TemplateManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenerateLocalLUCC {
    private static String NAME_PREFIX = "LuSesmContentCatalog";

    public static void main(String[] args) throws Exception {
    }

    public static LuSesmContentCatalog resolveI18nTags(String luCatalogPath, Map<String, String> resourceMap) throws SAXException, IOException, ValidationException, ParserConfigurationException {
        String xmlFile = TemplateManager.getTemplate(new File(luCatalogPath)).getXML();
        return GenerateLocalLUCC.resolveI18nTagsFromXml(xmlFile, resourceMap);
    }

    public static LuSesmContentCatalog resolveI18nTagsFromXml(String xmlContent, String resourceDir) throws SAXException, IOException, ValidationException, ParserConfigurationException {
        File file;
        HashMap<String, String> resMap = new HashMap<String, String>();
        File[] resFiles = new File(resourceDir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NAME_PREFIX + "_") && name.endsWith(".properties");
            }
        });
        boolean enFound = false;
        if (resFiles != null) {
            for (int i = 0; i < resFiles.length; ++i) {
                String fileName = resFiles[i].getName();
                String lang = fileName.substring(NAME_PREFIX.length() + 1, fileName.indexOf(".properties"));
                if ("en".equals(lang)) {
                    enFound = true;
                }
                if ("".equals(lang)) continue;
                resMap.put(lang, resFiles[i].getAbsolutePath());
            }
        }
        if (!enFound && (file = new File(resourceDir + File.separator + NAME_PREFIX + ".properties")).exists()) {
            resMap.put("en", file.getAbsolutePath());
        }
        return GenerateLocalLUCC.resolveI18nTagsFromXml(xmlContent, resMap);
    }

    public static LuSesmContentCatalog resolveI18nTagsFromXml(String xmlContent, Map<String, String> resourceMap) throws SAXException, IOException, ValidationException, ParserConfigurationException {
        Map<String, Properties> resKeypairMap = GenerateLocalLUCC.loadKeypairs(resourceMap);
        LuSesmContentCatalog luCatGroupList = (LuSesmContentCatalog)AbstractSchema.readXML(xmlContent);
        for (LuContentCategoryGroup catGroup : luCatGroupList.getLuContentCategoryGroup()) {
            Vector<LocalizedStrings> catGroupLSs = catGroup.getLocalizedStrings();
            if (catGroupLSs.size() != 1) {
                throw new ValidationException("LocalizedString node must have and only has one!");
            }
            LocalizedStrings catGroupLS = catGroupLSs.get(0);
            GenerateLocalLUCC.addAllLocalizedStrings(catGroup, catGroupLS, resKeypairMap);
            for (LuContentCategory category : catGroup.getLuContentCategory()) {
                Vector<LocalizedStrings> catLSs = category.getLocalizedStrings();
                if (catLSs.size() != 1) {
                    throw new ValidationException("LocalizedString node must have and only has one!");
                }
                LocalizedStrings catLS = catLSs.get(0);
                GenerateLocalLUCC.addAllLocalizedStrings(category, catLS, resKeypairMap);
                for (LuRegistration reg : category.getLuRegistration()) {
                    Vector<LocalizedStrings> regtLSs = reg.getLocalizedStrings();
                    if (regtLSs.size() != 1) {
                        throw new ValidationException("LocalizedString node must have and only has one!");
                    }
                    LocalizedStrings regLS = regtLSs.get(0);
                    GenerateLocalLUCC.addAllLocalizedStrings(reg, regLS, resKeypairMap);
                }
            }
        }
        return luCatGroupList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Properties> loadKeypairs(Map<String, String> resourceMap) throws IOException {
        HashMap<String, Properties> retMap = new HashMap<String, Properties>();
        for (Map.Entry<String, String> entry : resourceMap.entrySet()) {
            BufferedInputStream bis = null;
            FileInputStream tmpIS = null;
            Properties prop = null;
            try {
                tmpIS = new FileInputStream(entry.getValue());
                bis = new BufferedInputStream(tmpIS);
                prop = new Properties();
                prop.load(bis);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(tmpIS);
                throw throwable;
            }
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(tmpIS);
            if (prop == null) continue;
            retMap.put(entry.getKey(), prop);
        }
        return retMap;
    }

    private static void addAllLocalizedStrings(ConfigObject configObject, LocalizedStrings enLocalizedStrings, Map<String, Properties> resKeypairMap) throws ValidationException, ParserConfigurationException {
        LocalizedStrings ls = null;
        String keyName = enLocalizedStrings.getOptDisplayName();
        String keyDesc = enLocalizedStrings.getOptDescription();
        String keyAlias = enLocalizedStrings.getOptAlias();
        if (!(keyName != null && keyName.startsWith("$$") || keyDesc != null && keyDesc.startsWith("$$") || keyAlias != null && keyAlias.startsWith("$$"))) {
            return;
        }
        for (Map.Entry<String, Properties> resKey : resKeypairMap.entrySet()) {
            String alias;
            String desc;
            String name;
            String language = resKey.getKey();
            Properties prop = resKey.getValue();
            ls = language.equals("en") ? enLocalizedStrings : GenerateLocalLUCC.cloneLocalizedStrings(enLocalizedStrings);
            ls.setLocale(language);
            if (keyName != null && (name = prop.getProperty(keyName)) != null) {
                ls.setOptDisplayName(name);
            }
            if (keyDesc != null && (desc = prop.getProperty(keyDesc)) != null) {
                ls.setOptDescription(desc);
            }
            if (keyAlias != null && (alias = prop.getProperty(keyAlias)) != null) {
                ls.setOptAlias(alias);
            }
            if (language.equals("en")) continue;
            configObject.addChild(ls);
        }
    }

    private static LocalizedStrings cloneLocalizedStrings(LocalizedStrings ls) throws ValidationException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element element = ls.exportToElement(doc);
        LocalizedStrings localizedStrings = new LocalizedStrings(false);
        localizedStrings.importFromElement(element);
        return localizedStrings;
    }
}

