/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.firewall;

public class Port
implements Comparable<Object> {
    private String portNumber;
    private String portName;
    private boolean selected;

    public Port(String portNumber, String name) {
        this.portNumber = portNumber;
        this.portName = name;
    }

    public String getName() {
        return this.portName;
    }

    public String getNumber() {
        return this.portNumber;
    }

    public String toString() {
        return this.portName;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setSelected(String portNumber) {
        if (this.portNumber.equals(portNumber)) {
            this.selected = true;
        }
    }

    public void setSelectedInRange(String portMin, String portMax) {
        if (this.inRange(portMin, portMax)) {
            this.selected = true;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean equals(Object ob) {
        if (ob instanceof Port) {
            int index = this.compareTo(ob);
            return index == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.portNumber == null ? "".hashCode() : this.portNumber.hashCode();
    }

    public boolean inRange(Object objMin, Object objMax) {
        return this.compareTo(objMin) >= 0 && this.compareTo(objMax) <= 0;
    }

    @Override
    public int compareTo(Object ob) {
        String strPortNumber = "";
        try {
            strPortNumber = ob instanceof Port ? ((Port)ob).getNumber() : ob.toString();
            int portNumberToCompare = strPortNumber.startsWith("0x") || strPortNumber.startsWith("0X") ? Integer.parseInt(strPortNumber.substring(2, strPortNumber.length()), 16) : Integer.parseInt(strPortNumber);
            String strCurrentPortNumber = this.getNumber();
            int currentPortNumber = strCurrentPortNumber.startsWith("0x") || strCurrentPortNumber.startsWith("0X") ? Integer.parseInt(strCurrentPortNumber.substring(2, strCurrentPortNumber.length()), 16) : Integer.parseInt(strCurrentPortNumber);
            if (currentPortNumber > portNumberToCompare) {
                return 1;
            }
            if (currentPortNumber < portNumberToCompare) {
                return -1;
            }
            return 0;
        }
        catch (Exception ex) {
            return -100;
        }
    }
}

