/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.table;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemComputerNic
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String computerId;
    private byte[] ipAddr;
    private String macAddr;
    private byte[] gateway;
    private Integer subnetMask;
    private Integer nicNumber;

    public SemComputerNic() {
        this.nameSpace = "table";
    }

    @Override
    public String getObjectTypeName() {
        return "SemComputerNic";
    }

    public String getComputerId() {
        return this.computerId;
    }

    public void setComputerId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.computerId = value;
    }

    public byte[] getOptIpAddr() {
        if (this.ipAddr == null) {
            return Utility.fromHexString("");
        }
        return Arrays.copyOf(this.ipAddr, this.ipAddr.length);
    }

    public void setOptIpAddr(byte[] value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ipAddr = (byte[])(value == null ? null : Arrays.copyOf(value, value.length));
    }

    public String getOptMacAddr() {
        if (this.macAddr == null) {
            return "";
        }
        return this.macAddr;
    }

    public void setOptMacAddr(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.macAddr = value;
    }

    public byte[] getOptGateway() {
        if (this.gateway == null) {
            return Utility.fromHexString("");
        }
        return Arrays.copyOf(this.gateway, this.gateway.length);
    }

    public void setOptGateway(byte[] value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.gateway = (byte[])(value == null ? null : Arrays.copyOf(value, value.length));
    }

    public Integer getOptSubnetMask() {
        if (this.subnetMask == null) {
            return 0;
        }
        return this.subnetMask;
    }

    public void setOptSubnetMask(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.subnetMask = value;
    }

    public Integer getOptNicNumber() {
        if (this.nicNumber == null) {
            return 0;
        }
        return this.nicNumber;
    }

    public void setOptNicNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.nicNumber = value;
    }

    @Override
    public int getObjectType() {
        return 196617;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.computerId == null) {
            throw new ValidationException("SemComputerNic/ComputerId: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block20: {
            try {
                String value = attris.getValue("ComputerId");
                if (value == null) {
                    throw new ValidationException("SemComputerNic/ComputerId: attribute is required!");
                }
                this.computerId = value;
                value = attris.getValue("IpAddr");
                if (value != null) {
                    try {
                        this.ipAddr = Utility.fromHexString(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("SemComputerNic/IpAddr: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("SemComputerNic/IpAddr: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("MacAddr")) != null) {
                    this.macAddr = value;
                }
                if ((value = attris.getValue("Gateway")) != null) {
                    try {
                        this.gateway = Utility.fromHexString(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("SemComputerNic/Gateway: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("SemComputerNic/Gateway: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("SubnetMask")) != null) {
                    try {
                        this.subnetMask = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("SemComputerNic/SubnetMask: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("SemComputerNic/SubnetMask: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("NicNumber")) == null) break block20;
                try {
                    this.nicNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemComputerNic/NicNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemComputerNic/NicNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SemComputerNic".equals(element.getNodeName())) {
            throw new ValidationException("SemComputerNic: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ComputerId");
        if (value == null) {
            throw new ValidationException("SemComputerNic/ComputerId: attribute is required!");
        }
        this.computerId = value;
        value = XMLHelper.getAttribute(element, "IpAddr");
        if (value != null) {
            try {
                this.ipAddr = Utility.fromHexString(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemComputerNic/IpAddr: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MacAddr")) != null) {
            this.macAddr = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Gateway")) != null) {
            try {
                this.gateway = Utility.fromHexString(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemComputerNic/Gateway: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SubnetMask")) != null) {
            try {
                this.subnetMask = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemComputerNic/SubnetMask: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "NicNumber")) != null) {
            try {
                this.nicNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemComputerNic/NicNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SemComputerNic");
        if (this.computerId != null) {
            element.setAttribute("ComputerId", this.computerId);
        }
        if (this.ipAddr != null) {
            element.setAttribute("IpAddr", Utility.toHexString(this.ipAddr));
        }
        if (this.macAddr != null) {
            element.setAttribute("MacAddr", this.macAddr);
        }
        if (this.gateway != null) {
            element.setAttribute("Gateway", Utility.toHexString(this.gateway));
        }
        if (this.subnetMask != null) {
            element.setAttribute("SubnetMask", this.subnetMask.toString());
        }
        if (this.nicNumber != null) {
            element.setAttribute("NicNumber", this.nicNumber.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemComputerNic ");
            if (this.computerId != null) {
                strAttrs.append("ComputerId=\"").append(AbstractSchema.checkXMLContent(this.computerId)).append("\" ");
            }
            if (this.ipAddr != null) {
                strAttrs.append("IpAddr=\"").append(Utility.toHexString(this.ipAddr)).append("\" ");
            }
            if (this.macAddr != null) {
                strAttrs.append("MacAddr=\"").append(AbstractSchema.checkXMLContent(this.macAddr)).append("\" ");
            }
            if (this.gateway != null) {
                strAttrs.append("Gateway=\"").append(Utility.toHexString(this.gateway)).append("\" ");
            }
            if (this.subnetMask != null) {
                strAttrs.append("SubnetMask=\"").append(this.subnetMask.toString()).append("\" ");
            }
            if (this.nicNumber != null) {
                strAttrs.append("NicNumber=\"").append(this.nicNumber.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemComputerNic>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

