/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.secars;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.secars.Group;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UpdateGroups
extends AbstractSchema {
    public static final Integer Refresh = 0;
    public static final Integer Change = 1;
    private static final long serialVersionUID = 1L;
    private Integer action;

    public UpdateGroups() {
        this.children.put(458754, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "UpdateGroups";
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "Refresh";
                break;
            }
            case 1: {
                s = "Change";
                break;
            }
            default: {
                throw new ValidationException("UpdateGroups/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("Refresh".equals(value)) {
            this.action = Refresh;
        } else if ("Change".equals(value)) {
            this.action = Change;
        } else {
            throw new ValidationException("UpdateGroups/Action: invalid attribute value:" + value + "!");
        }
    }

    public void addGroup(Group value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addGroup(int index, Group value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Group> getGroup() {
        Vector<Group> v = new Vector<Group>();
        for (Transportable child : (ChildGroup)this.children.get(458754)) {
            v.add((Group)child);
        }
        return v;
    }

    public int getGroupCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(458754);
        return childGroup.size();
    }

    public Group getGroup(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(458754);
        return (Group)childGroup.get(index);
    }

    public void setGroup(int index, Group value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeGroup(Group value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 458753;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("UpdateGroups/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof Group) {
            try {
                this.addGroup((Group)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Action");
            if (value == null) {
                throw new ValidationException("UpdateGroups/Action: attribute is required!");
            }
            this.setActionValue(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getGroupCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getGroup(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"UpdateGroups".equals(element.getNodeName())) {
            throw new ValidationException("UpdateGroups: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Action");
        if (value == null) {
            throw new ValidationException("UpdateGroups/Action: attribute is required!");
        }
        this.setActionValue(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "Group");
        for (int i = 0; i < v.size(); ++i) {
            Group groupObj = new Group();
            groupObj.importFromElement(v.get(i));
            this.addGroup(groupObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("UpdateGroups");
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<UpdateGroups ");
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</UpdateGroups>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

