/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.secars;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.secars.AlternateClientPackage;
import com.sygate.scm.common.configobject.secars.ClientPackage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Group
extends AbstractSchema {
    public static final Integer Refresh = 0;
    public static final Integer Change = 1;
    private static final long serialVersionUID = 1L;
    private String gUID;
    private Integer action;
    private Boolean isLowBandwidth;

    public Group() {
        this.children.put(458755, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(458756, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "Group";
    }

    public String getGUID() {
        return this.gUID;
    }

    public void setGUID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.gUID = value;
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "Refresh";
                break;
            }
            case 1: {
                s = "Change";
                break;
            }
            default: {
                throw new ValidationException("Group/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("Refresh".equals(value)) {
            this.action = Refresh;
        } else if ("Change".equals(value)) {
            this.action = Change;
        } else {
            throw new ValidationException("Group/Action: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefisLowBandwidth() {
        return Boolean.TRUE;
    }

    public Boolean getisLowBandwidth() {
        return this.isLowBandwidth;
    }

    public void setisLowBandwidth(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.isLowBandwidth = value;
    }

    public void addClientPackage(ClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addClientPackage(int index, ClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ClientPackage> getClientPackage() {
        Vector<ClientPackage> v = new Vector<ClientPackage>();
        for (Transportable child : (ChildGroup)this.children.get(458755)) {
            v.add((ClientPackage)child);
        }
        return v;
    }

    public int getClientPackageCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(458755);
        return childGroup.size();
    }

    public ClientPackage getClientPackage(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(458755);
        return (ClientPackage)childGroup.get(index);
    }

    public void setClientPackage(int index, ClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeClientPackage(ClientPackage value) {
        this.removeChild(value);
    }

    public void addAlternateClientPackage(AlternateClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addAlternateClientPackage(int index, AlternateClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<AlternateClientPackage> getAlternateClientPackage() {
        Vector<AlternateClientPackage> v = new Vector<AlternateClientPackage>();
        for (Transportable child : (ChildGroup)this.children.get(458756)) {
            v.add((AlternateClientPackage)child);
        }
        return v;
    }

    public int getAlternateClientPackageCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(458756);
        return childGroup.size();
    }

    public AlternateClientPackage getAlternateClientPackage(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(458756);
        return (AlternateClientPackage)childGroup.get(index);
    }

    public void setAlternateClientPackage(int index, AlternateClientPackage value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeAlternateClientPackage(AlternateClientPackage value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 458754;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.gUID == null) {
            throw new ValidationException("Group/GUID: attribute is required!");
        }
        if (this.action == null) {
            throw new ValidationException("Group/Action: attribute is required!");
        }
        if (this.isLowBandwidth == null) {
            throw new ValidationException("Group/isLowBandwidth: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ClientPackage) {
            try {
                this.addClientPackage((ClientPackage)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AlternateClientPackage) {
            try {
                this.addAlternateClientPackage((AlternateClientPackage)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("GUID");
            if (value == null) {
                throw new ValidationException("Group/GUID: attribute is required!");
            }
            this.gUID = value;
            value = attris.getValue("Action");
            if (value == null) {
                throw new ValidationException("Group/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("isLowBandwidth");
            if (value == null) {
                throw new ValidationException("Group/isLowBandwidth: attribute is required!");
            }
            this.isLowBandwidth = "1".equals(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getClientPackageCount();
        for (i = 0; i < objCnt; ++i) {
            this.getClientPackage(i).setReadonly();
        }
        objCnt = this.getAlternateClientPackageCount();
        for (i = 0; i < objCnt; ++i) {
            this.getAlternateClientPackage(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"Group".equals(element.getNodeName())) {
            throw new ValidationException("Group: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "GUID");
        if (value == null) {
            throw new ValidationException("Group/GUID: attribute is required!");
        }
        this.gUID = value;
        value = XMLHelper.getAttribute(element, "Action");
        if (value == null) {
            throw new ValidationException("Group/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "isLowBandwidth");
        if (value == null) {
            throw new ValidationException("Group/isLowBandwidth: attribute is required!");
        }
        this.isLowBandwidth = "1".equals(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ClientPackage");
        for (i = 0; i < v.size(); ++i) {
            ClientPackage clientPackageObj = new ClientPackage();
            clientPackageObj.importFromElement(v.get(i));
            this.addClientPackage(clientPackageObj);
        }
        v = XMLHelper.getChildElementByName(element, "AlternateClientPackage");
        for (i = 0; i < v.size(); ++i) {
            AlternateClientPackage alternateClientPackageObj = new AlternateClientPackage();
            alternateClientPackageObj.importFromElement(v.get(i));
            this.addAlternateClientPackage(alternateClientPackageObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Group");
        if (this.gUID != null) {
            element.setAttribute("GUID", this.gUID);
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.isLowBandwidth != null) {
            element.setAttribute("isLowBandwidth", this.isLowBandwidth != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Group ");
            if (this.gUID != null) {
                strAttrs.append("GUID=\"").append(AbstractSchema.checkXMLContent(this.gUID)).append("\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.isLowBandwidth != null) {
                strAttrs.append("isLowBandwidth=").append(this.isLowBandwidth != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Group>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

