/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WindowsIntegration
extends ConfigObject {
    public static final Integer NO_ACTION = 0;
    public static final Integer DISABLE_ONCE_ONLY = 1;
    public static final Integer DISABLE_ALWAYS = 2;
    public static final Integer RESTORE_IF_DISABLED = 3;
    private static final long serialVersionUID = 1L;
    private Integer disableWindowsFW;
    private Boolean windowsFWDisabledMessage;

    public WindowsIntegration() {
        this(true);
    }

    public WindowsIntegration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "WindowsIntegration";
    }

    public Integer getDefDisableWindowsFW() {
        return DISABLE_ONCE_ONLY;
    }

    public Integer getOptDisableWindowsFW() {
        return this.disableWindowsFW;
    }

    public String getOptDisableWindowsFWValue() throws ValidationException {
        if (this.disableWindowsFW == null) {
            return null;
        }
        String s = null;
        switch (this.disableWindowsFW) {
            case 0: {
                s = "NO_ACTION";
                break;
            }
            case 1: {
                s = "DISABLE_ONCE_ONLY";
                break;
            }
            case 2: {
                s = "DISABLE_ALWAYS";
                break;
            }
            case 3: {
                s = "RESTORE_IF_DISABLED";
                break;
            }
            default: {
                throw new ValidationException("WindowsIntegration/DisableWindowsFW: invalid attribute value:" + this.disableWindowsFW + "!");
            }
        }
        return s;
    }

    public void setOptDisableWindowsFW(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableWindowsFW = value;
    }

    public void setOptDisableWindowsFWValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.disableWindowsFW = null;
            return;
        }
        if ("NO_ACTION".equals(value)) {
            this.disableWindowsFW = NO_ACTION;
        } else if ("DISABLE_ONCE_ONLY".equals(value)) {
            this.disableWindowsFW = DISABLE_ONCE_ONLY;
        } else if ("DISABLE_ALWAYS".equals(value)) {
            this.disableWindowsFW = DISABLE_ALWAYS;
        } else if ("RESTORE_IF_DISABLED".equals(value)) {
            this.disableWindowsFW = RESTORE_IF_DISABLED;
        } else {
            throw new ValidationException("WindowsIntegration/DisableWindowsFW: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefWindowsFWDisabledMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptWindowsFWDisabledMessage() {
        return this.windowsFWDisabledMessage;
    }

    public void setOptWindowsFWDisabledMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.windowsFWDisabledMessage = value;
    }

    @Override
    public int getObjectType() {
        return 383;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DisableWindowsFW");
            if (value != null) {
                this.setOptDisableWindowsFWValue(value);
            }
            if ((value = attris.getValue("WindowsFWDisabledMessage")) != null) {
                this.windowsFWDisabledMessage = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"WindowsIntegration".equals(element.getNodeName())) {
            throw new ValidationException("WindowsIntegration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DisableWindowsFW");
        if (value != null) {
            this.setOptDisableWindowsFWValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "WindowsFWDisabledMessage")) != null) {
            this.windowsFWDisabledMessage = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("WindowsIntegration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("WindowsIntegration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("WindowsIntegration");
        if (this.disableWindowsFW != null) {
            element.setAttribute("DisableWindowsFW", this.getOptDisableWindowsFWValue());
        }
        if (this.windowsFWDisabledMessage != null) {
            element.setAttribute("WindowsFWDisabledMessage", this.windowsFWDisabledMessage != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<WindowsIntegration ");
            if (this.disableWindowsFW != null) {
                strAttrs.append("DisableWindowsFW=\"").append(this.getOptDisableWindowsFWValue()).append("\" ");
            }
            if (this.windowsFWDisabledMessage != null) {
                strAttrs.append("WindowsFWDisabledMessage=").append(this.windowsFWDisabledMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</WindowsIntegration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

