/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WhitelistLiveUpdateConfig
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer syncFreq;
    private String urlForIndex;
    private String userNameForIndex;
    private String passwordForIndex;
    private String urlForContent;
    private String userNameForContent;
    private String passwordForContent;

    public WhitelistLiveUpdateConfig() {
        this(true);
    }

    public WhitelistLiveUpdateConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "WhitelistLiveUpdateConfig";
    }

    public Boolean getDefEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getOptSyncFreq() {
        return this.syncFreq;
    }

    public void setOptSyncFreq(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.syncFreq = value;
    }

    public String getOptUrlForIndex() {
        return this.urlForIndex;
    }

    public void setOptUrlForIndex(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.urlForIndex = value;
    }

    public String getOptUserNameForIndex() {
        return this.userNameForIndex;
    }

    public void setOptUserNameForIndex(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userNameForIndex = value;
    }

    public String getOptPasswordForIndex() {
        try {
            return Utility.decrypt(this.passwordForIndex);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptPasswordForIndex(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.passwordForIndex = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOptUrlForContent() {
        return this.urlForContent;
    }

    public void setOptUrlForContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.urlForContent = value;
    }

    public String getOptUserNameForContent() {
        return this.userNameForContent;
    }

    public void setOptUserNameForContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.userNameForContent = value;
    }

    public String getOptPasswordForContent() {
        try {
            return Utility.decrypt(this.passwordForContent);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptPasswordForContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.passwordForContent = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getObjectType() {
        return 58;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("SyncFreq")) != null) {
                try {
                    this.syncFreq = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("WhitelistLiveUpdateConfig/SyncFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("WhitelistLiveUpdateConfig/SyncFreq: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("UrlForIndex")) != null) {
                this.urlForIndex = value;
            }
            if ((value = attris.getValue("UserNameForIndex")) != null) {
                this.userNameForIndex = value;
            }
            if ((value = attris.getValue("PasswordForIndex")) != null) {
                this.passwordForIndex = value;
            }
            if ((value = attris.getValue("UrlForContent")) != null) {
                this.urlForContent = value;
            }
            if ((value = attris.getValue("UserNameForContent")) != null) {
                this.userNameForContent = value;
            }
            if ((value = attris.getValue("PasswordForContent")) != null) {
                this.passwordForContent = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"WhitelistLiveUpdateConfig".equals(element.getNodeName())) {
            throw new ValidationException("WhitelistLiveUpdateConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SyncFreq")) != null) {
            try {
                this.syncFreq = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("WhitelistLiveUpdateConfig/SyncFreq: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "UrlForIndex")) != null) {
            this.urlForIndex = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UserNameForIndex")) != null) {
            this.userNameForIndex = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PasswordForIndex")) != null) {
            this.passwordForIndex = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UrlForContent")) != null) {
            this.urlForContent = value;
        }
        if ((value = XMLHelper.getAttribute(element, "UserNameForContent")) != null) {
            this.userNameForContent = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PasswordForContent")) != null) {
            this.passwordForContent = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("WhitelistLiveUpdateConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("WhitelistLiveUpdateConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("WhitelistLiveUpdateConfig");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.syncFreq != null) {
            element.setAttribute("SyncFreq", this.syncFreq.toString());
        }
        if (this.urlForIndex != null) {
            element.setAttribute("UrlForIndex", this.urlForIndex);
        }
        if (this.userNameForIndex != null) {
            element.setAttribute("UserNameForIndex", this.userNameForIndex);
        }
        if (this.passwordForIndex != null) {
            element.setAttribute("PasswordForIndex", this.passwordForIndex);
        }
        if (this.urlForContent != null) {
            element.setAttribute("UrlForContent", this.urlForContent);
        }
        if (this.userNameForContent != null) {
            element.setAttribute("UserNameForContent", this.userNameForContent);
        }
        if (this.passwordForContent != null) {
            element.setAttribute("PasswordForContent", this.passwordForContent);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<WhitelistLiveUpdateConfig ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.syncFreq != null) {
                strAttrs.append("SyncFreq=\"").append(this.syncFreq.toString()).append("\" ");
            }
            if (this.urlForIndex != null) {
                strAttrs.append("UrlForIndex=\"").append(AbstractSchema.checkXMLContent(this.urlForIndex)).append("\" ");
            }
            if (this.userNameForIndex != null) {
                strAttrs.append("UserNameForIndex=\"").append(AbstractSchema.checkXMLContent(this.userNameForIndex)).append("\" ");
            }
            if (this.passwordForIndex != null) {
                strAttrs.append("PasswordForIndex=\"").append(AbstractSchema.checkXMLContent(this.passwordForIndex)).append("\" ");
            }
            if (this.urlForContent != null) {
                strAttrs.append("UrlForContent=\"").append(AbstractSchema.checkXMLContent(this.urlForContent)).append("\" ");
            }
            if (this.userNameForContent != null) {
                strAttrs.append("UserNameForContent=\"").append(AbstractSchema.checkXMLContent(this.userNameForContent)).append("\" ");
            }
            if (this.passwordForContent != null) {
                strAttrs.append("PasswordForContent=\"").append(AbstractSchema.checkXMLContent(this.passwordForContent)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</WhitelistLiveUpdateConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

