/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VersionInformation
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String productFriendlyName;
    private String productIdentifier;
    private Integer majorVersionNumber;
    private Integer minorVersionNumber;
    private Integer buildVersionNumber;

    public VersionInformation() {
        this(true);
    }

    public VersionInformation(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "VersionInformation";
    }

    public String getProductFriendlyName() {
        return this.productFriendlyName;
    }

    public void setProductFriendlyName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productFriendlyName = value;
    }

    public String getProductIdentifier() {
        return this.productIdentifier;
    }

    public void setProductIdentifier(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productIdentifier = value;
    }

    public Integer getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public void setMajorVersionNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.majorVersionNumber = value;
    }

    public Integer getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public void setMinorVersionNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.minorVersionNumber = value;
    }

    public Integer getBuildVersionNumber() {
        return this.buildVersionNumber;
    }

    public void setBuildVersionNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.buildVersionNumber = value;
    }

    @Override
    public int getObjectType() {
        return 799;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.productFriendlyName == null) {
            throw new ValidationException("VersionInformation/ProductFriendlyName: attribute is required!");
        }
        if (this.productIdentifier == null) {
            throw new ValidationException("VersionInformation/ProductIdentifier: attribute is required!");
        }
        if (this.majorVersionNumber == null) {
            throw new ValidationException("VersionInformation/MajorVersionNumber: attribute is required!");
        }
        if (this.minorVersionNumber == null) {
            throw new ValidationException("VersionInformation/MinorVersionNumber: attribute is required!");
        }
        if (this.buildVersionNumber == null) {
            throw new ValidationException("VersionInformation/BuildVersionNumber: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ProductFriendlyName");
            if (value == null) {
                throw new ValidationException("VersionInformation/ProductFriendlyName: attribute is required!");
            }
            this.productFriendlyName = value;
            value = attris.getValue("ProductIdentifier");
            if (value == null) {
                throw new ValidationException("VersionInformation/ProductIdentifier: attribute is required!");
            }
            this.productIdentifier = value;
            value = attris.getValue("MajorVersionNumber");
            if (value == null) {
                throw new ValidationException("VersionInformation/MajorVersionNumber: attribute is required!");
            }
            try {
                this.majorVersionNumber = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("VersionInformation/MajorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("VersionInformation/MajorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("MinorVersionNumber");
            if (value == null) {
                throw new ValidationException("VersionInformation/MinorVersionNumber: attribute is required!");
            }
            try {
                this.minorVersionNumber = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("VersionInformation/MinorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("VersionInformation/MinorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("BuildVersionNumber");
            if (value == null) {
                throw new ValidationException("VersionInformation/BuildVersionNumber: attribute is required!");
            }
            try {
                this.buildVersionNumber = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("VersionInformation/BuildVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("VersionInformation/BuildVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"VersionInformation".equals(element.getNodeName())) {
            throw new ValidationException("VersionInformation: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ProductFriendlyName");
        if (value == null) {
            throw new ValidationException("VersionInformation/ProductFriendlyName: attribute is required!");
        }
        this.productFriendlyName = value;
        value = XMLHelper.getAttribute(element, "ProductIdentifier");
        if (value == null) {
            throw new ValidationException("VersionInformation/ProductIdentifier: attribute is required!");
        }
        this.productIdentifier = value;
        value = XMLHelper.getAttribute(element, "MajorVersionNumber");
        if (value == null) {
            throw new ValidationException("VersionInformation/MajorVersionNumber: attribute is required!");
        }
        try {
            this.majorVersionNumber = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("VersionInformation/MajorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("VersionInformation/MajorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "MinorVersionNumber");
        if (value == null) {
            throw new ValidationException("VersionInformation/MinorVersionNumber: attribute is required!");
        }
        try {
            this.minorVersionNumber = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("VersionInformation/MinorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("VersionInformation/MinorVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "BuildVersionNumber");
        if (value == null) {
            throw new ValidationException("VersionInformation/BuildVersionNumber: attribute is required!");
        }
        try {
            this.buildVersionNumber = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("VersionInformation/BuildVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("VersionInformation/BuildVersionNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("VersionInformation/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("VersionInformation/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("VersionInformation");
        if (this.productFriendlyName != null) {
            element.setAttribute("ProductFriendlyName", this.productFriendlyName);
        }
        if (this.productIdentifier != null) {
            element.setAttribute("ProductIdentifier", this.productIdentifier);
        }
        if (this.majorVersionNumber != null) {
            element.setAttribute("MajorVersionNumber", this.majorVersionNumber.toString());
        }
        if (this.minorVersionNumber != null) {
            element.setAttribute("MinorVersionNumber", this.minorVersionNumber.toString());
        }
        if (this.buildVersionNumber != null) {
            element.setAttribute("BuildVersionNumber", this.buildVersionNumber.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<VersionInformation ");
            if (this.productFriendlyName != null) {
                strAttrs.append("ProductFriendlyName=\"").append(AbstractSchema.checkXMLContent(this.productFriendlyName)).append("\" ");
            }
            if (this.productIdentifier != null) {
                strAttrs.append("ProductIdentifier=\"").append(AbstractSchema.checkXMLContent(this.productIdentifier)).append("\" ");
            }
            if (this.majorVersionNumber != null) {
                strAttrs.append("MajorVersionNumber=\"").append(this.majorVersionNumber.toString()).append("\" ");
            }
            if (this.minorVersionNumber != null) {
                strAttrs.append("MinorVersionNumber=\"").append(this.minorVersionNumber.toString()).append("\" ");
            }
            if (this.buildVersionNumber != null) {
                strAttrs.append("BuildVersionNumber=\"").append(this.buildVersionNumber.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</VersionInformation>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

