/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ArbitrationPolicy;
import com.sygate.scm.common.configobject.schema.GeneralGui;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserInterface
extends ConfigObject {
    public static final Integer SERVER_CTRL = 0;
    public static final Integer CLIENT_CTRL = 1;
    public static final Integer MIXED_CTRL = 2;
    private static final long serialVersionUID = 1L;
    private Integer mode;

    public UserInterface() {
        this(true);
    }

    public UserInterface(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(221, new ChildGroup(1, 1));
        this.children.put(227, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "UserInterface";
    }

    public Integer getDefMode() {
        return SERVER_CTRL;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "SERVER_CTRL";
                break;
            }
            case 1: {
                s = "CLIENT_CTRL";
                break;
            }
            case 2: {
                s = "MIXED_CTRL";
                break;
            }
            default: {
                throw new ValidationException("UserInterface/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("SERVER_CTRL".equals(value)) {
            this.mode = SERVER_CTRL;
        } else if ("CLIENT_CTRL".equals(value)) {
            this.mode = CLIENT_CTRL;
        } else if ("MIXED_CTRL".equals(value)) {
            this.mode = MIXED_CTRL;
        } else {
            throw new ValidationException("UserInterface/Mode: invalid attribute value:" + value + "!");
        }
    }

    public GeneralGui getGeneralGui() {
        ChildGroup childGroup = (ChildGroup)this.children.get(221);
        if (childGroup.size() > 0) {
            return (GeneralGui)childGroup.get(0);
        }
        return null;
    }

    public void setGeneralGui(GeneralGui value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            GeneralGui obj = this.getGeneralGui();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ArbitrationPolicy getOptArbitrationPolicy() {
        ChildGroup childGroup = (ChildGroup)this.children.get(227);
        if (childGroup.size() > 0) {
            return (ArbitrationPolicy)childGroup.get(0);
        }
        return null;
    }

    public void setOptArbitrationPolicy(ArbitrationPolicy value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ArbitrationPolicy obj = this.getOptArbitrationPolicy();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 220;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getGeneralGui() == null) {
            throw new ValidationException("UserInterface/GeneralGui: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof GeneralGui) {
            try {
                this.setGeneralGui((GeneralGui)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ArbitrationPolicy) {
            try {
                this.setOptArbitrationPolicy((ArbitrationPolicy)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value != null) {
                this.setOptModeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getGeneralGui() != null) {
            this.getGeneralGui().setReadonly();
        }
        if (this.getOptArbitrationPolicy() != null) {
            this.getOptArbitrationPolicy().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(221)).size();
        }
        catch (Throwable t) {
            throw new SAXException("UserInterface: can't import element == GeneralGui!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"UserInterface".equals(element.getNodeName())) {
            throw new ValidationException("UserInterface: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value != null) {
            this.setOptModeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "GeneralGui")).size() != 1) {
            throw new ValidationException("UserInterface/GeneralGui: element is require!");
        }
        GeneralGui generalGuiObj = new GeneralGui();
        generalGuiObj.importFromElement(v.get(0));
        this.setGeneralGui(generalGuiObj);
        v = XMLHelper.getChildElementByName(element, "ArbitrationPolicy");
        if (v.size() > 0) {
            ArbitrationPolicy arbitrationPolicyObj = new ArbitrationPolicy();
            arbitrationPolicyObj.importFromElement(v.get(0));
            this.setOptArbitrationPolicy(arbitrationPolicyObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("UserInterface/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("UserInterface/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("UserInterface");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<UserInterface ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</UserInterface>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

