/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UnknownContent
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private byte[] content;

    public UnknownContent() {
        this(true);
    }

    public UnknownContent(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "UnkownContent";
    }

    public byte[] getContent() {
        return this.content == null ? null : (byte[])this.content.clone();
    }

    public void setConent(byte[] content) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.content = content == null ? null : (byte[])content.clone();
    }

    @Override
    public int getObjectType() {
        return 1;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.content == null) {
            throw new ValidationException("UnknownContent: content is required!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"UnknownContent".equals(element.getNodeName())) {
            throw new ValidationException("UnknownContent: can't import element(" + element.getNodeName() + ")!");
        }
        Element child = XMLHelper.getFirstChildElement(element);
        if (child == null) {
            throw new ValidationException("UnknownContent: child element is required!");
        }
        try {
            Document doc = XMLHelper.newDocument();
            doc.appendChild(XMLHelper.cloneElement(doc, child));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLHelper.serialize(doc, bos, true);
            bos.close();
            this.content = bos.toByteArray();
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("UnknownContent/ObsoleteItem/DeletedI: attribute is require!");
            }
            this.addObsoleteItem(new ObsoleteItem(deletedI));
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("UnknownContent");
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.content);
            Document newDoc = XMLHelper.parse(bis);
            bis.close();
            Element root = newDoc.getDocumentElement();
            element.appendChild(XMLHelper.cloneElement(doc, root));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        catch (SAXException e) {
            throw new ValidationException("UnknownContent: invalid content!");
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void initByAttributes(Attributes attributes) throws SAXException {
        try {
            this.readElement(attributes);
        }
        catch (ValidationException ve) {
            throw new SAXException(ve);
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void putTextContent(String content) throws SAXException {
    }

    @Override
    public void doSerialize(OutputStream os) throws ValidationException {
        try {
            StringBuffer sb = new StringBuffer("<UnknownContent _d=\"");
            sb.append(this.getD()).append("\" _i=\"");
            sb.append(this.getI()).append("\" _t=\"");
            sb.append(this.getT()).append("\" _v=\"");
            sb.append(this.getV()).append("\">");
            os.write(sb.toString().getBytes("UTF-8"));
            if (this.content != null) {
                try {
                    AbstractSchema unknownSchema = AbstractSchema.readXML(this.content);
                    XMLHelper.serialize(os, unknownSchema, true);
                }
                catch (Exception ex) {
                    os.write(this.content);
                }
            }
            os.write("</UnknownContent>".getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Override
    public Object clone() {
        UnknownContent obj = (UnknownContent)super.clone();
        if (this.content != null) {
            obj.content = (byte[])this.content.clone();
        }
        return obj;
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    protected void readElement(String _ia, boolean _da, long _ta, long _va) {
        super.readElement(_ia, _da, _ta, _va);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof UnknownContent) || !super.equals(obj)) {
            return false;
        }
        UnknownContent obj2 = (UnknownContent)obj;
        return Arrays.equals(this.content, obj2.content);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

