/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.I18n;
import com.sygate.scm.common.configobject.schema.WebContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UiAddOnItem
extends ConfigObject
implements NamedObject {
    public static final Integer SYS_ADMIN = 0;
    public static final Integer DOMAIN_ADMIN = 1;
    public static final Integer LIMITED_ADMIN = 2;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String iconPath;
    private String refId;
    private Integer allowRoles;
    private Boolean enabled;

    public UiAddOnItem() {
        this(true);
    }

    public UiAddOnItem(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(817, new ChildGroup(1, 1));
        this.children.put(424, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "UiAddOnItem";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    public String getOptIconPath() {
        return this.iconPath;
    }

    public void setOptIconPath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.iconPath = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Integer getAllowRoles() {
        return this.allowRoles;
    }

    public String getAllowRolesValue() throws ValidationException {
        if (this.allowRoles == null) {
            return null;
        }
        String s = null;
        switch (this.allowRoles) {
            case 0: {
                s = "SYS_ADMIN";
                break;
            }
            case 1: {
                s = "DOMAIN_ADMIN";
                break;
            }
            case 2: {
                s = "LIMITED_ADMIN";
                break;
            }
            default: {
                throw new ValidationException("UiAddOnItem/AllowRoles: invalid attribute value:" + this.allowRoles + "!");
            }
        }
        return s;
    }

    public void setAllowRoles(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowRoles = value;
    }

    public void setAllowRolesValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("SYS_ADMIN".equals(value)) {
            this.allowRoles = SYS_ADMIN;
        } else if ("DOMAIN_ADMIN".equals(value)) {
            this.allowRoles = DOMAIN_ADMIN;
        } else if ("LIMITED_ADMIN".equals(value)) {
            this.allowRoles = LIMITED_ADMIN;
        } else {
            throw new ValidationException("UiAddOnItem/AllowRoles: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public WebContent getWebContent() {
        ChildGroup childGroup = (ChildGroup)this.children.get(817);
        if (childGroup.size() > 0) {
            return (WebContent)childGroup.get(0);
        }
        return null;
    }

    public void setWebContent(WebContent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            WebContent obj = this.getWebContent();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public I18n getI18n() {
        ChildGroup childGroup = (ChildGroup)this.children.get(424);
        if (childGroup.size() > 0) {
            return (I18n)childGroup.get(0);
        }
        return null;
    }

    public void setI18n(I18n value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            I18n obj = this.getI18n();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 816;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("UiAddOnItem/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("UiAddOnItem/Name: attribute is required!");
        }
        if (this.allowRoles == null) {
            throw new ValidationException("UiAddOnItem/AllowRoles: attribute is required!");
        }
        if (this.enabled == null) {
            throw new ValidationException("UiAddOnItem/Enabled: attribute is required!");
        }
        if (this.getWebContent() == null) {
            throw new ValidationException("UiAddOnItem/WebContent: attribute is required!");
        }
        if (this.getI18n() == null) {
            throw new ValidationException("UiAddOnItem/I18n: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof WebContent) {
            try {
                this.setWebContent((WebContent)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof I18n) {
            try {
                this.setI18n((I18n)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("UiAddOnItem/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("UiAddOnItem/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("IconPath")) != null) {
                this.iconPath = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("AllowRoles")) == null) {
                throw new ValidationException("UiAddOnItem/AllowRoles: attribute is required!");
            }
            this.setAllowRolesValue(value);
            value = attris.getValue("Enabled");
            if (value == null) {
                throw new ValidationException("UiAddOnItem/Enabled: attribute is required!");
            }
            this.enabled = "1".equals(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getWebContent() != null) {
            this.getWebContent().setReadonly();
        }
        if (this.getI18n() != null) {
            this.getI18n().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(817)).size();
        }
        catch (Throwable t) {
            throw new SAXException("UiAddOnItem: can't import element == WebContent!");
        }
        try {
            ((ChildGroup)this.children.get(424)).size();
        }
        catch (Throwable t) {
            throw new SAXException("UiAddOnItem: can't import element == I18n!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"UiAddOnItem".equals(element.getNodeName())) {
            throw new ValidationException("UiAddOnItem: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("UiAddOnItem/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("UiAddOnItem/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "IconPath")) != null) {
            this.iconPath = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowRoles")) == null) {
            throw new ValidationException("UiAddOnItem/AllowRoles: attribute is required!");
        }
        this.setAllowRolesValue(value);
        value = XMLHelper.getAttribute(element, "Enabled");
        if (value == null) {
            throw new ValidationException("UiAddOnItem/Enabled: attribute is required!");
        }
        this.enabled = "1".equals(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "WebContent");
        if (v.size() != 1) {
            throw new ValidationException("UiAddOnItem/WebContent: element is require!");
        }
        WebContent webContentObj = new WebContent();
        webContentObj.importFromElement(v.get(0));
        this.setWebContent(webContentObj);
        v = XMLHelper.getChildElementByName(element, "I18n");
        if (v.size() != 1) {
            throw new ValidationException("UiAddOnItem/I18n: element is require!");
        }
        I18n i18nObj = new I18n();
        i18nObj.importFromElement(v.get(0));
        this.setI18n(i18nObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("UiAddOnItem/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("UiAddOnItem/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("UiAddOnItem");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.iconPath != null) {
            element.setAttribute("IconPath", this.iconPath);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.allowRoles != null) {
            element.setAttribute("AllowRoles", this.getAllowRolesValue());
        }
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<UiAddOnItem ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.iconPath != null) {
                strAttrs.append("IconPath=\"").append(AbstractSchema.checkXMLContent(this.iconPath)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.allowRoles != null) {
                strAttrs.append("AllowRoles=\"").append(this.getAllowRolesValue()).append("\" ");
            }
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</UiAddOnItem>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

