/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CategoryField;
import com.sygate.scm.common.configobject.schema.EnvTelData;
import com.sygate.scm.common.configobject.schema.LocalTelData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TelemetryDataDictionary
extends TopLevelObject {
    private static final long serialVersionUID = 1L;
    private String id;

    public TelemetryDataDictionary() {
        this(true);
    }

    public TelemetryDataDictionary(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(39, new ChildGroup(0, 1));
        this.children.put(40, new ChildGroup(0, 1));
        this.children.put(41, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "TelemetryDataDictionary";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public LocalTelData getOptLocalTelData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(39);
        if (childGroup.size() > 0) {
            return (LocalTelData)childGroup.get(0);
        }
        return null;
    }

    public void setOptLocalTelData(LocalTelData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LocalTelData obj = this.getOptLocalTelData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public EnvTelData getOptEnvTelData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(40);
        if (childGroup.size() > 0) {
            return (EnvTelData)childGroup.get(0);
        }
        return null;
    }

    public void setOptEnvTelData(EnvTelData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            EnvTelData obj = this.getOptEnvTelData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addCategoryField(CategoryField value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addCategoryField(int index, CategoryField value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<CategoryField> getCategoryField() {
        Vector<CategoryField> v = new Vector<CategoryField>();
        for (Transportable child : (ChildGroup)this.children.get(41)) {
            v.add((CategoryField)child);
        }
        return v;
    }

    public int getCategoryFieldCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(41);
        return childGroup.size();
    }

    public CategoryField getCategoryField(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(41);
        return (CategoryField)childGroup.get(index);
    }

    public void setCategoryField(int index, CategoryField value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeCategoryField(CategoryField value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 38;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("TelemetryDataDictionary/Id: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof LocalTelData) {
            try {
                this.setOptLocalTelData((LocalTelData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof EnvTelData) {
            try {
                this.setOptEnvTelData((EnvTelData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof CategoryField) {
            try {
                this.addCategoryField((CategoryField)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("TelemetryDataDictionary/Id: attribute is required!");
            }
            this.id = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getOptLocalTelData() != null) {
            this.getOptLocalTelData().setReadonly();
        }
        if (this.getOptEnvTelData() != null) {
            this.getOptEnvTelData().setReadonly();
        }
        int objCnt = this.getCategoryFieldCount();
        for (i = 0; i < objCnt; ++i) {
            this.getCategoryField(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TelemetryDataDictionary".equals(element.getNodeName())) {
            throw new ValidationException("TelemetryDataDictionary: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("TelemetryDataDictionary/Id: attribute is required!");
        }
        this.id = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "LocalTelData");
        if (v.size() > 0) {
            LocalTelData localTelDataObj = new LocalTelData();
            localTelDataObj.importFromElement(v.get(0));
            this.setOptLocalTelData(localTelDataObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "EnvTelData")).size() > 0) {
            EnvTelData envTelDataObj = new EnvTelData();
            envTelDataObj.importFromElement(v.get(0));
            this.setOptEnvTelData(envTelDataObj);
        }
        v = XMLHelper.getChildElementByName(element, "CategoryField");
        for (int i = 0; i < v.size(); ++i) {
            CategoryField categoryFieldObj = new CategoryField();
            categoryFieldObj.importFromElement(v.get(i));
            this.addCategoryField(categoryFieldObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("TelemetryDataDictionary/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("TelemetryDataDictionary/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("TelemetryDataDictionary");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TelemetryDataDictionary ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TelemetryDataDictionary>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

