/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TelemetryDataConfigSettings
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean optInValue;
    private Integer defaultDataCollectionInterval;
    private Boolean enableAnonymousTransfer;
    private Boolean enableInitialRandomDelay;

    public TelemetryDataConfigSettings() {
        this(true);
    }

    public TelemetryDataConfigSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "TelemetryDataConfigSettings";
    }

    public Boolean getDefOptInValue() {
        return Boolean.TRUE;
    }

    public Boolean getOptInValue() {
        return this.optInValue;
    }

    public void setOptInValue(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.optInValue = value;
    }

    public Integer getDefDefaultDataCollectionInterval() {
        return 7;
    }

    public Integer getDefaultDataCollectionInterval() {
        return this.defaultDataCollectionInterval;
    }

    public void setDefaultDataCollectionInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.defaultDataCollectionInterval = value;
    }

    public Boolean getDefEnableAnonymousTransfer() {
        return Boolean.TRUE;
    }

    public Boolean getEnableAnonymousTransfer() {
        return this.enableAnonymousTransfer;
    }

    public void setEnableAnonymousTransfer(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableAnonymousTransfer = value;
    }

    public Boolean getDefEnableInitialRandomDelay() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnableInitialRandomDelay() {
        return this.enableInitialRandomDelay;
    }

    public void setOptEnableInitialRandomDelay(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableInitialRandomDelay = value;
    }

    @Override
    public int getObjectType() {
        return 27;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.optInValue == null) {
            throw new ValidationException("TelemetryDataConfigSettings/OptInValue: attribute is required!");
        }
        if (this.defaultDataCollectionInterval == null) {
            throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: attribute is required!");
        }
        if (this.enableAnonymousTransfer == null) {
            throw new ValidationException("TelemetryDataConfigSettings/EnableAnonymousTransfer: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("OptInValue");
            if (value == null) {
                throw new ValidationException("TelemetryDataConfigSettings/OptInValue: attribute is required!");
            }
            this.optInValue = "1".equals(value);
            value = attris.getValue("DefaultDataCollectionInterval");
            if (value == null) {
                throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: attribute is required!");
            }
            try {
                this.defaultDataCollectionInterval = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("EnableAnonymousTransfer");
            if (value == null) {
                throw new ValidationException("TelemetryDataConfigSettings/EnableAnonymousTransfer: attribute is required!");
            }
            this.enableAnonymousTransfer = "1".equals(value);
            value = attris.getValue("EnableInitialRandomDelay");
            if (value != null) {
                this.enableInitialRandomDelay = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TelemetryDataConfigSettings".equals(element.getNodeName())) {
            throw new ValidationException("TelemetryDataConfigSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "OptInValue");
        if (value == null) {
            throw new ValidationException("TelemetryDataConfigSettings/OptInValue: attribute is required!");
        }
        this.optInValue = "1".equals(value);
        value = XMLHelper.getAttribute(element, "DefaultDataCollectionInterval");
        if (value == null) {
            throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: attribute is required!");
        }
        try {
            this.defaultDataCollectionInterval = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("TelemetryDataConfigSettings/DefaultDataCollectionInterval: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "EnableAnonymousTransfer");
        if (value == null) {
            throw new ValidationException("TelemetryDataConfigSettings/EnableAnonymousTransfer: attribute is required!");
        }
        this.enableAnonymousTransfer = "1".equals(value);
        value = XMLHelper.getAttribute(element, "EnableInitialRandomDelay");
        if (value != null) {
            this.enableInitialRandomDelay = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("TelemetryDataConfigSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("TelemetryDataConfigSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("TelemetryDataConfigSettings");
        if (this.optInValue != null) {
            element.setAttribute("OptInValue", this.optInValue != false ? "1" : "0");
        }
        if (this.defaultDataCollectionInterval != null) {
            element.setAttribute("DefaultDataCollectionInterval", this.defaultDataCollectionInterval.toString());
        }
        if (this.enableAnonymousTransfer != null) {
            element.setAttribute("EnableAnonymousTransfer", this.enableAnonymousTransfer != false ? "1" : "0");
        }
        if (this.enableInitialRandomDelay != null) {
            element.setAttribute("EnableInitialRandomDelay", this.enableInitialRandomDelay != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TelemetryDataConfigSettings ");
            if (this.optInValue != null) {
                strAttrs.append("OptInValue=").append(this.optInValue != false ? "\"1\" " : "\"0\" ");
            }
            if (this.defaultDataCollectionInterval != null) {
                strAttrs.append("DefaultDataCollectionInterval=\"").append(this.defaultDataCollectionInterval.toString()).append("\" ");
            }
            if (this.enableAnonymousTransfer != null) {
                strAttrs.append("EnableAnonymousTransfer=").append(this.enableAnonymousTransfer != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableInitialRandomDelay != null) {
                strAttrs.append("EnableInitialRandomDelay=").append(this.enableInitialRandomDelay != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TelemetryDataConfigSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

