/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TdadData
extends ConfigObject
implements NamedObject {
    private static final long serialVersionUID = 1L;
    private String aDDomainUid;
    private String name;
    private String value;
    private String refId;
    private String description;

    public TdadData() {
        this(true);
    }

    public TdadData(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "TdadData";
    }

    public String getADDomainUid() {
        return this.aDDomainUid;
    }

    public void setADDomainUid(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.aDDomainUid = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.value = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public int getObjectType() {
        return 330;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.aDDomainUid == null) {
            throw new ValidationException("TdadData/ADDomainUid: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("TdadData/Name: attribute is required!");
        }
        if (this.value == null) {
            throw new ValidationException("TdadData/Value: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ADDomainUid");
            if (value == null) {
                throw new ValidationException("TdadData/ADDomainUid: attribute is required!");
            }
            this.aDDomainUid = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("TdadData/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Value");
            if (value == null) {
                throw new ValidationException("TdadData/Value: attribute is required!");
            }
            this.value = value;
            value = attris.getValue("RefId");
            if (value != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Description")) != null) {
                this.description = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TdadData".equals(element.getNodeName())) {
            throw new ValidationException("TdadData: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ADDomainUid");
        if (value == null) {
            throw new ValidationException("TdadData/ADDomainUid: attribute is required!");
        }
        this.aDDomainUid = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("TdadData/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Value");
        if (value == null) {
            throw new ValidationException("TdadData/Value: attribute is required!");
        }
        this.value = value;
        value = XMLHelper.getAttribute(element, "RefId");
        if (value != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Description")) != null) {
            this.description = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("TdadData/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("TdadData/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("TdadData");
        if (this.aDDomainUid != null) {
            element.setAttribute("ADDomainUid", this.aDDomainUid);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.value != null) {
            element.setAttribute("Value", this.value);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TdadData ");
            if (this.aDDomainUid != null) {
                strAttrs.append("ADDomainUid=\"").append(AbstractSchema.checkXMLContent(this.aDDomainUid)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.value != null) {
                strAttrs.append("Value=\"").append(AbstractSchema.checkXMLContent(this.value)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TdadData>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

